/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class CapellaCategoryServices {
    public static String edgeToTableLine(NamedElement edge, String projectName, String outputFolder) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr>");
        buffer.append("<td id=\"" + CapellaServices.getAnchorId((EObject)edge) + "\">");
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)edge, projectName, outputFolder));
        buffer.append(" ");
        NamedElement ne = edge;
        buffer.append(ne.getName());
        buffer.append("</td><td>");
        EObject source = null;
        EObject target = null;
        if (edge instanceof FunctionalExchange) {
            FunctionalExchange fe = (FunctionalExchange)edge;
            source = fe.getSource().eContainer();
            target = fe.getTarget().eContainer();
        } else if (edge instanceof ComponentExchange) {
            ComponentExchange ce = (ComponentExchange)edge;
            source = ce.getSource().eContainer();
            target = ce.getTarget().eContainer();
        } else if (edge instanceof PhysicalLink) {
            PhysicalLink pl = (PhysicalLink)edge;
            source = pl.getSourcePhysicalPort().eContainer();
            target = pl.getTargetPhysicalPort().eContainer();
        }
        buffer.append(CapellaServices.getImageLinkFromElement(source, projectName, outputFolder));
        buffer.append(" ");
        buffer.append(CapellaServices.getHyperlinkFromElement(source));
        buffer.append("</td><td>");
        buffer.append(CapellaServices.getImageLinkFromElement(target, projectName, outputFolder));
        buffer.append(" ");
        buffer.append(CapellaServices.getHyperlinkFromElement(target));
        buffer.append("</td><td>");
        if (edge.getDescription() != null) {
            buffer.append(StringUtil.transformAREFString((EObject)edge, edge.getDescription(), projectName, outputFolder));
        } else {
            buffer.append("");
        }
        buffer.append("</td></tr>");
        return buffer.toString();
    }
}

