/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.behavior.TimeExpression;
import org.polarsys.capella.common.data.modellingcore.AbstractConstraint;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.ValueSpecification;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.OpaqueExpression;
import org.polarsys.capella.core.linkedtext.ui.CapellaEmbeddedLinkedTextEditorInput;
import org.polarsys.capella.docgen.util.CapellaDataValueServices;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class ConstraintsService {
    public static List<AbstractConstraint> getAppliedAndNotOwnedConstraints(CapellaElement element) {
        EList ownedConstraints = element.getOwnedConstraints();
        return element.getConstraints().stream().filter(arg_0 -> ConstraintsService.lambda$0((List)ownedConstraints, arg_0)).collect(Collectors.toList());
    }

    public static String getConstraintName(AbstractConstraint constraint) {
        String constraintName = "";
        if (constraint instanceof Constraint) {
            constraintName = ((Constraint)constraint).getName();
        }
        if (constraintName == null || constraintName.isEmpty()) {
            constraintName = "<i>[No Name]</i>";
        }
        return constraintName;
    }

    public static String getConstrainedElement(Constraint constraint, String projectName, String outputFolder) {
        EList constrainedElements = constraint.getConstrainedElements();
        ArrayList<String> result = new ArrayList<String>();
        for (ModelElement modelElement : constrainedElements) {
            String imageLinkFromElement = CapellaServices.getImageLinkFromElement((EObject)modelElement, projectName, outputFolder);
            String hyperlinkFromElement = CapellaServices.getHyperlinkFromElement((EObject)modelElement);
            result.add(String.valueOf(imageLinkFromElement) + " " + hyperlinkFromElement);
        }
        String result_s = StringUtil.stringListToBulette(result);
        return !result_s.isEmpty() ? result_s : "No constrained elements";
    }

    public static String getValueSpecification(ValueSpecification valueSpecification, String projectName, String outputFolder) {
        if (valueSpecification == null) {
            return "[No value specification]";
        }
        if (valueSpecification instanceof DataValue) {
            DataValue dataValue_p = (DataValue)valueSpecification;
            return CapellaDataValueServices.getDataValueInformation(dataValue_p, projectName, outputFolder);
        }
        if (valueSpecification instanceof OpaqueExpression) {
            String result = "";
            OpaqueExpression expression = (OpaqueExpression)valueSpecification;
            EList languages = expression.getLanguages();
            if (!languages.isEmpty()) {
                int i = 0;
                while (i < languages.size()) {
                    String language = (String)languages.get(i);
                    result = String.valueOf(result) + "<b>";
                    result = String.valueOf(result) + (language.equals("capella:linkedText") ? "LinkedText" : language);
                    result = String.valueOf(result) + " : ";
                    result = String.valueOf(result) + "</b>";
                    result = String.valueOf(result) + "<br/>";
                    result = String.valueOf(result) + ConstraintsService.getOpaqueExpressionValue(expression, i);
                    if (i + 1 < languages.size()) {
                        result = String.valueOf(result) + "<br/>";
                    }
                    ++i;
                }
            }
            return result;
        }
        if (valueSpecification instanceof TimeExpression) {
            String result = "";
            return result;
        }
        return "[Unknown value specification]";
    }

    private static String getOpaqueExpressionValue(OpaqueExpression exp, int index) {
        String result = "<pre>";
        if ("capella:linkedText".equals(exp.getLanguages().get(index))) {
            CapellaEmbeddedLinkedTextEditorInput.Readonly input = new CapellaEmbeddedLinkedTextEditorInput.Readonly((EObject)exp, (String)exp.getBodies().get(index));
            result = String.valueOf(result) + LinkedTextDocument.load((LinkedTextDocument.Input)input).get();
            input.dispose();
        } else {
            result = String.valueOf(result) + (String)exp.getBodies().get(index);
        }
        result = String.valueOf(result) + "</pre>";
        return result;
    }

    private static /* synthetic */ boolean lambda$0(List list, AbstractConstraint c) {
        return !list.contains(c);
    }
}

