/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyValue;
import org.polarsys.capella.core.data.information.CollectionValueReference;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.UnionProperty;
import org.polarsys.capella.core.data.information.datavalue.BooleanReference;
import org.polarsys.capella.core.data.information.datavalue.ComplexValueReference;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.EnumerationReference;
import org.polarsys.capella.core.data.information.datavalue.NumericReference;
import org.polarsys.capella.core.data.information.datavalue.StringReference;
import org.polarsys.capella.core.data.information.datavalue.ValuePart;
import org.polarsys.capella.docgen.util.CapellaDataValueServices;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;
import org.polarsys.kitalpha.doc.gen.business.core.util.EObjectLabelProviderHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.LabelProviderHelper;

public class CapellaPropertyServices {
    public static String getPropertyValueInformation(AbstractPropertyValue prop_p, String projectName, String outputFolder) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)prop_p, projectName, outputFolder));
        buffer.append(" ");
        buffer.append("<b>");
        buffer.append(prop_p.getName());
        buffer.append("</b>");
        buffer.append(" = ");
        buffer.append(CapellaPropertyServices.getValueFromPropertyValue(prop_p));
        return buffer.toString();
    }

    public static String getValuePartInformation(ValuePart valuepart_p, String projectName, String outputFolder) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)valuepart_p, projectName, outputFolder));
        buffer.append(" ");
        buffer.append("<b>");
        Property referencedProperty = valuepart_p.getReferencedProperty();
        String referencedPropertyLink = "&ltundefined&gt";
        if (referencedProperty != null) {
            referencedPropertyLink = CapellaServices.getHyperlinkFromElement((EObject)referencedProperty);
        }
        buffer.append("Value for " + referencedPropertyLink);
        buffer.append("</b>");
        return buffer.toString();
    }

    public static String getPropertyValueInformation(EnumerationPropertyValue prop_p) {
        if (prop_p.getType() != null && prop_p.getValue() != null && "".equals(prop_p.getValue())) {
            return String.valueOf(CapellaServices.getHyperlinkFromElement((EObject)prop_p)) + " : " + prop_p.getType().getName() + "." + prop_p.getValue();
        }
        return CapellaServices.getHyperlinkFromElement((EObject)prop_p);
    }

    public static String getInformationFromProperty(Property prop_p, String projectName, String outputFolder) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)prop_p, projectName, outputFolder));
        buffer.append(" ");
        buffer.append("<b>");
        if (prop_p.isIsAbstract()) {
            buffer.append("{abstract}  ");
        }
        if (prop_p.isIsStatic()) {
            buffer.append("{static}  ");
        }
        if (prop_p.isIsPartOfKey()) {
            buffer.append("{key}  ");
        }
        if (prop_p.getAggregationKind().getValue() == 1) {
            buffer.append("{ref}  ");
        }
        if (prop_p.isIsDerived()) {
            buffer.append("{derived}  ");
        }
        if (prop_p.isIsReadOnly()) {
            buffer.append("{readonly}  ");
        }
        if (prop_p.isOrdered()) {
            buffer.append("{ordered}  ");
        }
        if (prop_p.isUnique()) {
            buffer.append("{unique}  ");
        }
        buffer.append("</b>");
        buffer.append(" ");
        buffer.append("<b>");
        buffer.append(prop_p.getName());
        if (prop_p.getOwnedMinCard() != null && prop_p.getOwnedMaxCard() != null) {
            buffer.append("[");
            buffer.append(CapellaDataValueServices.getSimpleValueOfDataValue((DataValue)prop_p.getOwnedMinCard()));
            buffer.append(", ");
            buffer.append(CapellaDataValueServices.getSimpleValueOfDataValue((DataValue)prop_p.getOwnedMaxCard()));
            buffer.append("]");
        }
        buffer.append("</b>");
        buffer.append(" : ");
        if (prop_p.getType() != null) {
            buffer.append(CapellaServices.getFullDataPkgHierarchyLink((EObject)prop_p.getType()));
        }
        if (prop_p instanceof UnionProperty) {
            String qualifier = CapellaPropertyServices.computeUnionPropertyLabelWithQualifier((UnionProperty)prop_p);
            buffer.append(qualifier);
        }
        if (prop_p.getDescription() != null) {
            buffer.append("<p>");
            buffer.append(StringUtil.transformAREFString((EObject)prop_p, prop_p.getDescription(), projectName, outputFolder));
            buffer.append("</p>");
        }
        ArrayList<String> features = new ArrayList<String>();
        if (prop_p.getOwnedMinValue() != null) {
            features.add("<b>Min\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue(prop_p.getOwnedMinValue()));
        }
        if (prop_p.getOwnedMaxValue() != null) {
            features.add("<b>Max\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue(prop_p.getOwnedMaxValue()));
        }
        if (prop_p.getOwnedMinLength() != null) {
            features.add("<b>Min. length\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue((DataValue)prop_p.getOwnedMinLength()));
        }
        if (prop_p.getOwnedMaxLength() != null) {
            features.add("<b>Max. length\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue((DataValue)prop_p.getOwnedMaxLength()));
        }
        if (prop_p.getOwnedDefaultValue() != null) {
            features.add("<b>Default\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue(prop_p.getOwnedDefaultValue()));
        }
        if (prop_p.getOwnedNullValue() != null) {
            features.add("<b>Null\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue(prop_p.getOwnedNullValue()));
        }
        buffer.append("<ul class=\"generatedList\">");
        for (String featureString : features) {
            buffer.append("<li>" + featureString + "</li>");
        }
        String propertyValues = CapellaPropertyServices.getPropertyValues((EList<AbstractPropertyValue>)prop_p.getOwnedPropertyValues(), projectName, outputFolder);
        if (propertyValues != null && propertyValues.length() > 0) {
            buffer.append(propertyValues);
        }
        buffer.append("</ul>");
        return buffer.toString();
    }

    public static String getPropertyValues(EList<AbstractPropertyValue> ownedPropertyValues, String projectName, String outputFolder) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> propertiesValues = new ArrayList<String>();
        for (AbstractPropertyValue currentAbstractPropertyValue : ownedPropertyValues) {
            propertiesValues.add(CapellaPropertyServices.getPropertyValueInformation(currentAbstractPropertyValue, projectName, outputFolder));
        }
        if (propertiesValues.size() > 0) {
            buffer.append("<li>");
            buffer.append("Property-values");
            buffer.append(StringUtil.stringListToBulette(propertiesValues));
            buffer.append("</li>");
        }
        return buffer.toString();
    }

    private static String computeUnionPropertyLabelWithQualifier(UnionProperty property_p) {
        String result = "";
        EList qualifier = property_p.getQualifier();
        if (qualifier != null && qualifier.size() > 0) {
            result = String.valueOf(result) + " { ";
            int i = 0;
            while (i < qualifier.size()) {
                DataValue element = (DataValue)qualifier.get(i);
                result = String.valueOf(result) + CapellaPropertyServices.getDataValueText(element, i == qualifier.size() - 1);
                ++i;
            }
            result = String.valueOf(result) + " }";
        }
        return result;
    }

    private static String getDataValueText(DataValue dataValue, boolean last) {
        if (CapellaPropertyServices.ignoreDataValue(dataValue)) {
            return String.valueOf(EObjectLabelProviderHelper.getText((EObject)dataValue)) + (last ? "" : ", ");
        }
        return String.valueOf(CapellaServices.getHyperlinkFromElement((EObject)dataValue)) + (last ? "" : ", ");
    }

    private static boolean ignoreDataValue(DataValue element) {
        return element instanceof BooleanReference || element instanceof NumericReference || element instanceof EnumerationReference || element instanceof StringReference || element instanceof ComplexValueReference || element instanceof CollectionValueReference;
    }

    private static String getValueFromPropertyValue(AbstractPropertyValue propertyValue) {
        Method methodGetValue = null;
        try {
            methodGetValue = propertyValue.getClass().getMethod("getValue", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                methodGetValue = propertyValue.getClass().getMethod("isValue", new Class[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (methodGetValue != null) {
            try {
                Object object = methodGetValue.invoke((Object)propertyValue, new Object[0]);
                if (object instanceof EObject) {
                    return LabelProviderHelper.getText((EObject)((EObject)object));
                }
                if (object != null) {
                    return object.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }
}

