/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.helper;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.diagram.helpers.RepresentationAnnotationHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.ui.metric.utils.ProgressMonitoringPropagator;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.kitalpha.doc.gen.business.core.scope.GenerationGlobalScope;
import org.polarsys.kitalpha.doc.gen.business.core.util.LabelProviderHelper;

public class ProgressHelper {
    private static final DataContentProvider dataProvider = new DataContentProvider();
    private static final String TABLE_ID = "progress-overview-table";
    private String projectName;
    private String outputFolder;

    public ProgressHelper(String projectName, String outputFolder) {
        this.projectName = projectName;
        this.outputFolder = outputFolder;
    }

    public String generateProgressTable(EObject element) {
        StringBuffer result = new StringBuffer();
        result.append(this.generateSearchArea(element));
        result.append("<table id=\"").append(TABLE_ID).append("\">");
        result.append(this.generateExpandCollapsAction(TABLE_ID));
        result.append(this.generateTableHeader());
        result.append(this.generateTableBody(element));
        result.append("</table>");
        result.append(this.generateCustomStype());
        result.append(this.getTreeTablePluginIntegration(TABLE_ID));
        result.append(this.getSearchJavascriptFucntions());
        return result.toString();
    }

    public String generateExpandCollapsAction(String tableID) {
        StringBuffer result = new StringBuffer();
        result.append("<img class=\"cebutton\" src=\"../../img/closed.gif\" alt=\"Collapse all\" onclick=\"jQuery('#progress-overview-table').treetable('expandAll'); return false;\"/>");
        result.append("<img class=\"cebutton\" src=\"../../img/open.gif\" alt=\"Collapse all\" onclick=\"jQuery('#progress-overview-table').treetable('collapseAll'); return false;\"/>");
        return result.toString();
    }

    public String generateSearchArea(EObject element) {
        StringBuffer result = new StringBuffer();
        result.append("<label for=\"filter-object\">Object:</label>");
        result.append("<input class=\"search\" type=\"text\" id=\"filter-object\" onkeyup=\"multiSearch()\" placeholder=\"Search Object by name..\">");
        result.append("<label for=\"filter-status\">Status:</label>");
        result.append("<select class=\"search\" id=\"filter-status\" style=\"min-width:60px\" onchange=\"multiSearch()\">");
        result.append("\t<option value=\"\">- All -</option>");
        EnumerationPropertyType progressStatus = CapellaProjectHelper.getEnumerationPropertyType((EObject)element, (String)"ProgressStatus");
        progressStatus.getOwnedLiterals().forEach(literal -> result.append("\t<option value=\"").append(literal.getName()).append("\">").append(literal.getName()).append("</option>"));
        result.append("</select>");
        result.append("<label for=\"filter-review\">Review:</label>");
        result.append("<input class=\"search\" type=\"text\" id=\"filter-review\" onkeyup=\"multiSearch()\" placeholder=\"Search in review..\">");
        return result.toString();
    }

    public String generateCustomStype() {
        StringBuffer result = new StringBuffer();
        result.append("<style>");
        result.append("\t.search {width: 160;height: 30px;border-radius: 3px;border: 1px solid #000000; margin: 15px}");
        result.append("\t.search input {width: 120px;padding: 10px 5px;float: left;color: #ccc;border: 0;background: transparent;border-radius: 3px 0 0 3px;}");
        result.append("\t.cebutton {width: 20px;padding: 20px 5px;float: right;}");
        result.append("</style>");
        return result.toString();
    }

    public String getTreeTablePluginIntegration(String tableID) {
        StringBuffer result = new StringBuffer();
        result.append("<script src=\"../../scripts/jquery-treeview/lib/jquery-1.11.1.js\"></script>");
        result.append("<script src=\"../../scripts/jquery-treetable/jquery.treetable.js\"></script>");
        result.append("<link href=\"../../scripts/jquery-treetable/css/jquery.treetable.css\" rel=\"stylesheet\" type=\"text/css\" />");
        result.append("<link href=\"../../scripts/jquery-treetable/css/jquery.treetable.theme.default.css\" rel=\"stylesheet\" type=\"text/css\" />");
        result.append("<script>");
        result.append("\t$(\"#").append(tableID).append("\").treetable({ expandable: true});");
        result.append("\t$(\"#").append(tableID).append(" tbody\").on(\"mousedown\", \"tr\", function() {");
        result.append("\t\t$(\".selected\").not(this).removeClass(\"selected\");");
        result.append("\t\t$(this).toggleClass(\"selected\");");
        result.append("\t});");
        result.append("</script>");
        return result.toString();
    }

    public String getSearchJavascriptFucntions() {
        StringBuffer result = new StringBuffer();
        result.append("<script>");
        result.append("\tfunction multiSearch() {");
        result.append("\t\t$(\"#progress-overview-table\").treetable(\"expandAll\");");
        result.append("\t\tfilterName   = document.getElementById('filter-object').value.toUpperCase();");
        result.append("\t\tfilterStatus = document.getElementById('filter-status').value.toUpperCase();");
        result.append("\t\tfilterReview = document.getElementById('filter-review').value.toUpperCase();");
        result.append("\t\ttable = document.getElementById(\"progress-overview-table\");");
        result.append("\t\ttr = table.getElementsByTagName(\"tr\");");
        result.append("\t\tfor (i = 1; i < tr.length; i++) {");
        result.append("\t\t\ttdStatus = tr[i].getElementsByTagName(\"td\")[1];");
        result.append("\t\t\tif (tdStatus) {");
        result.append("\t\t\t\tstatus = tdStatus.textContent || tdStatus.innerText;");
        result.append("\t\t\t\tif (filterStatus.toUpperCase().indexOf(status) > -1) {");
        result.append("\t\t\t\t\tdoDisplay=true;");
        result.append("\t\t\t\t} else {");
        result.append("\t\t\t\t\tif (filterStatus===\"\") {");
        result.append("\t\t\t\t\t\tdoDisplay=true;");
        result.append("\t\t\t\t\t} else {");
        result.append("\t\t\t\t\t\tdoDisplay=false;");
        result.append("\t\t\t\t\t}");
        result.append("\t\t\t\t}");
        result.append("\t\t\t}");
        result.append("\t\t\ttdObject = tr[i].getElementsByTagName(\"td\")[0];");
        result.append("\t\t\tif (tdObject) {");
        result.append("\t\t\t\tdoDisplay = doDisplay && checkValue(tdObject, filterName);");
        result.append("\t\t\t} ");
        result.append("\t\t\ttdReview = tr[i].getElementsByTagName(\"td\")[2];");
        result.append("\t\t\tif (tdObject) {");
        result.append("\t\t\t\tdoDisplay = doDisplay && checkValue(tdReview, filterReview);");
        result.append("\t\t\t} \t\t\t");
        result.append("\t\t\tif (doDisplay) {");
        result.append("\t\t\t\ttr[i].style.display = \"\";");
        result.append("\t\t\t} else {");
        result.append("\t\t\t\ttr[i].style.display = \"none\";");
        result.append("\t\t\t}");
        result.append("\t\t}");
        result.append("\t}");
        result.append("\tfunction checkValue(td, filter){");
        result.append("\t\ttxtValue = td.textContent || td.innerText;");
        result.append("\t\tif (txtValue && txtValue.toUpperCase().indexOf(filter) > -1) {");
        result.append("\t\t\treturn true;");
        result.append("\t\t} else {");
        result.append("\t\t\tif (filter===\"\") {");
        result.append("\t\t\t\treturn true;");
        result.append("\t\t\t} else {");
        result.append("\t\t\t\treturn false;");
        result.append("\t\t\t}");
        result.append("\t\t}");
        result.append("\t}");
        result.append("</script>");
        return result.toString();
    }

    public String generateTableHeader() {
        StringBuffer result = new StringBuffer();
        result.append("<thead>");
        result.append("<tr>");
        result.append("<th>Object</th>");
        result.append("<th>Status</th>");
        result.append("<th>Review</th>");
        result.append("</tr>");
        result.append("</thead>");
        return result.toString();
    }

    public String generateTableBody(EObject element) {
        StringBuffer result = new StringBuffer();
        List allTaggedObjects = ProgressMonitoringPropagator.getInstance().getTaggedObjects(EcoreUtil.getRootContainer((EObject)element));
        List taggedObjects = allTaggedObjects.stream().filter(eObject -> {
            if (GenerationGlobalScope.getInstance().inScope(eObject, true)) {
                return true;
            }
            if (eObject instanceof DRepresentationDescriptor) {
                EObject target = ((DRepresentationDescriptor)eObject).getTarget();
                return GenerationGlobalScope.getInstance().inScope(target, true);
            }
            return false;
        }).collect(Collectors.toList());
        TreeData treeData = new TreeData(taggedObjects, null);
        dataProvider.inputChanged(null, null, (Object)treeData);
        Object[] elements = dataProvider.getElements((Object)element);
        result.append("<tbody>");
        result.append(this.generateSubElementTableLines(elements, null));
        result.append("</tbody>");
        return result.toString();
    }

    public String generateSubElementTableLines(Object[] elements, String parentID) {
        StringBuffer result = new StringBuffer();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            result.append(this.generateElementHtmlLine(element, parentID));
            String elementID = this.getID(element);
            String content = this.generateSubElementTableLines(dataProvider.getChildren(element), elementID);
            result.append(content);
            ++n2;
        }
        return result.toString();
    }

    public String generateElementHtmlLine(Object element, String parentID) {
        String[] exportableData = this.getExportableData(element);
        if (parentID != null && exportableData[0].equals(parentID)) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        result.append("<tr data-tt-id=\"").append(exportableData[0]).append("\"");
        if (parentID != null && ((EObject)element).eContainer() != null) {
            result.append(" data-tt-parent-id=\"").append(parentID).append("\"");
        }
        result.append(">");
        result.append("<td>").append(exportableData[1]).append("</td>");
        result.append("<td>").append(exportableData[2]).append("</td>");
        result.append("<td>").append(exportableData[3]).append("</td>");
        result.append("</tr>");
        return result.toString();
    }

    protected String[] getExportableData(Object current) {
        if (current instanceof CapellaElement) {
            CapellaElement ce = (CapellaElement)current;
            return new String[]{this.getID(ce), this.getLabel(ce), ce.getStatus() == null ? "" : ce.getStatus().getLabel(), ce.getReview() == null ? "" : ce.getReview()};
        }
        if (current instanceof DRepresentationDescriptor) {
            DRepresentationDescriptor representationDesc = (DRepresentationDescriptor)current;
            DRepresentation dRepresentation = representationDesc.getRepresentation();
            EnumerationPropertyLiteral status = RepresentationAnnotationHelper.getProgressStatus((DRepresentationDescriptor)representationDesc);
            String review = RepresentationAnnotationHelper.getStatusReview((DRepresentationDescriptor)representationDesc);
            EObject target = representationDesc.getTarget();
            if (target != null) {
                return new String[]{this.getID(dRepresentation), this.getLabel(dRepresentation), status == null ? "" : status.getLabel(), review == null ? "" : review};
            }
        } else if (current instanceof DAnalysis || current instanceof DView) {
            return new String[]{this.getID(current), this.getLabel(current), "", ""};
        }
        return new String[]{"", "", "", ""};
    }

    private String getLabel(Object element) {
        StringBuffer result = new StringBuffer();
        result.append(CapellaServices.getImageLinkFromElement((EObject)element, this.projectName, this.outputFolder));
        result.append(" ");
        if (element instanceof CapellaElement || element instanceof DSemanticDiagram) {
            result.append(CapellaServices.getHyperlinkFromElement((EObject)element));
        } else if (element instanceof DAnalysis) {
            result.append("DAnalysis " + ((DAnalysis)element).getVersion());
        } else if (element instanceof DView) {
            result.append("DView");
        } else if (element instanceof DTable) {
            result.append(LabelProviderHelper.getText((EObject)((EObject)element)));
        }
        return result.toString();
    }

    protected String getID(Object current) {
        if (current instanceof CapellaElement) {
            return ((CapellaElement)current).getId();
        }
        if (current instanceof DRepresentation) {
            return ((DRepresentation)current).getUid();
        }
        if (current instanceof DAnalysis) {
            return ((DAnalysis)current).getVersion();
        }
        if (current instanceof DView) {
            return ((DView)current).getViewpoint().getName();
        }
        if (current instanceof EObject) {
            EObject eElement = (EObject)current;
            EStructuralFeature idSF = eElement.eClass().getEStructuralFeature("id");
            if (idSF == null) {
                idSF = eElement.eClass().getEIDAttribute();
            }
            if (idSF != null) {
                Object id = eElement.eGet(idSF);
                return id != null ? id.toString() : null;
            }
        }
        return null;
    }
}

