/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.configuration.ui.viewer;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.FilteredTree;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.PatternFilter;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.Messages;
import org.polarsys.capella.docgen.configuration.ui.viewer.CapellaNavigatorPatternFilter;
import org.polarsys.capella.docgen.configuration.ui.viewer.GenerationContainerCheckedTreeViewer;

public class CapellaFilteredTree
extends FilteredTree {
    protected CapellaFilteredTree(Composite parent) {
        super(parent);
        this.attachFilterControlFocusListener();
    }

    public CapellaFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter);
        this.attachFilterControlFocusListener();
    }

    protected void clearText() {
        this.getPatternFilter().setSearchInDescription(false);
        super.clearText();
    }

    protected void createClearText(Composite parent) {
    }

    protected Composite createFilterControls(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 3;
        Composite filterControls = super.createFilterControls(parent);
        return filterControls;
    }

    protected Label createMessageArea(Composite parent) {
        Label messageArea = super.createMessageArea(parent);
        GridData layoutData = (GridData)messageArea.getLayoutData();
        layoutData.horizontalSpan = 3;
        String labelText = messageArea.getText();
        labelText = String.valueOf(labelText) + ". Hit Enter to appply the filter";
        messageArea.setText(labelText);
        return messageArea;
    }

    private void createSearchDescriptionButton(Composite parent) {
        Action searchInDescriptionAction = new Action("", 1){

            public void run() {
                CapellaFilteredTree.this.getPatternFilter().setSearchInDescription(true);
                CapellaFilteredTree.this.textChanged();
            }
        };
        searchInDescriptionAction.setToolTipText(Messages.CapellaCommonNavigator_searchInDescriptionAction_Tooltip);
        searchInDescriptionAction.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("search.gif"));
        this.filterToolBar.add((IAction)searchInDescriptionAction);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new GenerationContainerCheckedTreeViewer(parent, style);
    }

    protected int getExpansionLevelWhenNoFilter() {
        return 4;
    }

    public CapellaNavigatorPatternFilter getPatternFilter() {
        return (CapellaNavigatorPatternFilter)super.getPatternFilter();
    }

    protected void handleTreeViewerExpansionWhenNoFilter(ISelection currentSelection, Object[] expandedElements) {
        super.handleTreeViewerExpansionWhenNoFilter(currentSelection, expandedElements);
        this.treeViewer.refresh(false);
    }

    protected void handleCRKeyStoke() {
        this.getPatternFilter().setSearchInDescription(false);
        super.handleCRKeyStoke();
    }

    protected void init(int treeStyle, PatternFilter filter) {
        this.setAutoFiltering(false);
        super.init(treeStyle, filter);
    }

    protected void updateToolbar(boolean visible) {
    }

    private void attachFilterControlFocusListener() {
        this.getFilterControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
            }
        });
    }
}

