/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.diagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryService;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.kitalpha.doc.gen.business.core.preference.helper.DocgenDiagramPreferencesHelper;
import org.polarsys.kitalpha.doc.gen.business.core.scope.GenerationGlobalScope;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeReferencesStrategy;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;

public class CapellaHelper {
    private static final String AIRD = ".aird";
    private static final String MELODYMODELLER = ".melodymodeller";

    public static Collection<DRepresentation> getDiagramForObject(CapellaElement element) {
        Collection<Object> representations = new ArrayList<DRepresentation>();
        if (!DocgenDiagramPreferencesHelper.getExportDiagram()) {
            return representations;
        }
        Session currentSession = DiagramSessionHelper.getCurrentSession();
        ScopeReferencesStrategy referencesStrategy = GenerationGlobalScope.getInstance().getReferencesStrategy();
        if (referencesStrategy.equals((Object)ScopeReferencesStrategy.DONT_EXPORT)) {
            EObject originalModelElement = GenerationGlobalScope.getInstance().getOriginalModelElement((EObject)element);
            representations = DialectManager.INSTANCE.getRepresentations(originalModelElement, currentSession);
        } else {
            representations = DialectManager.INSTANCE.getRepresentations((EObject)element, currentSession);
        }
        return representations;
    }

    public static Resource getAIRDResource(CapellaElement element) {
        URI uri = URI.createURI((String)element.eResource().getURI().toString().replace(MELODYMODELLER, AIRD));
        TransactionalEditingDomain domain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain();
        if (domain != null) {
            return domain.getResourceSet().getResource(uri, true);
        }
        return null;
    }

    public static Set<DSemanticDiagram> getDiagramContainingObject(CapellaElement element) {
        HashSet<DSemanticDiagram> diagrams = new HashSet<DSemanticDiagram>();
        if (!DocgenDiagramPreferencesHelper.getExportDiagram()) {
            return diagrams;
        }
        if (GenerationGlobalScope.getInstance().getReferencesStrategy().equals((Object)ScopeReferencesStrategy.DONT_EXPORT)) {
            element = (CapellaElement)GenerationGlobalScope.getInstance().getOriginalModelElement((EObject)element);
        }
        for (DRepresentation representation : DiagramSessionHelper.getSessionDRepresentation()) {
            if (!(representation instanceof DSemanticDiagram)) continue;
            DSemanticDiagram dSemanticDiagram = (DSemanticDiagram)representation;
            EObject semanticTarget = ((DSemanticDiagram)representation).getTarget();
            boolean copyInScope = GenerationGlobalScope.getInstance().isCopyInScope(semanticTarget);
            if (!copyInScope) continue;
            block1: for (DDiagramElement diagramElement : dSemanticDiagram.getDiagramElements()) {
                EObject repTarget = diagramElement.getTarget();
                EList<EObject> targets = CapellaHelper.resolveReferencedElements(repTarget);
                for (EObject target : targets) {
                    if (!diagramElement.isVisible() || !EcoreUtil.equals((EObject)element, (EObject)target) || EcoreUtil.equals((EObject)semanticTarget, (EObject)target)) continue;
                    diagrams.add((DSemanticDiagram)representation);
                    continue block1;
                }
            }
        }
        return diagrams;
    }

    private static EList<EObject> resolveReferencedElements(EObject repTarget) {
        BasicEList objects = new BasicEList();
        objects.add((Object)repTarget);
        if (repTarget instanceof Part) {
            objects.addAll(CapellaHelper.resolveReferencedElements((EObject)((Part)repTarget).getAbstractType()));
        }
        if (repTarget instanceof InstanceRole) {
            objects.addAll(CapellaHelper.resolveReferencedElements((EObject)((InstanceRole)repTarget).getRepresentedInstance()));
        }
        if (repTarget instanceof StateFragment) {
            objects.addAll(CapellaHelper.resolveReferencedElements((EObject)((StateFragment)repTarget).getRelatedAbstractFunction()));
        }
        return objects;
    }

    public static Collection<DDiagram> getAllInterestedRepresentationsFor(EObject semanticElement) {
        LinkedHashSet descriptors = new LinkedHashSet();
        Collection inverseReferences = new EObjectQuery(semanticElement).getInverseReferences(DescriptionPackage.Literals.DANNOTATION__REFERENCES);
        inverseReferences.forEach(eObject -> {
            DAnnotation annotation = (DAnnotation)eObject;
            if ("https://www.polarsys.org/capella/dannotation/eoi".equals(annotation.getSource())) {
                descriptors.add(annotation.eContainer());
            }
        });
        return descriptors.parallelStream().map(eObject -> (DRepresentationDescriptor)eObject).map(desc -> DiagramSessionHelper.getDDiagram((DRepresentationDescriptor)desc)).collect(Collectors.toList());
    }
}

