/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.extension;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.extension.BasePatternInitializer;
import org.eclipse.egf.pattern.templates.TemplateEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateInitializer
extends BasePatternInitializer {
    private final TemplateEngine engine;

    public TemplateInitializer(IProject project, Pattern pattern, TemplateEngine engine) {
        super(project, pattern);
        this.engine = engine;
    }

    @Override
    protected String getDefaultContent(PatternMethod method) throws PatternException {
        return this.runEngine(TemplateEngine.Templates.DEFAULT);
    }

    @Override
    protected final String getFooterContent(PatternMethod method) throws PatternException {
        return this.runEngine(TemplateEngine.Templates.FOOTER);
    }

    @Override
    protected final String getHeaderContent(PatternMethod method) throws PatternException {
        return this.runEngine(TemplateEngine.Templates.HEADER);
    }

    @Override
    protected final String getInitContent(PatternMethod method) throws PatternException {
        return this.runEngine(TemplateEngine.Templates.INIT);
    }

    @Override
    protected String getConditionContent(PatternMethod method) throws PatternException {
        return this.runEngine(TemplateEngine.Templates.PRE_CONDITION);
    }

    private String runEngine(TemplateEngine.Templates template) throws PatternException {
        try {
            return this.engine.process(template, this.createContext());
        }
        catch (CoreException e) {
            throw new PatternException((Throwable)e);
        }
        catch (IOException e) {
            throw new PatternException((Throwable)e);
        }
    }

    protected abstract Map<String, String> createContext();
}

