/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.expression.ag;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.vp.ms.BooleanExpression;
import org.polarsys.capella.vp.ms.BooleanOperation;
import org.polarsys.capella.vp.ms.InSituationExpression;
import org.polarsys.capella.vp.ms.InStateExpression;
import org.polarsys.capella.vp.ms.MsPackage;
import org.polarsys.capella.vp.ms.NotOperation;
import org.polarsys.capella.vp.ms.Situation;
import org.polarsys.capella.vp.ms.expression.parser.MsExpressionUnparser;
import org.polarsys.capella.vp.ms.expression.transfo.ExpressionToDNF;
import org.polarsys.capella.vp.ms.expression.transfo.ExpressionToNNF;
import org.polarsys.capella.vp.ms.util.MsSwitch;

public class ExcelExporter
extends MsSwitch<Object> {
    List<StateMachine> statemachines = new ArrayList<StateMachine>();
    Map<Situation, List<Multimap<StateMachine, BooleanExpression>>> exportmap = new LinkedHashMap<Situation, List<Multimap<StateMachine, BooleanExpression>>>();
    Function<StateMachine, String> headers = s -> String.valueOf(((AbstractNamedElement)s.eContainer()).getName()) + "/" + s.getName();
    Multimap<BooleanExpression, BooleanExpression> literals;
    BooleanExpression root;

    private StateMachine getStateMachine(BooleanExpression e) {
        if (e instanceof NotOperation) {
            return this.getStateMachine((BooleanExpression)((NotOperation)e).getChildren().iterator().next());
        }
        if (e instanceof InStateExpression) {
            AbstractState s = ((InStateExpression)e).getState();
            return (StateMachine)EcoreUtil2.getFirstContainer((EObject)s, (EClass)CapellacommonPackage.Literals.STATE_MACHINE);
        }
        return null;
    }

    private void finish(OutputStream out, Comparator<StateMachine> columnOrder) throws IOException {
        this.statemachines.sort(columnOrder);
        XSSFWorkbook wb = new XSSFWorkbook();
        Sheet sheet1 = wb.createSheet();
        int rowIndex = 0;
        Row row = sheet1.createRow(rowIndex++);
        int i = 0;
        while (i < this.statemachines.size()) {
            Cell cell = row.createCell(i + 1);
            cell.setCellValue(this.headers.apply(this.statemachines.get(i)));
            ++i;
        }
        MsExpressionUnparser unparser = new MsExpressionUnparser(MsExpressionUnparser.Mode.NAME);
        for (Situation situation : this.exportmap.keySet()) {
            row = sheet1.createRow(rowIndex++);
            Cell sitCell = row.createCell(0);
            sitCell.setCellValue(situation.getName());
            StringBuilder[] printableRecord = new StringBuilder[this.statemachines.size() + 1];
            int i2 = 0;
            while (i2 < printableRecord.length) {
                printableRecord[i2] = new StringBuilder();
                ++i2;
            }
            printableRecord[0].append(situation.getName());
            for (Multimap<StateMachine, BooleanExpression> r : this.exportmap.get(situation)) {
                for (StateMachine sm : r.keySet()) {
                    int colIndex = this.statemachines.indexOf(sm) + 1;
                    Cell cell = row.createCell(colIndex);
                    cell.setCellValue(r.get((Object)sm).stream().map(be -> unparser.unparse(be)).collect(Collectors.joining(", ")));
                }
                row = sheet1.createRow(rowIndex++);
            }
        }
        int i3 = 0;
        while (i3 < this.statemachines.size() + 1) {
            sheet1.autoSizeColumn(i3);
            ++i3;
        }
        wb.write(out);
        wb.close();
    }

    public void export(Collection<? extends Situation> situations, Comparator<StateMachine> columnOrder, OutputStream out) throws IOException {
        for (Situation situation : situations) {
            this.export(situation);
        }
        this.finish(out, columnOrder);
    }

    private ExcelExporter export(Situation situation) {
        BooleanExpression dnf = (BooleanExpression)new ExpressionToDNF().doSwitch((EObject)new ExpressionToNNF().doSwitch((EObject)situation.getExpression()));
        this.literals = LinkedHashMultimap.create();
        this.root = dnf;
        this.doSwitch((EObject)dnf);
        ArrayList<LinkedHashMultimap> records = new ArrayList<LinkedHashMultimap>();
        for (BooleanExpression key : this.literals.keySet()) {
            LinkedHashMultimap record = LinkedHashMultimap.create();
            for (BooleanExpression element : this.literals.get((Object)key)) {
                StateMachine sm = this.getStateMachine(element);
                if (!this.statemachines.contains(sm)) {
                    this.statemachines.add(sm);
                }
                record.put((Object)sm, (Object)element);
            }
            records.add(record);
        }
        this.exportmap.put(situation, records);
        return this;
    }

    public Object caseBooleanOperation(BooleanOperation op) {
        for (BooleanExpression child : op.getChildren()) {
            this.doSwitch((EObject)child);
        }
        return this;
    }

    private BooleanExpression findTop(BooleanExpression object) {
        BooleanExpression expr = object;
        while (expr != this.root) {
            if (expr.eContainer().eClass() == MsPackage.Literals.OR_OPERATION) break;
            expr = (BooleanExpression)expr.eContainer();
        }
        return expr;
    }

    public Object caseNotOperation(NotOperation object) {
        BooleanExpression top = this.findTop((BooleanExpression)object);
        this.literals.put((Object)top, (Object)object);
        return this;
    }

    public Object caseInStateExpression(InStateExpression e) {
        BooleanExpression top = this.findTop((BooleanExpression)e);
        this.literals.put((Object)top, (Object)e);
        return this;
    }

    public Object caseInSituationExpression(InSituationExpression e) {
        BooleanExpression top = this.findTop((BooleanExpression)e);
        this.literals.put((Object)top, (Object)e);
        return this;
    }
}

