/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.ui.properties;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.data.core.properties.sections.NamedElementSection;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.ui.properties.controllers.AbstractMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;
import org.polarsys.capella.vp.ms.CSConfiguration;
import org.polarsys.capella.vp.ms.MsPackage;
import org.polarsys.capella.vp.ms.provider.MsEditPlugin;
import org.polarsys.capella.vp.ms.ui.properties.KindGroup;
import org.polarsys.capella.vp.ms.ui.properties.SelectorGroup;

public class CSConfigurationSection
extends NamedElementSection {
    private MultipleSemanticField functionsField;
    private MultipleSemanticField functionalChainsField;
    private MultipleSemanticField portsField;
    private MultipleSemanticField componentsField;
    private MultipleSemanticField scenariosField;
    private MultipleSemanticField elementsField;
    private MultipleSemanticField contextField;
    private SelectorGroup selectorGroup;
    private MultipleSemanticField childConfigurationsField;
    private KindGroup kindGroup;

    public boolean select(Object toTest) {
        EObject obj = CapellaAdapterHelper.resolveSemanticObject((Object)toTest);
        return obj != null && obj.eClass().equals(MsPackage.eINSTANCE.getCSConfiguration());
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        boolean displayedInWizard = this.isDisplayedInWizard();
        this.selectorGroup = new SelectorGroup(this.rootParentComposite, this.getWidgetFactory(), MsEditPlugin.INSTANCE.getString("_UI_CSConfiguration_selector_feature"), 2);
        this.selectorGroup.setDisplayedInWizard(displayedInWizard);
        this.kindGroup = new KindGroup(this.rootParentComposite, this.getWidgetFactory(), MsEditPlugin.INSTANCE.getString("_UI_CSConfiguration_kind_feature"), 2);
        DerivedElementsController elementsController = new DerivedElementsController();
        this.functionsField = new DerivedMultipleSemanticField((Composite)this.getReferencesGroup(), MsEditPlugin.INSTANCE.getString("_UI_CSConfiguration_functions_feature"), this.getWidgetFactory(), (IMultipleSemanticFieldController)elementsController, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__ELEMENTS);
        this.functionsField.setDisplayedInWizard(displayedInWizard);
        this.functionalChainsField = new DerivedMultipleSemanticField((Composite)this.getReferencesGroup(), MsEditPlugin.INSTANCE.getString("_UI_CSConfiguration_functionalChains_feature"), this.getWidgetFactory(), (IMultipleSemanticFieldController)elementsController, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__ELEMENTS);
        this.functionalChainsField.setDisplayedInWizard(displayedInWizard);
        this.componentsField = new DerivedMultipleSemanticField((Composite)this.getReferencesGroup(), MsEditPlugin.INSTANCE.getString("_UI_CSConfiguration_components_feature"), this.getWidgetFactory(), (IMultipleSemanticFieldController)elementsController, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__ELEMENTS);
        this.componentsField.setDisplayedInWizard(displayedInWizard);
        this.portsField = new DerivedMultipleSemanticField((Composite)this.getReferencesGroup(), MsEditPlugin.INSTANCE.getString("_UI_CSConfiguration_ports_feature"), this.getWidgetFactory(), (IMultipleSemanticFieldController)elementsController, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__ELEMENTS);
        this.portsField.setDisplayedInWizard(displayedInWizard);
        this.scenariosField = new DerivedMultipleSemanticField((Composite)this.getReferencesGroup(), MsEditPlugin.INSTANCE.getString("_UI_CSConfiguration_scenarios_feature"), this.getWidgetFactory(), (IMultipleSemanticFieldController)elementsController, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__ELEMENTS);
        this.scenariosField.setDisplayedInWizard(displayedInWizard);
        this.elementsField = new MultipleSemanticField((Composite)this.getReferencesGroup(), MsEditPlugin.INSTANCE.getString("_UI_CSConfiguration_other_elements"), this.getWidgetFactory(), (IMultipleSemanticFieldController)elementsController);
        this.elementsField.setDisplayedInWizard(displayedInWizard);
        this.childConfigurationsField = new MultipleSemanticField((Composite)this.getReferencesGroup(), MsEditPlugin.INSTANCE.getString("_UI_CSConfiguration_childConfigurations_feature"), this.getWidgetFactory(), (IMultipleSemanticFieldController)new ItemProviderFieldController());
        this.contextField = new MultipleSemanticField((Composite)this.getReferencesGroup(), MsEditPlugin.INSTANCE.getString("_UI_CSConfiguration_context_feature"), this.getWidgetFactory(), (IMultipleSemanticFieldController)new ItemProviderFieldController());
    }

    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        this.functionsField.loadData(capellaElement, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__FUNCTIONS);
        this.functionalChainsField.loadData(capellaElement, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__FUNCTIONAL_CHAINS);
        this.componentsField.loadData(capellaElement, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__COMPONENTS);
        this.portsField.loadData(capellaElement, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__PORTS);
        this.scenariosField.loadData(capellaElement, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__SCENARIOS);
        this.elementsField.loadData(capellaElement, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__ELEMENTS);
        this.childConfigurationsField.loadData(capellaElement, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__CHILD_CONFIGURATIONS);
        this.selectorGroup.loadData(capellaElement, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__SELECTOR);
        this.kindGroup.loadData(capellaElement, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__KIND);
        this.contextField.loadData(capellaElement, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__CONTEXT);
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this.functionsField);
        fields.add((AbstractSemanticField)this.functionalChainsField);
        fields.add((AbstractSemanticField)this.componentsField);
        fields.add((AbstractSemanticField)this.portsField);
        fields.add((AbstractSemanticField)this.scenariosField);
        fields.add((AbstractSemanticField)this.elementsField);
        fields.add((AbstractSemanticField)this.selectorGroup);
        fields.add((AbstractSemanticField)this.kindGroup);
        fields.add((AbstractSemanticField)this.childConfigurationsField);
        fields.add((AbstractSemanticField)this.contextField);
        return fields;
    }

    private class DerivedElementsController
    extends ItemProviderFieldController {
        private DerivedElementsController() {
        }

        public List<EObject> loadValues(EObject semanticElement, EStructuralFeature semanticFeature) {
            ArrayList values = super.loadValues(semanticElement, semanticFeature);
            if (semanticFeature == MsPackage.Literals.CS_CONFIGURATION__ELEMENTS) {
                values = new ArrayList(Collections2.filter((Collection)values, (Predicate)Predicates.not((Predicate)Predicates.or((Predicate[])new Predicate[]{Predicates.instanceOf(AbstractFunction.class), Predicates.instanceOf(FunctionalChain.class), Predicates.instanceOf(Component.class), Predicates.instanceOf(Port.class), Predicates.instanceOf(Scenario.class)}))));
            }
            return values;
        }

        protected void doAddOperationInWriteOpenValues(EObject semanticElement, EStructuralFeature semanticFeature, EObject object) {
            ((CSConfiguration)semanticElement).getElements().add((Object)((ModelElement)object));
        }

        protected void doRemoveOperationInWriteOpenValues(EObject semanticElement, EStructuralFeature semanticFeature, EObject object) {
            ((CSConfiguration)semanticElement).getElements().remove((Object)object);
        }
    }

    static class DerivedMultipleSemanticField
    extends MultipleSemanticField {
        final EStructuralFeature delegate;

        public DerivedMultipleSemanticField(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory, IMultipleSemanticFieldController controller, EStructuralFeature delegate) {
            super(parent, label, widgetFactory, controller);
            this.delegate = delegate;
        }

        protected void removeAllDataValue(final EObject object, final EStructuralFeature feature) {
            AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                public void run() {
                    ((Collection)((CSConfiguration)object).eGet(delegate)).removeAll((Collection)object.eGet(feature));
                }
            };
            this.executeCommand((ICommand)command);
        }
    }

    static class ItemProviderFieldController
    extends AbstractMultipleSemanticFieldController {
        ItemProviderFieldController() {
        }

        public List<EObject> readOpenValues(EObject semanticElement, EStructuralFeature semanticFeature, boolean available) {
            ArrayList current = this.loadValues(semanticElement, semanticFeature);
            ArrayList result = null;
            if (available) {
                AdapterFactoryEditingDomain domain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)semanticElement);
                IItemPropertySource propertySource = (IItemPropertySource)domain.getAdapterFactory().adapt((Notifier)semanticElement, IItemPropertySource.class);
                IItemPropertyDescriptor descriptor = propertySource.getPropertyDescriptor((Object)semanticElement, (Object)semanticFeature);
                result = new ArrayList(descriptor.getChoiceOfValues((Object)semanticElement));
                result.removeAll(current);
            } else {
                result = current;
            }
            return result;
        }

        protected IBusinessQuery getReadOpenValuesQuery(EObject semanticElement) {
            throw new UnsupportedOperationException();
        }
    }
}

