/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.IMirrorExtension;
import org.eclipse.xtext.common.types.access.JvmTypeChangeDispatcher;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.impl.JvmDeclaredTypeImpl;
import org.eclipse.xtext.common.types.util.RawTypeReferenceComputer;
import org.eclipse.xtext.common.types.xtext.JvmMemberInitializableResource;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public abstract class JvmDeclaredTypeImplCustom
extends JvmDeclaredTypeImpl {
    protected Iterable<JvmTypeReference> extendedInterfaces;
    protected Map<String, Set<JvmDeclaredType>> allNestedTypesByName;
    protected Map<String, Set<JvmFeature>> allFeaturesByName;
    protected Set<String> removedOverridden;
    protected Set<JvmFeature> allFeatures;
    private boolean isPendingInitialization = false;

    @Override
    public JvmArrayType getArrayType() {
        this.checkPendingInitialization();
        JvmArrayType result = super.getArrayType();
        if (result == null) {
            result = this.doSynchronized(new Provider<JvmArrayType>(){

                public JvmArrayType get() {
                    JvmArrayType result = TypesFactory.eINSTANCE.createJvmArrayType();
                    boolean wasDeliver = JvmDeclaredTypeImplCustom.this.eDeliver();
                    JvmDeclaredTypeImplCustom.this.eSetDeliver(false);
                    try {
                        JvmDeclaredTypeImplCustom.this.setArrayType(result);
                    }
                    finally {
                        JvmDeclaredTypeImplCustom.this.eSetDeliver(wasDeliver);
                    }
                    return result;
                }
            });
        }
        return result;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.arrayType;
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    protected JvmDeclaredType internalGetDeclaringType() {
        EObject container;
        JvmDeclaredType result = this.getDeclaringType();
        if (result == null && (container = this.eContainer()) instanceof JvmFeature) {
            result = ((JvmFeature)container).getDeclaringType();
        }
        return result;
    }

    @Override
    public String getPackageName() {
        JvmDeclaredType declaringType = this.internalGetDeclaringType();
        if (declaringType != null) {
            return declaringType.getPackageName();
        }
        return this.packageName;
    }

    @Override
    protected String computeIdentifier() {
        if (this.simpleName == null) {
            return null;
        }
        JvmDeclaredType declaringType = this.internalGetDeclaringType();
        if (declaringType == null) {
            if (Strings.isEmpty((String)this.packageName)) {
                return this.simpleName;
            }
            return this.packageName + "." + this.simpleName;
        }
        String parentName = declaringType.getIdentifier();
        if (parentName == null) {
            return null;
        }
        return parentName + "$" + this.simpleName;
    }

    @Override
    public String getQualifiedName(char innerClassDelimiter) {
        if (this.simpleName == null) {
            return null;
        }
        JvmDeclaredType declaringType = this.getDeclaringType();
        if (declaringType == null) {
            if (Strings.isEmpty((String)this.packageName)) {
                return this.simpleName;
            }
            return this.packageName + "." + this.simpleName;
        }
        String parentName = declaringType.getQualifiedName(innerClassDelimiter);
        if (parentName == null) {
            return null;
        }
        return parentName + innerClassDelimiter + this.simpleName;
    }

    @Override
    public Iterable<JvmField> getDeclaredFields() {
        return Iterables.filter(this.getMembers(), JvmField.class);
    }

    @Override
    public Iterable<JvmOperation> getDeclaredOperations() {
        return Iterables.filter(this.getMembers(), JvmOperation.class);
    }

    @Override
    public JvmTypeReference getExtendedClass() {
        for (JvmTypeReference candidate : this.getSuperTypes()) {
            if (!(candidate.getType() instanceof JvmGenericType) || ((JvmGenericType)candidate.getType()).isInterface()) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public boolean isInstantiateable() {
        return false;
    }

    @Override
    public Iterable<JvmTypeReference> getExtendedInterfaces() {
        if (this.extendedInterfaces == null) {
            this.extendedInterfaces = Iterables.filter(this.getSuperTypes(), (Predicate)new Predicate<JvmTypeReference>(){

                public boolean apply(JvmTypeReference typeReference) {
                    JvmType type = typeReference.getType();
                    if (type != null && type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE) {
                        return ((JvmGenericType)type).isInterface();
                    }
                    return false;
                }
            });
        }
        return this.extendedInterfaces;
    }

    @Override
    public Iterable<JvmConstructor> getDeclaredConstructors() {
        return Iterables.filter(this.getMembers(), JvmConstructor.class);
    }

    @Override
    public boolean isLocal() {
        return this.eContainingFeature() == TypesPackage.Literals.JVM_FEATURE__LOCAL_CLASSES;
    }

    @Override
    public Iterable<JvmDeclaredType> findAllNestedTypesByName(String simpleName) {
        Set<JvmDeclaredType> result = this.getAllNestedTypesMap().get(simpleName);
        if (result != null) {
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<JvmDeclaredType> getAllNestedTypes() {
        ArrayList result = Lists.newArrayList();
        for (Set<JvmDeclaredType> types : this.getAllNestedTypesMap().values()) {
            result.addAll(types);
        }
        return result;
    }

    protected Map<String, Set<JvmDeclaredType>> getAllNestedTypesMap() {
        return this.internalGetAllNestedTypesMap(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Set<JvmDeclaredType>> internalGetAllNestedTypesMap(Set<JvmDeclaredType> processedTypes) {
        try {
            if (this.allNestedTypesByName == null) {
                final Set<Object> processedSuperTypes = processedTypes == null ? Sets.newHashSet() : processedTypes;
                this.allNestedTypesByName = this.doSynchronized(new Provider<Map<String, Set<JvmDeclaredType>>>(){

                    public Map<String, Set<JvmDeclaredType>> get() {
                        if (JvmDeclaredTypeImplCustom.this.allNestedTypesByName != null) {
                            return JvmDeclaredTypeImplCustom.this.allNestedTypesByName;
                        }
                        LinkedHashMap result = Maps.newLinkedHashMap();
                        JvmDeclaredTypeImplCustom.this.processTypes(result, (Collection<? extends JvmMember>)JvmDeclaredTypeImplCustom.this.getMembers());
                        LinkedHashMap cumulated = Maps.newLinkedHashMap();
                        for (JvmTypeReference superTypeReference : JvmDeclaredTypeImplCustom.this.getSuperTypes()) {
                            JvmType superType = JvmDeclaredTypeImplCustom.this.getRawType(superTypeReference);
                            if (!(superType instanceof JvmDeclaredTypeImplCustom) || superType.eIsProxy() || processedSuperTypes.contains(superType)) continue;
                            processedSuperTypes.add((JvmDeclaredType)superType);
                            Map<String, Set<JvmDeclaredType>> superTypeMap = ((JvmDeclaredTypeImplCustom)superType).internalGetAllNestedTypesMap(processedSuperTypes);
                            processedSuperTypes.remove(superType);
                            for (Map.Entry<String, Set<JvmDeclaredType>> entry : superTypeMap.entrySet()) {
                                if (result.containsKey(entry.getKey())) continue;
                                JvmDeclaredTypeImplCustom.this.processTypes(cumulated, (Collection<? extends JvmMember>)entry.getValue());
                            }
                        }
                        result.putAll(cumulated);
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                JvmDeclaredTypeImplCustom.this.doSynchronized(new Provider<Object>(){

                                    public Object get() {
                                        JvmDeclaredTypeImplCustom.this.allNestedTypesByName = null;
                                        return null;
                                    }
                                });
                            }
                        };
                        JvmDeclaredTypeImplCustom.this.requestNotificationOnChange(runnable);
                        return result;
                    }
                });
            }
            Map<String, Set<JvmDeclaredType>> map = this.allNestedTypesByName;
            return map;
        }
        finally {
            XtextResource xtextResource;
            CompilerPhases compilerPhases;
            if (this.eResource() instanceof XtextResource && (compilerPhases = (CompilerPhases)(xtextResource = (XtextResource)this.eResource()).getResourceServiceProvider().get(CompilerPhases.class)).isIndexing((Notifier)xtextResource.getResourceSet())) {
                this.allNestedTypesByName = null;
            }
        }
    }

    protected void processTypes(Map<String, Set<JvmDeclaredType>> result, Collection<? extends JvmMember> members) {
        for (JvmMember jvmMember : members) {
            if (!(jvmMember instanceof JvmDeclaredType)) continue;
            Set<JvmDeclaredType> knownTypes = result.get(jvmMember.getSimpleName());
            if (knownTypes == null) {
                knownTypes = new LinkedHashSet<JvmDeclaredType>(2);
                result.put(jvmMember.getSimpleName(), knownTypes);
            }
            knownTypes.add((JvmDeclaredType)jvmMember);
        }
    }

    @Override
    public Iterable<JvmFeature> findAllFeaturesByName(final String simpleName) {
        return this.doSynchronized(new Provider<Iterable<JvmFeature>>(){

            public Iterable<JvmFeature> get() {
                Map<String, Set<JvmFeature>> allFeaturesByName = JvmDeclaredTypeImplCustom.this.getAllFeaturesMap();
                Set<JvmFeature> result = allFeaturesByName.get(simpleName);
                if (result != null) {
                    if (result.size() <= 1 || JvmDeclaredTypeImplCustom.this.removedOverridden != null && JvmDeclaredTypeImplCustom.this.removedOverridden.contains(simpleName)) {
                        return result;
                    }
                    HashSet signatures = Sets.newHashSet();
                    Iterator<JvmFeature> iter = result.iterator();
                    while (iter.hasNext()) {
                        JvmField field;
                        JvmFeature next = iter.next();
                        if (next instanceof JvmOperation) {
                            JvmOperation operation = (JvmOperation)next;
                            if (operation.isStatic()) continue;
                            EList<JvmFormalParameter> parameters = operation.getParameters();
                            StringBuilder signature = new StringBuilder(operation.getSimpleName());
                            if (parameters.isEmpty()) {
                                signature.append("()");
                            } else {
                                signature.append("(");
                                for (JvmFormalParameter parameter : parameters) {
                                    String parameterType = JvmDeclaredTypeImplCustom.this.getRawTypeIdentifier(parameter.getParameterType());
                                    if (parameterType == null) continue;
                                    signature.append(parameterType);
                                    signature.append(",");
                                }
                                signature.replace(signature.length() - 1, signature.length(), ")");
                            }
                            if (signatures.add(signature.toString())) continue;
                            iter.remove();
                            continue;
                        }
                        if (!(next instanceof JvmField) || (field = (JvmField)next).isStatic() || signatures.add(field.getSimpleName())) continue;
                        iter.remove();
                    }
                    if (JvmDeclaredTypeImplCustom.this.removedOverridden == null) {
                        JvmDeclaredTypeImplCustom.this.removedOverridden = Sets.newHashSet((Object[])new String[]{simpleName});
                    } else {
                        JvmDeclaredTypeImplCustom.this.removedOverridden.add(simpleName);
                    }
                    return result;
                }
                return Collections.emptyList();
            }
        });
    }

    protected <T> T doSynchronized(final Provider<? extends T> provider) {
        Resource eResource = this.eResource();
        if (eResource instanceof ISynchronizable) {
            try {
                Object result = ((ISynchronizable)eResource).execute(new IUnitOfWork<T, Object>(){

                    public T exec(Object state) throws Exception {
                        Object result = provider.get();
                        return result;
                    }
                });
                return (T)result;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        return (T)provider.get();
    }

    protected Map<String, Set<JvmFeature>> getAllFeaturesMap() {
        return this.internalGetAllFeaturesMap(null);
    }

    protected Map<String, Set<JvmFeature>> internalGetAllFeaturesMap(Set<JvmDeclaredType> processedtypes) {
        if (this.allFeaturesByName == null) {
            final Set<Object> processedSuperTypes = processedtypes == null ? Sets.newHashSet() : processedtypes;
            this.allFeaturesByName = this.doSynchronized(new Provider<Map<String, Set<JvmFeature>>>(){

                public Map<String, Set<JvmFeature>> get() {
                    if (JvmDeclaredTypeImplCustom.this.allFeaturesByName != null) {
                        return JvmDeclaredTypeImplCustom.this.allFeaturesByName;
                    }
                    LinkedHashMap result = Maps.newLinkedHashMap();
                    JvmDeclaredTypeImplCustom.this.processMembers(result, (Collection<? extends JvmMember>)JvmDeclaredTypeImplCustom.this.getMembers());
                    for (JvmTypeReference superTypeReference : JvmDeclaredTypeImplCustom.this.getSuperTypes()) {
                        JvmType superType = JvmDeclaredTypeImplCustom.this.getRawType(superTypeReference);
                        if (!(superType instanceof JvmDeclaredTypeImplCustom) || superType.eIsProxy() || processedSuperTypes.contains(superType)) continue;
                        processedSuperTypes.add((JvmDeclaredType)superType);
                        Map<String, Set<JvmFeature>> superTypeFeatureMap = ((JvmDeclaredTypeImplCustom)superType).internalGetAllFeaturesMap(processedSuperTypes);
                        processedSuperTypes.remove(superType);
                        for (Set<JvmFeature> features : superTypeFeatureMap.values()) {
                            JvmDeclaredTypeImplCustom.this.processMembers(result, features);
                        }
                    }
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            JvmDeclaredTypeImplCustom.this.doSynchronized(new Provider<Object>(){

                                public Object get() {
                                    JvmDeclaredTypeImplCustom.this.removedOverridden = null;
                                    JvmDeclaredTypeImplCustom.this.allFeaturesByName = null;
                                    return null;
                                }
                            });
                        }
                    };
                    JvmDeclaredTypeImplCustom.this.requestNotificationOnChange(runnable);
                    return result;
                }
            });
        }
        return this.allFeaturesByName;
    }

    protected void requestNotificationOnChange(Runnable listener) {
        IMirror mirror;
        Resource resource = this.eResource();
        if (resource instanceof TypeResource && (mirror = ((TypeResource)resource).getMirror()) instanceof IMirrorExtension && ((IMirrorExtension)((Object)mirror)).isSealed()) {
            return;
        }
        JvmDeclaredTypeImplCustom notifier = this;
        if (resource != null) {
            notifier = resource.getResourceSet() != null ? resource.getResourceSet() : resource;
        }
        JvmTypeChangeDispatcher dispatcher = JvmTypeChangeDispatcher.findResourceChangeDispatcher((Notifier)notifier);
        dispatcher.requestNotificationOnChange((Notifier)this, listener);
    }

    protected void processMembers(Map<String, Set<JvmFeature>> result, Collection<? extends JvmMember> members) {
        for (JvmMember jvmMember : members) {
            if (!(jvmMember instanceof JvmOperation) && !(jvmMember instanceof JvmField)) continue;
            Set<JvmFeature> knownMembers = result.get(jvmMember.getSimpleName());
            if (knownMembers == null) {
                knownMembers = new LinkedHashSet<JvmFeature>(2);
                result.put(jvmMember.getSimpleName(), knownMembers);
            }
            knownMembers.add((JvmFeature)jvmMember);
        }
    }

    @Override
    public Iterable<JvmFeature> getAllFeatures() {
        if (this.allFeatures == null) {
            this.allFeatures = this.doSynchronized(new Provider<Set<JvmFeature>>(){

                public Set<JvmFeature> get() {
                    if (JvmDeclaredTypeImplCustom.this.allFeatures != null) {
                        return JvmDeclaredTypeImplCustom.this.allFeatures;
                    }
                    LinkedHashSet result = Sets.newLinkedHashSet();
                    Map<String, Set<JvmFeature>> allFeaturesMap = JvmDeclaredTypeImplCustom.this.getAllFeaturesMap();
                    for (String name : allFeaturesMap.keySet()) {
                        Iterables.addAll((Collection)result, JvmDeclaredTypeImplCustom.this.findAllFeaturesByName(name));
                    }
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            JvmDeclaredTypeImplCustom.this.doSynchronized(new Provider<Object>(){

                                public Object get() {
                                    JvmDeclaredTypeImplCustom.this.allFeatures = null;
                                    return null;
                                }
                            });
                        }
                    };
                    JvmDeclaredTypeImplCustom.this.requestNotificationOnChange(runnable);
                    return result;
                }
            });
        }
        return this.allFeatures;
    }

    protected String getRawTypeIdentifier(JvmTypeReference reference) {
        RawTypeReferenceComputer strategy;
        JvmTypeReference result;
        URI uri;
        JvmType typeOrProxy;
        if (reference instanceof JvmParameterizedTypeReference && (typeOrProxy = (JvmType)reference.eGet((EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, false)).eIsProxy() && "java".equals((uri = ((InternalEObject)typeOrProxy).eProxyURI()).scheme())) {
            String fragment;
            if ("/Primitives".regionMatches(1, uri.segment(0), 0, "/Primitives".length() - 1)) {
                String fragment2 = uri.fragment();
                return fragment2;
            }
            if ("/Objects/".regionMatches(1, uri.segment(0), 0, "/Objects/".length() - 2) && (fragment = uri.fragment()).lastIndexOf(47) == -1) {
                return fragment;
            }
        }
        if ((result = (strategy = new RawTypeReferenceComputer(TypesFactory.eINSTANCE)).getRawTypeReference(reference, this.eResource())) == null) {
            return null;
        }
        JvmType rawResult = result.getType();
        return rawResult == null ? null : rawResult.getIdentifier();
    }

    protected JvmType getRawType(JvmTypeReference reference) {
        RawTypeReferenceComputer strategy = new RawTypeReferenceComputer(TypesFactory.eINSTANCE);
        JvmTypeReference result = strategy.getRawTypeReference(reference, this.eResource());
        return result == null ? null : result.getType();
    }

    public void setPendingInitialization(boolean hasPendingInitialization) {
        this.isPendingInitialization = hasPendingInitialization;
    }

    protected void checkPendingInitialization() {
        if (!this.isPendingInitialization) {
            return;
        }
        Resource resource = this.eResource();
        if (resource instanceof JvmMemberInitializableResource) {
            ((JvmMemberInitializableResource)resource).ensureJvmMembersInitialized();
            this.isPendingInitialization = false;
        }
    }

    public EList<EObject> eContents() {
        this.checkPendingInitialization();
        return super.eContents();
    }

    public EList<Adapter> eAdapters() {
        this.checkPendingInitialization();
        return super.eAdapters();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        this.checkPendingInitialization();
        return super.eIsSet(eFeature);
    }

    @Override
    public boolean eIsSet(int featureID) {
        this.checkPendingInitialization();
        return super.eIsSet(featureID);
    }

    public Object eGet(EStructuralFeature eFeature) {
        this.checkPendingInitialization();
        return super.eGet(eFeature);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        this.checkPendingInitialization();
        return super.eGet(eFeature, resolve);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve, boolean coreType) {
        this.checkPendingInitialization();
        return super.eGet(eFeature, resolve, coreType);
    }

    @Override
    public EList<JvmTypeReference> getSuperTypes() {
        this.checkPendingInitialization();
        return super.getSuperTypes();
    }

    public EList<JvmMember> basicGetMembers() {
        return super.getMembers();
    }

    @Override
    public EList<JvmMember> getMembers() {
        this.checkPendingInitialization();
        return super.getMembers();
    }

    @Override
    public boolean isAbstract() {
        this.checkPendingInitialization();
        return super.isAbstract();
    }

    @Override
    public boolean isStatic() {
        this.checkPendingInitialization();
        return super.isStatic();
    }

    @Override
    public boolean isFinal() {
        this.checkPendingInitialization();
        return super.isFinal();
    }

    @Override
    public JvmVisibility getVisibility() {
        this.checkPendingInitialization();
        return super.getVisibility();
    }

    @Override
    public boolean isDeprecated() {
        this.checkPendingInitialization();
        return super.isDeprecated();
    }

    @Override
    public EList<JvmAnnotationReference> getAnnotations() {
        this.checkPendingInitialization();
        return super.getAnnotations();
    }
}

