/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.shared.jdt38;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IEditorAssociationOverride;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.xtext.common.types.shared.jdt38.DebugPluginListener;
import org.eclipse.xtext.common.types.ui.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.editor.XtextEditorInfo;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.ILocationInEclipseResource;
import org.eclipse.xtext.ui.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.xbase.ui.editor.StacktraceBasedEditorDecider;

public class OriginalEditorSelector
implements IEditorAssociationOverride {
    private static final Logger logger = Logger.getLogger(OriginalEditorSelector.class);
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private IWorkbench workbench;
    @Inject
    private StacktraceBasedEditorDecider decisions;
    @Inject
    private DebugPluginListener debugPluginListener;
    @Inject
    private ITraceForTypeRootProvider traceForTypeRootProvider;

    public IEditorDescriptor[] overrideEditors(IEditorInput editorInput, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        IEditorDescriptor xbaseEditor = this.findXbaseEditor(editorInput, true);
        if (xbaseEditor != null) {
            List result = Lists.asList((Object)xbaseEditor, (Object[])editorDescriptors);
            return result.toArray(new IEditorDescriptor[result.size()]);
        }
        return editorDescriptors;
    }

    public IEditorDescriptor[] overrideEditors(String fileName, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        IEditorDescriptor xbaseEditor = this.findXbaseEditor(fileName, true);
        if (xbaseEditor != null) {
            List result = Lists.asList((Object)xbaseEditor, (Object[])editorDescriptors);
            return result.toArray(new IEditorDescriptor[result.size()]);
        }
        return editorDescriptors;
    }

    public IEditorDescriptor overrideDefaultEditor(IEditorInput editorInput, IContentType contentType, IEditorDescriptor editorDescriptor) {
        IEditorDescriptor result = this.findXbaseEditor(editorInput, false);
        if (result != null) {
            return result;
        }
        return editorDescriptor;
    }

    public IEditorDescriptor overrideDefaultEditor(String fileName, IContentType contentType, IEditorDescriptor editorDescriptor) {
        IEditorDescriptor result = this.findXbaseEditor(fileName, false);
        if (result != null) {
            return result;
        }
        return editorDescriptor;
    }

    protected IEditorDescriptor findXbaseEditor(String fileName, boolean ignorePreference) {
        String file;
        if (this.decisions.isJDI() && (file = this.debugPluginListener.findXtextSourceFileNameForClassFile(fileName)) != null) {
            return this.getXtextEditor(URI.createURI((String)file));
        }
        if (this.decisions.decideAccordingToCallerForSimpleFileName() == StacktraceBasedEditorDecider.Decision.FORCE_JAVA) {
            return null;
        }
        IType type = this.findJavaTypeForSimpleFileName(fileName);
        if (type != null) {
            IResource resource;
            if (!ignorePreference && (resource = type.getResource()) != null) {
                try {
                    String favoriteEditor = resource.getPersistentProperty(IDE.EDITOR_KEY);
                    if (favoriteEditor != null) {
                        return null;
                    }
                }
                catch (CoreException e) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            IEclipseTrace trace = this.traceForTypeRootProvider.getTraceToSource(type.getTypeRoot());
            return this.getXtextEditor(trace);
        }
        return null;
    }

    public IEditorDescriptor findXbaseEditor(IEditorInput editorInput, boolean ignorePreference) {
        StacktraceBasedEditorDecider.Decision decision;
        IFile file = ResourceUtil.getFile((IEditorInput)editorInput);
        if (file == null) {
            return null;
        }
        if (!ignorePreference && file.exists()) {
            try {
                String favoriteEditor = file.getPersistentProperty(IDE.EDITOR_KEY);
                if (favoriteEditor != null) {
                    return null;
                }
            }
            catch (CoreException e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        if ((decision = this.decisions.decideAccordingToCaller()) == StacktraceBasedEditorDecider.Decision.FORCE_JAVA) {
            return null;
        }
        IEclipseTrace traceToSource = (IEclipseTrace)this.traceInformation.getTraceToSource((Object)file);
        return this.getXtextEditor(traceToSource);
    }

    protected IEditorDescriptor getXtextEditor(IEclipseTrace traceToSource) {
        ILocationInEclipseResource sourceInformation;
        AbsoluteURI absoluteURI;
        Iterator sourceInformationIterator;
        if (traceToSource != null && (sourceInformationIterator = traceToSource.getAllAssociatedLocations().iterator()).hasNext() && (absoluteURI = (sourceInformation = (ILocationInEclipseResource)sourceInformationIterator.next()).getAbsoluteResourceURI()) != null) {
            URI uri = absoluteURI.getURI();
            return this.getXtextEditor(uri);
        }
        return null;
    }

    protected IType findJavaTypeForSimpleFileName(String name) {
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        String typeName = name.substring(0, index);
        String ext = name.substring(index + 1).toLowerCase();
        if (!ext.equals("class") && !ext.equals("java")) {
            return null;
        }
        boolean searchForSources = ext.equals("java");
        SearchResult result = this.findTypesBySimpleName(typeName, searchForSources);
        switch (result.foundTypes.size()) {
            case 1: {
                return result.getExactMatch();
            }
            case 0: {
                String[] splitedName = typeName.split("\\$");
                if (splitedName.length <= 1) break;
                SearchResult containerResult = this.findTypesBySimpleName(splitedName[0], searchForSources);
                IType candidate = null;
                block4: for (IType currentType : containerResult.foundTypes) {
                    int i = 1;
                    while (i < splitedName.length) {
                        if ((currentType = currentType.getType(splitedName[i])) == null || !currentType.exists()) continue block4;
                        if (i == splitedName.length - 1) {
                            if (candidate != null) {
                                return null;
                            }
                            candidate = currentType;
                        }
                        ++i;
                    }
                }
                return candidate;
            }
        }
        return null;
    }

    private SearchResult findTypesBySimpleName(String simpleTypeName, final boolean searchForSources) {
        final SearchResult result = new SearchResult();
        try {
            new SearchEngine().searchAllTypeNames(null, 0, simpleTypeName.toCharArray(), 8, 0, SearchEngine.createWorkspaceScope(), new TypeNameMatchRequestor(){

                public void acceptTypeNameMatch(TypeNameMatch match) {
                    boolean externalLib;
                    IPackageFragmentRoot fragmentRoot = match.getPackageFragmentRoot();
                    boolean bl = externalLib = fragmentRoot.isArchive() || fragmentRoot.isExternal();
                    if (externalLib ^ searchForSources) {
                        result.foundTypes.add(match.getType());
                    }
                }
            }, 3, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected IEditorDescriptor getXtextEditor(URI uri) {
        XtextEditorInfo editorInfo;
        IResourceServiceProvider serviceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(uri);
        if (serviceProvider != null && (editorInfo = (XtextEditorInfo)serviceProvider.get(XtextEditorInfo.class)) != null) {
            IEditorRegistry editorRegistry = this.workbench.getEditorRegistry();
            IEditorDescriptor result = editorRegistry.findEditor(editorInfo.getEditorId());
            return result;
        }
        return null;
    }

    static class SearchResult {
        public List<IType> foundTypes = Lists.newArrayList();

        SearchResult() {
        }

        public IType getExactMatch() {
            if (this.hasExactMatch()) {
                return this.foundTypes.get(0);
            }
            return null;
        }

        public boolean hasExactMatch() {
            return this.foundTypes.size() == 1;
        }
    }
}

