/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.importer.preferences;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.polarsys.capella.vp.requirements.importer.extension.AttributeSet;
import org.polarsys.capella.vp.requirements.importer.extension.AttributesProvider;
import org.polarsys.capella.vp.requirements.importer.extension.ImportPreferencesModel;
import org.polarsys.capella.vp.requirements.importer.extension.ReqImporterPreferencesUtil;
import org.polarsys.capella.vp.requirements.importer.preferences.RequirementsPreferencesPlugin;
import org.polarsys.capella.vp.requirements.ui.importer.preferences.internal.AttributesSelectionSection;
import org.polarsys.capella.vp.requirements.ui.importer.preferences.internal.FilesSelectionSection;
import org.polarsys.kitalpha.emde.extension.utils.Log;

public class ImporterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PROPERTY_PAGE_ID = "org.polarsys.capella.vp.requirements.ui.importer.preferencesImporterPreferencePage";
    private AttributesSelectionSection attributesSelectionSection;
    private FilesSelectionSection filesSelectionSection;
    private ImportPreferencesModel model = new ImportPreferencesModel();

    public ImporterPreferencePage() {
        this.setPreferenceStore(RequirementsPreferencesPlugin.getDefault().getPreferenceStore());
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return RequirementsPreferencesPlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        result.setLayout((Layout)layout);
        this.createFilesSelectionSection(result);
        this.createAttributesSelectionSection(result);
        this.filesSelectionSection.addListener(this.attributesSelectionSection);
        this.applyDialogFont(result);
        return result;
    }

    private void createFilesSelectionSection(Composite container) {
        this.filesSelectionSection = new FilesSelectionSection(this.model);
        this.filesSelectionSection.createComposite(container);
    }

    private void createAttributesSelectionSection(Composite container) {
        this.attributesSelectionSection = new AttributesSelectionSection(this.model);
        this.attributesSelectionSection.createComposite(container);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        try {
            String value = ReqImporterPreferencesUtil.serializePropertyFilesPreference((Collection)this.model.getPropertiesFiles());
            preferenceStore.setValue("requirement.properties.files", value);
            for (AttributeSet category : this.model.getCategories()) {
                for (AttributeSet attribute : category.getChildren()) {
                    String key = ReqImporterPreferencesUtil.getPreferenceKey((AttributeSet)attribute);
                    preferenceStore.setValue(key, attribute.isSelected());
                }
            }
            ((ScopedPreferenceStore)preferenceStore).save();
        }
        catch (IOException e) {
            Log.getDefault().logError((Throwable)e);
        }
        AttributesProvider.invalidateModel();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performDefaults() {
        this.attributesSelectionSection.performDefaults(this.getPreferenceStore());
    }
}

