/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.polarsys.capella.core.transition.common.context.TransitionContext;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.vp.requirements.importer.preferences.RequirementsPreferencesPlugin;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.ReqIFTextParser;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.vp.requirements.Requirements.AttributeOwner;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;
import org.polarsys.kitalpha.vp.requirements.Requirements.RequirementsFactory;
import org.polarsys.kitalpha.vp.requirements.model.helpers.LabelHelper;

public class KeepXHTMLTagsTest
extends BasicTestCase {
    private final String DIV = "div";
    private final String BR_TAG = "<br/>";
    private final String DIV_TAG = "<div>";
    private final String DIV_END_TAG = "/div";
    private String testString = "<xhtml:div>Test text <xhtml:br/></xhtml:div>";
    private String testQuotes = "<xhtml:div>Capella &quot;&lt;is&gt;&quot; great <xhtml:a href=\"to%20.pdf\">here</xhtml:a></xhtml:div>";
    private String expectedResultWithoutTags = "Capella \"<is>\" great here";
    private String expectedResultWithTags = "<div>Capella \"&lt;is&gt;\" great <a href=\"to%20.pdf\">here</a></div>";
    private IPreferenceStore store = RequirementsPreferencesPlugin.getDefault().getPreferenceStore();

    public void test() throws Exception {
        this.testWithTags();
        this.testWithoutTags();
    }

    public void testWithTags() {
        this.store.setValue("keepXHTMLTags", true);
        ReqIFTextParser parser = new ReqIFTextParser((IContext)new TransitionContext());
        Requirement dummyRequirement = RequirementsFactory.eINSTANCE.createRequirement();
        String result = parser.transformToHTML(this.testString, (AttributeOwner)dummyRequirement);
        KeepXHTMLTagsTest.assertTrue((result.indexOf("<br/>") >= 0 ? 1 : 0) != 0);
        KeepXHTMLTagsTest.assertEquals((int)result.indexOf("<div>"), (int)0);
        KeepXHTMLTagsTest.assertTrue((result.indexOf("/div") >= 0 ? 1 : 0) != 0);
        String resultQuotes = parser.transformToHTML(this.testQuotes, (AttributeOwner)dummyRequirement);
        KeepXHTMLTagsTest.assertEquals((String)resultQuotes, (String)this.expectedResultWithTags);
    }

    public void testWithoutTags() {
        this.store.setValue("keepXHTMLTags", false);
        String result = LabelHelper.transformHTMLToText((String)this.testString, (String)"div");
        KeepXHTMLTagsTest.assertTrue((result.indexOf("<br/>") < 0 ? 1 : 0) != 0);
        KeepXHTMLTagsTest.assertTrue((result.indexOf("<div>") < 0 ? 1 : 0) != 0);
        KeepXHTMLTagsTest.assertTrue((result.indexOf("/div") < 0 ? 1 : 0) != 0);
        String resultTestWithQuotes = LabelHelper.transformHTMLToText((String)this.testQuotes);
        KeepXHTMLTagsTest.assertEquals((String)resultTestWithQuotes, (String)this.expectedResultWithoutTags);
    }
}

