/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.importer.preferences.files;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class PropertyFilesSelectionDialog
extends ResourceDialog {
    public PropertyFilesSelectionDialog(Shell parent, String title, int style) {
        super(parent, title, style);
    }

    protected boolean processResources() {
        for (URI uri : this.getURIs()) {
            if (uri.fileExtension().equals("properties")) continue;
            return false;
        }
        return true;
    }

    protected void prepareBrowseFileSystemButton(Button browseFileSystemButton) {
        browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(PropertyFilesSelectionDialog.this.getShell(), PropertyFilesSelectionDialog.this.style);
                fileDialog.setFilterExtensions(new String[]{"*.properties", "*.*"});
                fileDialog.setFilterNames(new String[]{"Properties files", "All files"});
                fileDialog.open();
                String filterPath = fileDialog.getFilterPath();
                if (PropertyFilesSelectionDialog.this.isMulti()) {
                    String[] fileNames = fileDialog.getFileNames();
                    StringBuffer uris = new StringBuffer();
                    int i = 0;
                    int len = fileNames.length;
                    while (i < len) {
                        uris.append(URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileNames[i])).toString());
                        uris.append("  ");
                        ++i;
                    }
                    PropertyFilesSelectionDialog.this.uriField.setText((String.valueOf(PropertyFilesSelectionDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                } else {
                    String fileName = fileDialog.getFileName();
                    if (fileName != null) {
                        PropertyFilesSelectionDialog.this.uriField.setText(URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileName)).toString());
                    }
                }
            }
        });
    }

    protected void prepareBrowseWorkspaceButton(Button browseWorkspaceButton) {
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ViewerFilter filter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return !(element instanceof IFile) || "properties".equals(((IFile)element).getFileExtension());
                    }
                };
                if (PropertyFilesSelectionDialog.this.isMulti()) {
                    StringBuffer uris = new StringBuffer();
                    IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)PropertyFilesSelectionDialog.this.getShell(), null, null, (boolean)true, (Object[])this.getContextSelection(), Arrays.asList(filter));
                    int i = 0;
                    int len = files.length;
                    while (i < len) {
                        uris.append(URI.createPlatformResourceURI((String)files[i].getFullPath().toString(), (boolean)true));
                        uris.append("  ");
                        ++i;
                    }
                    PropertyFilesSelectionDialog.this.uriField.setText((String.valueOf(PropertyFilesSelectionDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                } else {
                    IFile file = null;
                    if (PropertyFilesSelectionDialog.this.isSave()) {
                        String path = this.getContextPath();
                        file = WorkspaceResourceDialog.openNewFile((Shell)PropertyFilesSelectionDialog.this.getShell(), null, null, (IPath)(path != null ? new Path(path) : null), Arrays.asList(filter));
                    } else {
                        IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)PropertyFilesSelectionDialog.this.getShell(), null, null, (boolean)false, (Object[])this.getContextSelection(), Arrays.asList(filter));
                        if (files.length != 0) {
                            file = files[0];
                        }
                    }
                    if (file != null) {
                        PropertyFilesSelectionDialog.this.uriField.setText(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
                    }
                }
            }

            private String getContextPath() {
                return PropertyFilesSelectionDialog.this.context != null && PropertyFilesSelectionDialog.this.context.isPlatformResource() ? URI.createURI((String)".").resolve(PropertyFilesSelectionDialog.this.context).path().substring(9) : null;
            }

            private Object[] getContextSelection() {
                IWorkspaceRoot root;
                IResource resource;
                String path = this.getContextPath();
                if (path != null && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(path)) != null && resource.isAccessible()) {
                    return new Object[]{resource};
                }
                return null;
            }
        });
    }
}

