/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.vp.requirements.importer.preferences.RequirementsPreferencesPlugin;
import org.polarsys.kitalpha.vp.requirements.model.helpers.LabelHelper;

public class KeepXHTMLTagsTest
extends BasicTestCase {
    private final String DIV = "div";
    private final String BR_TAG = "<br/>";
    private final String DIV_TAG = "<div>";
    private final String DIV_END_TAG = "/div";
    private String testString = "Test text<xhtml:br/>";
    private IPreferenceStore store = RequirementsPreferencesPlugin.getDefault().getPreferenceStore();

    public void test() throws Exception {
        this.testWithTags();
        this.testWithoutTags();
    }

    public void testWithTags() {
        this.store.setValue("keepXHTMLTags", true);
        String result = LabelHelper.transformHTMLToText((String)this.testString, (String)"div");
        KeepXHTMLTagsTest.assertTrue((result.indexOf("<br/>") >= 0 ? 1 : 0) != 0);
        KeepXHTMLTagsTest.assertEquals((int)result.indexOf("<div>"), (int)0);
        KeepXHTMLTagsTest.assertTrue((result.indexOf("/div") >= 0 ? 1 : 0) != 0);
    }

    public void testWithoutTags() {
        this.store.setValue("keepXHTMLTags", false);
        String result = LabelHelper.transformHTMLToText((String)this.testString, (String)"div");
        KeepXHTMLTagsTest.assertTrue((result.indexOf("<br/>") < 0 ? 1 : 0) != 0);
        KeepXHTMLTagsTest.assertTrue((result.indexOf("<div>") < 0 ? 1 : 0) != 0);
        KeepXHTMLTagsTest.assertTrue((result.indexOf("/div") < 0 ? 1 : 0) != 0);
    }
}

