/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.diffdata.EElementPresence;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.handler.helpers.SemanticResourcesScope;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaModule;
import org.polarsys.capella.vp.requirements.ju.transposer.TestRequirementsImportLauncher;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class FragmentationTestCase
extends BasicTestCase {
    private static final String systemAnalysis = "24658239-7734-4c39-9402-83325c52d04c";
    private static final String inputFileName = "model/inputs/model1.reqif";
    private static final String projectTestName = "fragmentedModel";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(projectTestName);
    }

    public void test() throws Exception {
        SessionContext session = new SessionContext(this.getSession(projectTestName)){

            public <T extends EObject> T getSemanticElement(String objectIdentifier) {
                Map map = this.getSemanticObjectMap();
                if (!map.containsKey(objectIdentifier)) {
                    EObject object = IdManager.getInstance().getEObject(objectIdentifier, (IScope)new SemanticResourcesScope(this.getSession().getTransactionalEditingDomain().getResourceSet()));
                    this.putSemanticElement(objectIdentifier, object);
                }
                return (T)((EObject)map.get(objectIdentifier));
            }
        };
        final EObject target = session.getSemanticElement(systemAnalysis);
        FragmentationTestCase.assertTrue((boolean)((BlockArchitecture)target).getOwnedExtensions().isEmpty());
        final TestRequirementsImportLauncher testRequirementsImportLauncher = new TestRequirementsImportLauncher();
        TransactionHelper.getExecutionManager((EObject)target).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                File file = IResourceHelpers.getFileOrFolderInTestPlugin(((Object)((Object)this)).getClass(), (String)FragmentationTestCase.inputFileName);
                URI model = URI.createFileURI((String)file.getPath());
                testRequirementsImportLauncher.launch(model, (BlockArchitecture)target, (IProgressMonitor)new NullProgressMonitor());
            }
        });
        FragmentationTestCase.assertTrue((boolean)((BlockArchitecture)target).getOwnedExtensions().stream().anyMatch(x -> x instanceof CapellaModule));
        IContext context = testRequirementsImportLauncher.getContext();
        List differencesFromReferenceScope = (List)context.get((Object)"COMPARE_RESULT");
        boolean anyMatch = differencesFromReferenceScope.stream().filter(EElementPresence.class::isInstance).map(EElementPresence.class::cast).anyMatch(diff -> diff.getElement() instanceof ModelElement);
        FragmentationTestCase.assertFalse((String)"There should not be differences of Capella Element in the Candidate model", (boolean)anyMatch);
    }
}

