/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIFToolExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReqIFToolExtensionUtil {
    public static List<EObject> getToolExtensionsByNsURI(ReqIF reqIF, String nsURI) {
        EList reqIFToolExtensions = reqIF.getToolExtensions();
        ArrayList<EObject> toolExtensions = new ArrayList<EObject>();
        for (ReqIFToolExtension reqIFToolExtension : reqIFToolExtensions) {
            for (EObject extension : reqIFToolExtension.getExtensions()) {
                if (!extension.eClass().getEPackage().getNsURI().equals(nsURI)) continue;
                toolExtensions.add(extension);
            }
        }
        return toolExtensions;
    }

    public static <T> List<T> getToolExtensionsByType(ReqIF reqIF, EClassifier type) {
        EList reqIFToolExtensions = reqIF.getToolExtensions();
        ArrayList<EObject> toolExtensions = new ArrayList<EObject>();
        for (ReqIFToolExtension reqIFToolExtension : reqIFToolExtensions) {
            for (EObject extension : reqIFToolExtension.getExtensions()) {
                if (!type.isInstance((Object)extension)) continue;
                toolExtensions.add(extension);
            }
        }
        return toolExtensions;
    }

    public static void addToolExtension(ReqIF reqIF, EObject toolExtension) {
        if (reqIF != null && toolExtension != null) {
            ReqIFToolExtension reqIFToolExtension = ReqIF10Factory.eINSTANCE.createReqIFToolExtension();
            reqIF.getToolExtensions().add((Object)reqIFToolExtension);
            reqIFToolExtension.getExtensions().add((Object)toolExtension);
        }
    }

    public static Command getAddToolExtensionCommand(final ReqIF reqIF, final EObject toolExtension) {
        AbstractCommand command = new AbstractCommand(){
            ReqIFToolExtension reqIFToolExtension;

            public void execute() {
                this.reqIFToolExtension = ReqIF10Factory.eINSTANCE.createReqIFToolExtension();
                reqIF.getToolExtensions().add((Object)this.reqIFToolExtension);
                this.reqIFToolExtension.getExtensions().add((Object)toolExtension);
            }

            public void redo() {
                reqIF.getToolExtensions().add((Object)this.reqIFToolExtension);
                this.reqIFToolExtension.getExtensions().add((Object)toolExtension);
            }

            public void undo() {
                reqIF.getToolExtensions().remove((Object)this.reqIFToolExtension);
            }

            public Collection<?> getAffectedObjects() {
                return Arrays.asList(this.reqIFToolExtension, toolExtension);
            }

            protected boolean prepare() {
                return true;
            }
        };
        return command;
    }
}

