/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.interactive;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridge;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.impl.AbstractBridge;
import org.eclipse.emf.diffmerge.bridge.interactive.EMFInteractiveBridge;
import org.eclipse.emf.diffmerge.bridge.interactive.Messages;
import org.eclipse.emf.diffmerge.bridge.interactive.util.ResourceUtil;
import org.eclipse.emf.diffmerge.impl.scopes.FragmentedModelScope;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BridgeJob<SD>
extends Job {
    protected final SD _sourceDataSet;
    protected final URI _targetURI;
    protected ResourceSet _targetResourceSet;

    public BridgeJob(String jobName_p, SD sourceDataSet_p, URI targetURI_p) {
        super(jobName_p == null ? Messages.BridgeJob_DefaultName : jobName_p);
        this._sourceDataSet = sourceDataSet_p;
        this._targetURI = targetURI_p;
        this._targetResourceSet = this.initializeTargetResourceSet();
        this.setUser(true);
    }

    protected abstract EMFInteractiveBridge<SD, IEditableModelScope> getBridge();

    protected Resource getCreateTargetResource(URI uri_p) {
        ResourceSet rs = this.getTargetResourceSet();
        Resource result = ResourceUtil.getCreateResourceForUri(uri_p, rs);
        ResourceUtil.ensureLoaded(result);
        return result;
    }

    protected Resource getCreateTraceResource(URI uri_p) {
        return this.getCreateTargetResource(uri_p);
    }

    protected EditingDomain getTargetEditingDomain() {
        EditingDomain result = null;
        ResourceSet rs = this.getTargetResourceSet();
        result = AdapterFactoryEditingDomain.getEditingDomainFor((Object)rs);
        return result;
    }

    protected final ResourceSet getTargetResourceSet() {
        return this._targetResourceSet;
    }

    protected IEditableModelScope getTargetScope(Resource resource_p) {
        return new FragmentedModelScope(resource_p, false);
    }

    protected IBridgeTrace getTrace(Resource traceResource_p) {
        EObject root;
        IBridgeTrace result = null;
        if (!traceResource_p.getContents().isEmpty() && (root = (EObject)traceResource_p.getAllContents().next()) instanceof IBridgeTrace) {
            result = (IBridgeTrace)root;
        }
        return result;
    }

    protected URI getTraceURI() {
        return this._targetURI.appendFileExtension("bridgetraces");
    }

    protected IStatus handleInteractivePart(IIncrementalBridge<?, ?, ?> bridge_p, IIncrementalBridgeExecution execution_p, SubMonitor monitor_p) {
        monitor_p.subTask(Messages.BridgeJob_Step_InteractiveUpdate);
        if (bridge_p instanceof AbstractBridge) {
            ((AbstractBridge)bridge_p).getLogger().info((Object)Messages.BridgeLogger_InteractiveMergeStepMessage);
        }
        IStatus result = bridge_p.mergeInteractively(execution_p, (IProgressMonitor)monitor_p);
        if (execution_p instanceof IIncrementalBridgeExecution.Editable) {
            ((IIncrementalBridgeExecution.Editable)execution_p).setInteractiveMergeData(null);
        }
        return result;
    }

    protected IIncrementalBridgeExecution handleMainPart(final IIncrementalBridge<SD, IEditableModelScope, ?> bridge_p, Resource targetResource_p, final IBridgeTrace existingTrace_p, SubMonitor monitor_p) {
        final SubMonitor bridgeMonitor = monitor_p.newChild(8);
        final IEditableModelScope targetScope = this.getTargetScope(targetResource_p);
        EditingDomain domain = this.getTargetEditingDomain();
        final IIncrementalBridgeExecution[] executionWrapper = new IIncrementalBridgeExecution[1];
        Runnable runnable = new Runnable(){

            public void run() {
                IIncrementalBridgeExecution localExecution;
                executionWrapper[0] = localExecution = bridge_p.executeOn(BridgeJob.this._sourceDataSet, (Object)targetScope, null, existingTrace_p, true, (IProgressMonitor)bridgeMonitor);
            }
        };
        MiscUtil.execute((EditingDomain)domain, (String)this.getName(), (Runnable)runnable, (boolean)true);
        IIncrementalBridgeExecution result = executionWrapper[0];
        bridgeMonitor.done();
        return result;
    }

    protected ResourceSet initializeTargetResourceSet() {
        return new ResourceSetImpl();
    }

    protected boolean isModal() {
        boolean result = false;
        Boolean modalProp = (Boolean)this.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (modalProp != null) {
            result = modalProp;
        }
        return result;
    }

    protected boolean isSaveAndCloseTarget() {
        return true;
    }

    public IStatus run(IProgressMonitor monitor_p) {
        int workAmount = 10;
        SubMonitor monitor = monitor_p instanceof SubMonitor ? (SubMonitor)monitor_p : SubMonitor.convert((IProgressMonitor)monitor_p, (String)this.getName(), (int)10);
        monitor.subTask(Messages.BridgeJob_Step_SetUp);
        Resource targetResource = this.getCreateTargetResource(this._targetURI);
        URI traceURI = this.getTraceURI();
        Resource traceResource = this.getCreateTraceResource(traceURI);
        monitor.worked(1);
        monitor.subTask(Messages.BridgeJob_Step_Execution);
        IBridgeTrace existingTrace = this.getTrace(traceResource);
        EMFInteractiveBridge<SD, IEditableModelScope> bridge = this.getBridge();
        IIncrementalBridgeExecution execution = this.handleMainPart((IIncrementalBridge<SD, IEditableModelScope, ?>)bridge, targetResource, existingTrace, monitor);
        IStatus result = this.handleInteractivePart((IIncrementalBridge<?, ?, ?>)bridge, execution, monitor);
        if (result.isOK()) {
            this.saveAndClose(execution, targetResource, traceResource, monitor_p);
        }
        monitor_p.done();
        return result;
    }

    protected void saveAndClose(IIncrementalBridgeExecution execution_p, Resource targetResource_p, Resource traceResource_p, IProgressMonitor monitor_p) {
        monitor_p.subTask(Messages.BridgeJob_Step_Completion);
        monitor_p.worked(1);
        if (!execution_p.isActuallyIncremental()) {
            this.setTrace(traceResource_p, execution_p.getTrace());
        }
        if (!traceResource_p.getContents().isEmpty()) {
            ResourceUtil.makePersistent(traceResource_p);
        }
        ResourceUtil.closeResource(traceResource_p);
        if (this.isSaveAndCloseTarget()) {
            ResourceUtil.makePersistent(targetResource_p);
            ResourceUtil.closeResource(targetResource_p);
        }
    }

    protected void setTrace(Resource traceResource_p, IBridgeTrace trace_p) {
        if (trace_p instanceof EObject) {
            traceResource_p.getContents().clear();
            traceResource_p.getContents().add((Object)((EObject)trace_p));
        }
    }
}

