/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.log4j;

import java.util.Collection;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.bridge.log4j.BridgeConsole;
import org.eclipse.emf.diffmerge.bridge.log4j.IBridgeLogListener;
import org.eclipse.emf.diffmerge.bridge.log4j.Messages;
import org.eclipse.emf.diffmerge.bridge.util.AbstractLoggingMessage;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;

public class BridgeLogger
implements IBridgeLogListener {
    protected static final Logger logger = Logger.getLogger(BridgeLogger.class);
    private static BridgeLogger INSTANCE = null;

    protected BridgeLogger() {
        this.setupConsole();
    }

    protected BridgeConsole createNewConsole(IConsoleManager consoleManager_p) {
        BridgeConsole console = new BridgeConsole(Messages.BridgeLogger_ConsoleId, null);
        consoleManager_p.addConsoles(new IConsole[]{console});
        this.initLimitOutput(console);
        console.activate();
        return console;
    }

    protected void error(String message_p) {
        BridgeConsole console = this.findConsole();
        console.getErrorStream().println(message_p);
    }

    protected BridgeConsole findConsole() {
        final BridgeConsole[] result = new BridgeConsole[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                BridgeConsole console = null;
                IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
                IConsole[] existing = consoleManager.getConsoles();
                int i = 0;
                while (i < existing.length) {
                    if (Messages.BridgeLogger_ConsoleId.equals(existing[i].getName())) {
                        console = (BridgeConsole)existing[i];
                        break;
                    }
                    ++i;
                }
                if (console == null) {
                    console = BridgeLogger.this.createNewConsole(consoleManager);
                } else {
                    consoleManager.showConsoleView(console);
                }
                result[0] = console;
            }
        });
        return result[0];
    }

    public static BridgeLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BridgeLogger();
        }
        return INSTANCE;
    }

    protected ILabelProvider getLabelProvider() {
        return EMFDiffMergeUIPlugin.getDefault().getAdapterFactoryLabelProvider();
    }

    protected void handleDebugEvent(LoggingEvent event_p) {
    }

    protected void handleErrorEvent(LoggingEvent event_p) {
        String message = event_p.getMessage().toString();
        this.error(message);
    }

    protected void handleFatalEvent(LoggingEvent event_p) {
        String message = event_p.getMessage().toString();
        this.error(message);
    }

    protected void handleInfoEvent(LoggingEvent event_p) {
        Object message = event_p.getMessage();
        this.info(message);
    }

    public void handleLoggingEvent(LoggingEvent event_p) {
        Level level = event_p.getLevel();
        switch (level.toInt()) {
            case 10000: {
                this.handleDebugEvent(event_p);
                break;
            }
            case 40000: {
                this.handleErrorEvent(event_p);
                break;
            }
            case 50000: {
                this.handleFatalEvent(event_p);
                break;
            }
            case 20000: {
                this.handleInfoEvent(event_p);
                break;
            }
            case 30000: {
                this.handleWarningEvent(event_p);
                break;
            }
        }
    }

    protected void handleLoggingMessage(AbstractLoggingMessage message_p) {
        BridgeConsole console = this.findConsole();
        Collection objects = message_p.getObjects();
        for (Object object : objects) {
            this.registerObject(console, object);
            String sourceName = this.getLabelProvider().getText(object);
            message_p.mapObjectToLabel(object, sourceName);
        }
    }

    protected void handleWarningEvent(LoggingEvent event_p) {
        String message = event_p.getMessage().toString();
        this.warn(message);
    }

    protected void info(Object message_p) {
        if (message_p instanceof AbstractLoggingMessage) {
            this.handleLoggingMessage((AbstractLoggingMessage)message_p);
        }
        this.findConsole().getInfoStream().println(message_p.toString());
    }

    protected void initLimitOutput(BridgeConsole console_p) {
        console_p.setWaterMarks(0, 80000);
        console_p.setConsoleWidth(0);
    }

    protected void registerObject(BridgeConsole console_p, Object object_p) {
        if (object_p instanceof EObject) {
            URI objectURI = EcoreUtil.getURI((EObject)((EObject)object_p));
            console_p.getFragmentToURIMap().put(objectURI.fragment(), objectURI.trimFragment());
        }
    }

    protected BridgeConsole setupConsole() {
        BridgeConsole console = this.findConsole();
        this.initLimitOutput(console);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            try {
                IConsoleView view = (IConsoleView)activePage.showView(Messages.BridgeLogger_ConsoleId, null, 3);
                view.display((IConsole)console);
            }
            catch (PartInitException ex) {
                logger.error((Object)ex.getStackTrace(), (Throwable)ex);
            }
        }
        return console;
    }

    protected void warn(String message_p) {
        BridgeConsole console = this.findConsole();
        console.getWarningStream().println(message_p);
    }
}

