/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.vp.requirements.docgen.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaIncomingRelation;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaOutgoingRelation;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaRequirementsPackage;
import org.polarsys.kitalpha.doc.gen.business.core.util.LabelProviderHelper;
import org.polarsys.kitalpha.vp.requirements.Requirements.AbstractRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.Attribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition;
import org.polarsys.kitalpha.vp.requirements.Requirements.BooleanValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.DateValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.EnumValue;
import org.polarsys.kitalpha.vp.requirements.Requirements.EnumerationValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.Folder;
import org.polarsys.kitalpha.vp.requirements.Requirements.IntegerValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.InternalRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.Module;
import org.polarsys.kitalpha.vp.requirements.Requirements.RealValueAttribute;
import org.polarsys.kitalpha.vp.requirements.Requirements.RelationType;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;
import org.polarsys.kitalpha.vp.requirements.Requirements.RequirementType;
import org.polarsys.kitalpha.vp.requirements.Requirements.StringValueAttribute;
import org.polarsys.kitalpha.vp.requirements.docgen.utils.RequirementsServices;

public class RequirementHelper {
    public static String generateRequirementProperties(Requirement requirement) {
        String reqIFIdentifier = requirement.getReqIFIdentifier();
        String chapterName = requirement.getReqIFChapterName();
        String reqIFLongName = requirement.getReqIFLongName();
        String reqIFText = requirement.getReqIFText();
        RequirementType requirementType = requirement.getRequirementType();
        StringBuilder builder = new StringBuilder();
        builder.append(RequirementHelper.genSection("Properties"));
        builder.append("<b>Identifier: </b>").append(reqIFIdentifier).append("<br/>");
        builder.append("<b>Name: </b>").append(reqIFLongName).append("<br/>");
        builder.append("<b>Chapter Name: </b>").append(chapterName).append("<br/>");
        builder.append("<b>Text: </b>").append(reqIFText).append("<br/>");
        builder.append("<b>Type: </b>").append(requirementType != null && requirementType.getReqIFLongName() != null ? requirementType.getReqIFLongName() : "");
        return builder.toString();
    }

    public static String generateRequirementAttributesSection(Requirement requirement) {
        StringBuffer sb = new StringBuffer();
        EList ownedAttributes = requirement.getOwnedAttributes();
        if (!ownedAttributes.isEmpty()) {
            sb.append(RequirementHelper.genSection("Requirement Attributes"));
            sb.append("<table>");
            sb.append(RequirementHelper.genTableRow(true, "Definition", "Value"));
            for (Attribute attribute : ownedAttributes) {
                AttributeDefinition definition = attribute.getDefinition();
                String definitionLabel = LabelProviderHelper.getText((EObject)definition);
                String value = "";
                if (attribute instanceof RealValueAttribute) {
                    value = String.valueOf(((RealValueAttribute)attribute).getValue());
                } else if (attribute instanceof StringValueAttribute) {
                    value = String.valueOf(((StringValueAttribute)attribute).getValue());
                } else if (attribute instanceof IntegerValueAttribute) {
                    value = String.valueOf(((IntegerValueAttribute)attribute).getValue());
                } else if (attribute instanceof DateValueAttribute) {
                    value = String.valueOf(((DateValueAttribute)attribute).getValue());
                } else if (attribute instanceof BooleanValueAttribute) {
                    value = String.valueOf(((BooleanValueAttribute)attribute).isValue());
                } else if (attribute instanceof EnumerationValueAttribute) {
                    EList values = ((EnumerationValueAttribute)attribute).getValues();
                    ArrayList<String> list = new ArrayList<String>();
                    if (!values.isEmpty()) {
                        for (EnumValue enumValue : values) {
                            list.add(LabelProviderHelper.getText((EObject)enumValue));
                        }
                        value = RequirementHelper.genCommaString(list);
                    }
                }
                sb.append(RequirementHelper.genTableRow(false, definitionLabel, value));
            }
            sb.append("</table>");
        }
        return sb.toString();
    }

    public static String genCommaString(Collection<String> list) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        int size = list.size();
        int i = 0;
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (i < size - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    public static String generateRequirementInternalAllocationSection(Requirement requirement) {
        StringBuilder sb = new StringBuilder();
        EList ownedRelations = requirement.getOwnedRelations();
        boolean first = true;
        if (!ownedRelations.isEmpty()) {
            for (AbstractRelation relation : ownedRelations) {
                if (!(relation instanceof InternalRelation)) continue;
                if (first) {
                    sb.append(RequirementHelper.genSection("Internal Requirement Allocations"));
                    sb.append("<h3>Internal Links:</h3>").append("<br/>");
                    sb.append("<table>");
                    sb.append(RequirementHelper.genTableRow(true, "Target element", "Relation type"));
                    first = false;
                }
                String relationTypeName = RequirementHelper.getRelationTypeName(relation);
                Requirement target = ((InternalRelation)relation).getTarget();
                String hyperlinkFromElement = RequirementsServices.getHyperlinkFromElement((EObject)target);
                sb.append(RequirementHelper.genTableRow(false, hyperlinkFromElement, relationTypeName));
            }
            sb.append("</table>");
        }
        return sb.toString();
    }

    public static String generateRequirementsAllocationSection(Requirement requirement, String projectName, String folderName) {
        StringBuilder builder = new StringBuilder();
        RequirementHelper.generateRequirementRelations((EObject)requirement, builder, projectName, folderName);
        return builder.toString();
    }

    private static void generateRequirementRelations(EObject eObject, StringBuilder builder, String projectName, String folderName) {
        List incomingRelations = EObjectExt.getReferencers((EObject)eObject, (EReference)CapellaRequirementsPackage.Literals.CAPELLA_OUTGOING_RELATION__TARGET);
        List outgoingRelations = EObjectExt.getReferencers((EObject)eObject, (EReference)CapellaRequirementsPackage.Literals.CAPELLA_INCOMING_RELATION__SOURCE);
        if (!incomingRelations.isEmpty() || !outgoingRelations.isEmpty()) {
            builder.append(RequirementHelper.genSection("Requirement Allocations"));
            builder.append(RequirementHelper.generateRequirementsIncomingAllocation(incomingRelations, projectName, folderName));
            builder.append(RequirementHelper.generateRequirementsOutgoingAllocation(outgoingRelations, projectName, folderName));
        }
    }

    public static String generateRequirementsIncomingAllocation(List<EObject> incomingRelations, String projectName, String folderName) {
        StringBuilder builder = new StringBuilder();
        if (!incomingRelations.isEmpty()) {
            builder.append("<div><h3>Incoming Links:</h3>").append("<br/>");
            builder.append("<table>");
            builder.append(RequirementHelper.genTableRow(true, "Source element", "Relation type"));
            for (EObject eObject : incomingRelations) {
                String relationTypeName = RequirementHelper.getRelationTypeName((AbstractRelation)eObject);
                CapellaElement source = ((CapellaOutgoingRelation)eObject).getSource();
                String imageLinkFromElement = RequirementsServices.getImageLinkFromElement((EObject)source, projectName, folderName);
                String hyperlinkFromElement = RequirementsServices.getHyperlinkFromElement((EObject)source);
                builder.append(RequirementHelper.genTableRow(false, String.valueOf(imageLinkFromElement) + " " + hyperlinkFromElement, relationTypeName));
            }
            builder.append("</table>").append("</div>");
        }
        return builder.toString();
    }

    public static String generateRequirementsOutgoingAllocation(List<EObject> outgoingRelations, String projectName, String folderName) {
        StringBuilder builder = new StringBuilder();
        if (!outgoingRelations.isEmpty()) {
            builder.append("<div><h3>Outgoing Links:</h3>").append("<br/>");
            builder.append("<table>");
            builder.append(RequirementHelper.genTableRow(true, "Target element", "Relation type"));
            for (EObject eObject : outgoingRelations) {
                String relationTypeName = RequirementHelper.getRelationTypeName((AbstractRelation)eObject);
                CapellaElement target = ((CapellaIncomingRelation)eObject).getTarget();
                String imageLinkFromElement = RequirementsServices.getImageLinkFromElement((EObject)target, projectName, folderName);
                String hyperlinkFromElement = RequirementsServices.getHyperlinkFromElement((EObject)target);
                builder.append(RequirementHelper.genTableRow(false, String.valueOf(imageLinkFromElement) + " " + hyperlinkFromElement, relationTypeName));
            }
            builder.append("</table>").append("</div>");
        }
        return builder.toString();
    }

    public static String generateFolderContent(Requirement requirement) {
        StringBuilder builder = new StringBuilder();
        if (requirement instanceof Folder) {
            Folder folder = (Folder)requirement;
            EList ownedRequirements = folder.getOwnedRequirements();
            RequirementHelper.generateRequirementContents(builder, (EList<Requirement>)ownedRequirements);
        }
        return builder.toString();
    }

    private static void generateRequirementContents(StringBuilder builder, EList<Requirement> ownedRequirements) {
        if (!ownedRequirements.isEmpty()) {
            builder.append(RequirementHelper.genSection("Contained Elements"));
            ArrayList<String> moduleList = new ArrayList<String>();
            ArrayList<String> folderList = new ArrayList<String>();
            ArrayList<String> reqList = new ArrayList<String>();
            for (Requirement req : ownedRequirements) {
                String hyperlinkFromElement = RequirementsServices.getHyperlinkFromElement((EObject)req);
                if (req instanceof Module) {
                    moduleList.add(hyperlinkFromElement);
                    continue;
                }
                if (req instanceof Folder) {
                    folderList.add(hyperlinkFromElement);
                    continue;
                }
                reqList.add(hyperlinkFromElement);
            }
            if (!moduleList.isEmpty()) {
                builder.append("<h3>Modules</h3>").append(RequirementHelper.genList(moduleList));
            }
            if (!folderList.isEmpty()) {
                builder.append("<h3>Folders</h3>").append(RequirementHelper.genList(folderList));
            }
            if (!reqList.isEmpty()) {
                builder.append("<h3>Requirements</h3>").append(RequirementHelper.genList(reqList));
            }
        }
    }

    public static String generateModuleContents(Module module) {
        EList ownedRequirements = module.getOwnedRequirements();
        StringBuilder builder = new StringBuilder();
        RequirementHelper.generateRequirementContents(builder, (EList<Requirement>)ownedRequirements);
        return builder.toString();
    }

    public static String getRelationTypeName(AbstractRelation relation) {
        String relationTypeName = "";
        RelationType relationType = relation.getRelationType();
        if (relationType != null && relationType.getReqIFLongName() != null && !relationType.getReqIFLongName().isEmpty()) {
            relationTypeName = relationType.getReqIFLongName();
        }
        return relationTypeName;
    }

    public static String genSection(String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("<h2>");
        sb.append(value);
        sb.append("</h2>");
        return sb.toString();
    }

    public static String genList(Collection<String> values) {
        StringBuffer sb = new StringBuffer();
        if (!values.isEmpty()) {
            if (values.size() == 1) {
                sb.append("<ul>");
                sb.append("<li>");
                sb.append((String)((List)values).get(0));
                sb.append("</li>");
                sb.append("</ul>");
            } else {
                sb.append("<ul>");
                for (String value : values) {
                    sb.append("<li>");
                    sb.append(value);
                    sb.append("</li>");
                }
                sb.append("</ul>");
            }
        }
        return sb.toString();
    }

    public static String genTableRow(boolean header, String ... values) {
        StringBuffer sb = new StringBuffer();
        if (values.length > 0) {
            sb.append("<tr>");
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                sb.append(header ? "<th>" : "<td>");
                sb.append(value);
                sb.append(header ? "</th>" : "</td>");
                ++n2;
            }
            sb.append("</tr>");
        }
        return sb.toString();
    }

    public static String generateRequirementRelations(CapellaElement capellaElement) {
        StringBuilder builder = new StringBuilder();
        List incomingRelations = EObjectExt.getReferencers((EObject)capellaElement, (EReference)CapellaRequirementsPackage.Literals.CAPELLA_INCOMING_RELATION__TARGET);
        List outgoingRelations = EObjectExt.getReferencers((EObject)capellaElement, (EReference)CapellaRequirementsPackage.Literals.CAPELLA_OUTGOING_RELATION__SOURCE);
        if (!incomingRelations.isEmpty() || !outgoingRelations.isEmpty()) {
            builder.append(RequirementHelper.genSection("Requirement Allocations"));
        }
        if (!incomingRelations.isEmpty()) {
            builder.append(RequirementHelper.generateElementRequirementsIncomingAllocation(incomingRelations));
        }
        if (!outgoingRelations.isEmpty()) {
            builder.append(RequirementHelper.generateElementRequirementsOutgoingAllocation(outgoingRelations));
        }
        return builder.toString();
    }

    public static String generateElementRequirementsIncomingAllocation(List<EObject> incomingRelations) {
        StringBuilder builder = new StringBuilder();
        if (!incomingRelations.isEmpty()) {
            builder.append("<div><h3>Incoming Links:</h3>").append("<br/>");
            builder.append("<table>");
            builder.append(RequirementHelper.genTableRow(true, "Source element", "Relation type"));
            for (EObject eObject : incomingRelations) {
                String relationTypeName = RequirementHelper.getRelationTypeName((AbstractRelation)eObject);
                Requirement source = ((CapellaIncomingRelation)eObject).getSource();
                String hyperlinkFromElement = RequirementsServices.getHyperlinkFromElement((EObject)source);
                builder.append(RequirementHelper.genTableRow(false, hyperlinkFromElement, relationTypeName));
            }
            builder.append("</table>").append("</div>");
        }
        return builder.toString();
    }

    public static String generateElementRequirementsOutgoingAllocation(List<EObject> outgoingRelations) {
        StringBuilder builder = new StringBuilder();
        if (!outgoingRelations.isEmpty()) {
            builder.append("<div><h3>Outgoing Links:</h3>").append("<br/>");
            builder.append("<table>");
            builder.append(RequirementHelper.genTableRow(true, "Target element", "Relation type"));
            for (EObject eObject : outgoingRelations) {
                String relationTypeName = RequirementHelper.getRelationTypeName((AbstractRelation)eObject);
                Requirement target = ((CapellaOutgoingRelation)eObject).getTarget();
                String hyperlinkFromElement = RequirementsServices.getHyperlinkFromElement((EObject)target);
                builder.append(RequirementHelper.genTableRow(false, hyperlinkFromElement, relationTypeName));
            }
            builder.append("</table>").append("</div>");
        }
        return builder.toString();
    }
}

