/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.importer.preferences.internal;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.polarsys.capella.vp.requirements.importer.extension.ImportPreferencesModel;
import org.polarsys.capella.vp.requirements.ui.importer.preferences.files.FileLabelProvider;
import org.polarsys.capella.vp.requirements.ui.importer.preferences.files.PropertyFilesSelectionDialog;
import org.polarsys.capella.vp.requirements.ui.importer.preferences.internal.messages.Messages;
import org.polarsys.capella.vp.requirements.ui.importer.preferences.util.SWTUtil;

public class FilesSelectionSection {
    private ListenerList listeners = new ListenerList();
    private ImportPreferencesModel model;
    private TableViewer listViewer;

    public FilesSelectionSection(ImportPreferencesModel model) {
        this.model = model;
    }

    public Composite createComposite(final Composite parent) {
        Group grp = SWTUtil.createGroup(parent, Messages.manage_files_containing_attributes, (Layout)new GridLayout(2, false), new GridData(4, 4, true, false));
        this.listViewer = new TableViewer((Composite)grp);
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new FileLabelProvider());
        this.listViewer.setInput((Object)this.model.getPropertiesFiles());
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.verticalSpan = 2;
        this.listViewer.getControl().setLayoutData((Object)layoutData);
        Button addFile = SWTUtil.createButton((Composite)grp, 8, Messages.add_file, new GridData(4, 1, false, false));
        addFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PropertyFilesSelectionDialog fileDialog = new PropertyFilesSelectionDialog(parent.getShell(), "", 4);
                if (fileDialog.open() == 0) {
                    FilesSelectionSection.this.model.addPropertyFiles(fileDialog.getURIs());
                    FilesSelectionSection.this.listViewer.refresh();
                    FilesSelectionSection.this.fireChange();
                }
            }
        });
        Button removeFile = SWTUtil.createButton((Composite)grp, 8, Messages.remove_file, new GridData(4, 1, false, false));
        removeFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ISelection selection = FilesSelectionSection.this.listViewer.getSelection();
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    Object[] selectedElements;
                    boolean refreshAndFireChange = false;
                    Object[] objectArray = selectedElements = ((IStructuredSelection)selection).toArray();
                    int n = selectedElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selectedElement = objectArray[n2];
                        if (selectedElement instanceof URI) {
                            FilesSelectionSection.this.model.removePropertyFile((URI)selectedElement);
                            refreshAndFireChange = true;
                        }
                        ++n2;
                    }
                    if (refreshAndFireChange) {
                        FilesSelectionSection.this.listViewer.refresh();
                        FilesSelectionSection.this.fireChange();
                    }
                }
            }
        });
        return grp;
    }

    public void addListener(IPropertyListener l) {
        this.listeners.add((Object)l);
    }

    public void removeListener(IPropertyListener l) {
        this.listeners.remove((Object)l);
    }

    private void fireChange() {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertyListener element = (IPropertyListener)array[i];
            element.propertyChanged((Object)this, 0);
            ++i;
        }
    }
}

