/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaIncomingRelation;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaOutgoingRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.AbstractRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.RelationType;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;

public class RelationAnnotationHelper {
    public static final String OutgoingRelationAnnotation = "http://www.polarsys.org/capella/vp/requirements/OutgoingRelation";
    public static final String IncomingRelationAnnotation = "http://www.polarsys.org/capella/vp/requirements/IncomingRelation";
    private static final String idseparator = ";";

    public static Map<String, Couple<Requirement, RelationType>> getAllocations(DRepresentation representation, String relationType) {
        HashMap<String, Couple<Requirement, RelationType>> result = new HashMap<String, Couple<Requirement, RelationType>>();
        DAnnotation annotation = RepresentationHelper.getAnnotation((String)relationType, (DRepresentation)representation);
        if (annotation != null) {
            for (Map.Entry detail : annotation.getDetails()) {
                String id = (String)detail.getKey();
                String elementURIs = (String)detail.getValue();
                if (elementURIs == null || elementURIs.isEmpty()) continue;
                try {
                    URI typeURI;
                    String[] elementURI = elementURIs.split(idseparator);
                    String reqId = elementURI[0];
                    URI reqURI = URI.createURI((String)reqId);
                    if (reqURI != null && reqURI.hasFragment()) {
                        reqId = reqURI.fragment();
                    }
                    String typeId = null;
                    if (elementURI.length > 1) {
                        typeId = elementURI[1];
                    }
                    if (typeId != null && (typeURI = URI.createURI((String)typeId)) != null && typeURI.hasFragment()) {
                        typeId = typeURI.fragment();
                    }
                    if (reqId == null || reqId.isEmpty()) continue;
                    for (Resource resource : RepresentationHelper.getSemanticResources((DRepresentation)representation)) {
                        if (resource == null) continue;
                        EObject reqObj = resource.getEObject(reqId);
                        EObject typeObj = null;
                        if (typeId != null && !typeId.isEmpty()) {
                            typeObj = resource.getEObject(typeId);
                        }
                        if (!(reqObj instanceof Requirement)) continue;
                        result.put(id, (Couple<Requirement, RelationType>)new Couple((Object)((Requirement)reqObj), typeObj != null && typeObj instanceof RelationType ? (RelationType)typeObj : null));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static RelationType getAllocationType(DRepresentation representation, String relationType, Requirement requirement) {
        RelationType type = null;
        for (Couple<Requirement, RelationType> allocation : RelationAnnotationHelper.getAllocations(representation, relationType).values()) {
            if (!((Requirement)allocation.getKey()).equals(requirement)) continue;
            return (RelationType)allocation.getValue();
        }
        return type;
    }

    public static void addAllocations(final DRepresentation representation, final String relationType, Collection<Couple<EObject, EObject>> elements) {
        final HashMap<Requirement, RelationType> elementsToBeAdded = new HashMap<Requirement, RelationType>(0);
        for (Couple<EObject, EObject> couple : elements) {
            elementsToBeAdded.put((Requirement)couple.getKey(), (RelationType)couple.getValue());
        }
        for (Couple<EObject, EObject> couple : RelationAnnotationHelper.getAllocations(representation, relationType).values()) {
            Requirement requirement = (Requirement)couple.getKey();
            if (!elementsToBeAdded.containsKey(requirement)) continue;
            elementsToBeAdded.remove(requirement);
        }
        TransactionHelper.getExecutionManager((EObject)representation).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                DAnnotation annotation = RepresentationHelper.getAnnotation((String)relationType, (DRepresentation)representation);
                if (annotation == null) {
                    annotation = RepresentationHelper.createAnnotation((String)relationType, (DRepresentation)representation);
                }
                for (Map.Entry entry : elementsToBeAdded.entrySet()) {
                    String reqId = ((Requirement)entry.getKey()).getId();
                    String typeId = null;
                    if (entry.getValue() != null) {
                        typeId = ((RelationType)entry.getValue()).getId();
                    }
                    annotation.getDetails().put((Object)EcoreUtil.generateUUID(), (Object)(String.valueOf(reqId) + (typeId == null ? "" : RelationAnnotationHelper.idseparator + typeId)));
                }
            }
        });
    }

    public static void removeAllocations(DRepresentation representation, Collection<Object> elements) {
        RelationAnnotationHelper.removeAllocations(representation, IncomingRelationAnnotation, elements);
        RelationAnnotationHelper.removeAllocations(representation, OutgoingRelationAnnotation, elements);
    }

    public static void removeAllocations(final DRepresentation representation, final String relationType, Collection<Object> elements) {
        final ArrayList<Requirement> elementsToBeDestroyed = new ArrayList<Requirement>(0);
        for (Couple<Requirement, RelationType> allocation : RelationAnnotationHelper.getAllocations(representation, relationType).values()) {
            Requirement requirement = (Requirement)allocation.getKey();
            if (!elements.contains(requirement)) continue;
            elementsToBeDestroyed.add(requirement);
        }
        TransactionHelper.getExecutionManager((EObject)representation).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                DAnnotation annotation = RepresentationHelper.getAnnotation((String)relationType, (DRepresentation)representation);
                if (annotation != null) {
                    for (Requirement requirement : elementsToBeDestroyed) {
                        for (String key : RelationAnnotationHelper.getKeysByValue((EMap<String, String>)annotation.getDetails(), requirement.getId())) {
                            annotation.getDetails().remove((Object)key);
                        }
                    }
                }
            }
        });
    }

    private static Set<String> getKeysByValue(EMap<String, String> map, String value) {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getValue()).startsWith(String.valueOf(value) + idseparator)) continue;
            keys.add((String)entry.getKey());
        }
        return keys;
    }

    public static void addAllocation(final DRepresentation representation, final String relationType, final Couple<EObject, EObject> element) {
        TransactionHelper.getExecutionManager((EObject)representation).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                DAnnotation annotation = RepresentationHelper.getAnnotation((String)relationType, (DRepresentation)representation);
                if (annotation == null) {
                    annotation = RepresentationHelper.createAnnotation((String)relationType, (DRepresentation)representation);
                }
                String reqId = ((Requirement)element.getKey()).getId();
                String typeId = null;
                if ((RelationType)element.getValue() != null) {
                    typeId = ((RelationType)element.getValue()).getId();
                }
                annotation.getDetails().put((Object)EcoreUtil.generateUUID(), (Object)(String.valueOf(reqId) + (typeId == null ? "" : RelationAnnotationHelper.idseparator + typeId)));
            }
        });
    }

    public static void removeAllocation(final DRepresentation representation, final String relationType, final String id) {
        TransactionHelper.getExecutionManager((EObject)representation).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                DAnnotation annotation = RepresentationHelper.getAnnotation((String)relationType, (DRepresentation)representation);
                if (annotation != null) {
                    annotation.getDetails().removeKey((Object)id);
                }
            }
        });
    }

    public static void updateAllocation(DRepresentation semanticElement, AbstractRelation relation, String id) {
        String relationType = null;
        Requirement requirement = null;
        if (relation instanceof CapellaIncomingRelation) {
            relationType = IncomingRelationAnnotation;
            requirement = ((CapellaIncomingRelation)relation).getSource();
        } else if (relation instanceof CapellaOutgoingRelation) {
            relationType = OutgoingRelationAnnotation;
            requirement = ((CapellaOutgoingRelation)relation).getTarget();
        }
        if (requirement != null && relationType != null) {
            RelationAnnotationHelper.removeAllocation(semanticElement, relationType, id);
            RelationAnnotationHelper.addAllocation(semanticElement, relationType, (Couple<EObject, EObject>)new Couple((Object)requirement, (Object)relation.getRelationType()));
        }
    }
}

