/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.mapping.impl;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQuery;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryIdentifier;

public class QueryExecution
implements IQueryExecution {
    private final QueryExecution _superExecution;
    private final IQueryIdentifier<?> _queryID;
    private final Object _value;

    public QueryExecution() {
        this._superExecution = null;
        this._queryID = null;
        this._value = null;
    }

    protected QueryExecution(QueryExecution superExecution_p, IQueryIdentifier<?> queryID_p, Object value_p) {
        assert (superExecution_p != null && queryID_p != null);
        this._superExecution = superExecution_p;
        this._queryID = queryID_p;
        this._value = value_p;
    }

    @Override
    public <O> O get(IQuery<?, O> query_p) {
        return this.get((IQueryIdentifier)query_p.getID());
    }

    @Override
    public <O> O get(IQueryIdentifier<O> queryID_p) {
        if (queryID_p.equals(this._queryID)) {
            return (O)this._value;
        }
        return this._superExecution.get(queryID_p);
    }

    @Override
    public List<Object> getAll() {
        List<Object> result;
        QueryExecution superEnv = this.getSuperExecution();
        if (superEnv == null) {
            result = new LinkedList<Object>();
        } else {
            result = superEnv.getAll();
            result.add(this._value);
        }
        return result;
    }

    @Override
    public Object getLast() {
        return this._value;
    }

    public List<IQueryIdentifier<?>> getQueryIdentifiers() {
        List<IQueryIdentifier<?>> result;
        QueryExecution superEnv = this.getSuperExecution();
        if (superEnv == null) {
            result = new LinkedList();
        } else {
            result = superEnv.getQueryIdentifiers();
            result.add(this._queryID);
        }
        return result;
    }

    public QueryExecution getSuperExecution() {
        return this._superExecution;
    }

    public boolean isAncestorOf(IQueryExecution peer_p) {
        if (peer_p instanceof QueryExecution) {
            QueryExecution superExec = ((QueryExecution)peer_p).getSuperExecution();
            while (superExec != null) {
                if (this.equals(superExec)) {
                    return true;
                }
                superExec = superExec.getSuperExecution();
            }
        }
        return false;
    }

    public boolean isAncestorOrEquals(IQueryExecution peer_p) {
        return this.equals(peer_p) ? true : this.isAncestorOf(peer_p);
    }

    public <O> QueryExecution newWith(IQueryIdentifier<O> queryID_p, O value_p) {
        return new QueryExecution(this, queryID_p, value_p);
    }
}

