/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaIncomingRelation;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaOutgoingRelation;
import org.polarsys.capella.vp.requirements.model.helpers.RelationAnnotationHelper;
import org.polarsys.kitalpha.emde.model.ElementExtension;
import org.polarsys.kitalpha.vp.requirements.Requirements.AbstractRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.InternalRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;

public class REQ_Relation_02
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        Map<UniqueRelation, Integer> uniqueRelationCountMap = this.getUniqueRelationCountMap(target);
        for (Map.Entry<UniqueRelation, Integer> entry : uniqueRelationCountMap.entrySet()) {
            if (entry.getValue() <= 1) continue;
            String msg = NLS.bind((String)"''{0}'' [{1}] contains {2} duplicated relations ''{5}'' between source ''{3}'' and target ''{4}''", (Object[])new String[]{EObjectLabelProviderHelper.getText((Object)target), EObjectLabelProviderHelper.getMetaclassLabel((EObject)target, (boolean)false), "" + entry.getValue(), EObjectLabelProviderHelper.getText((Object)entry.getKey().getSourceElement()), EObjectLabelProviderHelper.getText((Object)entry.getKey().getTargetElement()), EObjectLabelProviderHelper.getText((Object)entry.getKey().getRelationType())});
            IStatus failureStatus = ctx.createFailureStatus(new Object[]{msg});
            statuses.add(failureStatus);
        }
        if (!statuses.isEmpty()) {
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
        }
        return ctx.createSuccessStatus();
    }

    protected Map<UniqueRelation, Integer> getUniqueRelationCountMap(EObject target) {
        HashMap<UniqueRelation, Integer> relationCountMap = new HashMap<UniqueRelation, Integer>();
        for (UniqueRelation relation : this.getRelations(target)) {
            if (!this.isUniqueRelationValid(relation)) continue;
            this.updateRelationCountMap(relationCountMap, relation);
        }
        return relationCountMap;
    }

    private Collection<UniqueRelation> getRelations(EObject target) {
        ArrayList<UniqueRelation> result;
        block8: {
            block9: {
                block7: {
                    result = new ArrayList<UniqueRelation>();
                    if (!(target instanceof Requirement)) break block7;
                    Requirement req = (Requirement)target;
                    for (AbstractRelation relation : req.getOwnedRelations()) {
                        if (relation instanceof InternalRelation) {
                            result.add(new UniqueRelation((InternalRelation)relation));
                            continue;
                        }
                        if (!(relation instanceof CapellaIncomingRelation)) continue;
                        result.add(new UniqueRelation((CapellaIncomingRelation)relation));
                    }
                    for (DAnnotation annotation : RelationAnnotationHelper.getIncomingAnnotations((Requirement)req)) {
                        result.add(new UniqueRelation(annotation));
                    }
                    for (DAnnotation annotation : RelationAnnotationHelper.getOutgoingAnnotations((Requirement)req)) {
                        result.add(new UniqueRelation(annotation));
                    }
                    break block8;
                }
                if (!(target instanceof CapellaElement)) break block9;
                CapellaElement capellaElement = (CapellaElement)target;
                for (ElementExtension ext : capellaElement.getOwnedExtensions()) {
                    if (!(ext instanceof CapellaOutgoingRelation)) continue;
                    result.add(new UniqueRelation((CapellaOutgoingRelation)ext));
                }
                break block8;
            }
            if (!(target instanceof DRepresentationDescriptor)) break block8;
            DRepresentationDescriptor descriptor = (DRepresentationDescriptor)target;
            for (DAnnotation annotation : RelationAnnotationHelper.getAllocations((DRepresentationDescriptor)descriptor, (String)"http://www.polarsys.org/capella/vp/requirements/IncomingRelation")) {
                result.add(new UniqueRelation(annotation));
            }
            for (DAnnotation annotation : RelationAnnotationHelper.getAllocations((DRepresentationDescriptor)descriptor, (String)"http://www.polarsys.org/capella/vp/requirements/OutgoingRelation")) {
                result.add(new UniqueRelation(annotation));
            }
        }
        return result;
    }

    protected void updateRelationCountMap(Map<UniqueRelation, Integer> relationCountMap, UniqueRelation uniqueRelation) {
        if (relationCountMap.containsKey(uniqueRelation)) {
            relationCountMap.put(uniqueRelation, relationCountMap.get(uniqueRelation) + 1);
        } else {
            relationCountMap.put(uniqueRelation, 1);
        }
    }

    protected boolean isUniqueRelationValid(UniqueRelation uniqueRelation) {
        return uniqueRelation.getSourceElement() != null && uniqueRelation.getTargetElement() != null && uniqueRelation.getRelationType() != null;
    }

    class UniqueRelation {
        EObject source;
        EObject target;
        EObject relationType;

        public UniqueRelation(DAnnotation annotation) {
            this((EObject)RelationAnnotationHelper.getDescriptor((DAnnotation)annotation), (EObject)RelationAnnotationHelper.getRequirement((DAnnotation)annotation), (EObject)RelationAnnotationHelper.getRelationType((DAnnotation)annotation));
        }

        public UniqueRelation(CapellaOutgoingRelation relation) {
            this((EObject)relation.getSource(), (EObject)relation.getTarget(), (EObject)relation.getRelationType());
        }

        public UniqueRelation(CapellaIncomingRelation relation) {
            this((EObject)relation.getSource(), (EObject)relation.getTarget(), (EObject)relation.getRelationType());
        }

        public UniqueRelation(InternalRelation relation) {
            this((EObject)relation.getSource(), (EObject)relation.getTarget(), (EObject)relation.getRelationType());
        }

        public UniqueRelation(EObject source, EObject target, EObject relationType) {
            this.source = source;
            this.target = target;
            this.relationType = relationType;
        }

        public EObject getSourceElement() {
            return this.source;
        }

        public EObject getTargetElement() {
            return this.target;
        }

        public EObject getRelationType() {
            return this.relationType;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            UniqueRelation relationToCompare = (UniqueRelation)obj;
            return this.source.equals(relationToCompare.getSourceElement()) && this.target.equals(relationToCompare.getTargetElement()) && this.relationType.equals(relationToCompare.getRelationType());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            result = 31 * result + (this.relationType == null ? 0 : this.relationType.hashCode());
            return result;
        }
    }
}

