/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.move;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.cybersecurity.test.move.AbstractCybersecurityMoveTest;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public class CybersecurityCopyPasteTest
extends AbstractCybersecurityMoveTest {
    public void test() throws Exception {
        this.init();
        this.checkMoveDisabled((EObject)this.saPkg, (EObject)this.oaArch, "CybersecurityPkg can't be moved to different architecture");
        this.checkMoveDisabled((EObject)this.threatSASub, (EObject)this.oaArch, "Cybersecurity element can't be moved to different architecture");
        this.checkMoveDisabled((EObject)this.fpaSASub, (EObject)this.laPkg, "Cybersecurity element can't be moved to different architecture");
        this.checkMoveDisabled((EObject)this.subSAPkg, (EObject)this.laPkg, "CybersecurityPkg can't be moved to different architecture");
        this.checkCopyDisabled((EObject)this.saPkg, (EObject)this.oaArch, "CybersecurityPkg can't be copied to different architecture");
        this.checkCopyDisabled((EObject)this.threatSASub, (EObject)this.oaArch, "Cybersecurity element can't be copied to different architecture");
        this.checkCopyDisabled((EObject)this.fpaSASub, (EObject)this.laPkg, "Cybersecurity element can't be copied to different architecture");
        this.checkCopyDisabled((EObject)this.subSAPkg, (EObject)this.laPkg, "CybersecurityPkg can't be copied to different architecture");
        this.checkMoveDisabled((EObject)this.subSAPkg1, (EObject)this.saArch, "CybersecurityPkg can't be moved as root package");
        this.checkCopyDisabled((EObject)this.subSAPkg1, (EObject)this.saArch, "CybersecurityPkg can't be copied as root package");
        this.checkCopyDisabled((EObject)this.threatSASub1, (EObject)this.saArch, "Cybersecurity element can't be copied to architecture");
        this.checkMoveAllowed((EObject)this.threatSASub, (EObject)this.saPkg, "Cybersecurity element can be moved to other CybersecurityPkg at same architecture");
        int countThreats = this.saPkg.getOwnedThreats().size();
        GuiActions.copyAndPaste((TransactionalEditingDomain)this.ted, Arrays.asList(this.threatSASub), (EObject)this.saPkg);
        CybersecurityCopyPasteTest.assertEquals((int)this.saPkg.getOwnedThreats().size(), (int)(countThreats + 1));
        this.checkMoveAllowed((EObject)this.subSAPkg1, (EObject)this.saPkg, "CybersecurityPkg can be moved to other CybersecurityPkg at same architecture");
        int countPkgs = this.saPkg.getOwnedCybersecurityPkgs().size();
        GuiActions.copyAndPaste((TransactionalEditingDomain)this.ted, Arrays.asList(this.subSAPkg1), (EObject)this.saPkg);
        CybersecurityCopyPasteTest.assertEquals((int)this.saPkg.getOwnedCybersecurityPkgs().size(), (int)(countPkgs + 1));
    }
}

