/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.TextAreaValueGroup;
import org.polarsys.capella.core.ui.properties.fields.TextValueGroup;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.ui.CommonHelpers;
import org.polarsys.capella.cybersecurity.ui.ElementExtensionStorage;
import org.polarsys.capella.cybersecurity.ui.ElementExtensionStorageImpl;
import org.polarsys.capella.cybersecurity.ui.properties.fields.IntegerValueRadioGroup;
import org.polarsys.capella.cybersecurity.ui.properties.fields.SemanticCheckboxGroup;
import org.polarsys.capella.cybersecurity.ui.properties.sections.CybersecurityPropertyButtonListener;
import org.polarsys.capella.cybersecurity.ui.properties.sections.Messages;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class ActorCybersecuritySection
extends AbstractSection {
    private TrustBoundaryStorage elementExtension;
    private SemanticCheckboxGroup checkBoxes;
    private IntegerValueRadioGroup threatSourceProfileGroup;
    private TextValueGroup rationaleGroup;

    public boolean select(Object eObject) {
        EObject eObjectToTest = super.selection(eObject);
        if (eObjectToTest == null) {
            return false;
        }
        if (eObjectToTest instanceof TrustBoundaryStorage) {
            return true;
        }
        EObject children = this.getTrustBoundaryStorageObject(eObjectToTest);
        return children != null;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject newEObject = super.setInputSelection(part, selection);
        if (newEObject != null && !(newEObject instanceof TrustBoundaryStorage)) {
            newEObject = this.getTrustBoundaryStorageObject(newEObject);
        }
        if (newEObject != null) {
            this.loadData(newEObject);
        }
    }

    private EObject getTrustBoundaryStorageObject(EObject parent) {
        if (parent == null) {
            return null;
        }
        if (!CommonHelpers.isViewpointActive(parent, "org.polarsys.capella.cybersecurity")) {
            return null;
        }
        Object result = null;
        for (EObject iEObject : parent.eContents()) {
            if (!(iEObject instanceof TrustBoundaryStorage)) continue;
            TrustBoundaryStorage trustBoundaryStorage = result = result == null ? (TrustBoundaryStorage)iEObject : null;
            if (result == null) break;
        }
        if (result == null && CommonHelpers.canBeExtendedBy(parent, CybersecurityPackage.Literals.TRUST_BOUNDARY_STORAGE)) {
            for (ElementExtensionStorageImpl adapter : parent.eAdapters()) {
                if (!(adapter instanceof ElementExtensionStorage) || !(((ElementExtensionStorage)adapter).getExtension() instanceof TrustBoundaryStorage)) continue;
                result = ((ElementExtensionStorage)adapter).getExtension();
            }
            if (result == null) {
                ElementExtensionStorageImpl adapter;
                adapter = new ElementExtensionStorageImpl((ExtensibleElement)parent, CybersecurityPackage.Literals.TRUST_BOUNDARY_STORAGE);
                result = adapter.getExtension();
            }
        }
        return result;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Group checkGroup = this.getWidgetFactory().createGroup(this.rootParentComposite, "");
        checkGroup.setLayout((Layout)new GridLayout(2, false));
        checkGroup.setLayoutData((Object)new GridData(768));
        this.checkBoxes = new SemanticCheckboxGroup((Composite)checkGroup, this.getWidgetFactory());
        this.checkBoxes.addCheckbox(CybersecurityPackage.Literals.TRUST_BOUNDARY_STORAGE__TRUSTED, e -> !((TrustBoundaryStorage)e).isThreatSource());
        this.checkBoxes.addCheckbox(CybersecurityPackage.Literals.TRUST_BOUNDARY_STORAGE__THREAT_SOURCE, e -> {
            EObject container = ElementExtensionStorage.findContainer(e);
            return container instanceof Component && (((Component)container).isActor() || container instanceof Entity);
        });
        this.threatSourceProfileGroup = new IntegerValueRadioGroup(this.rootParentComposite, Messages.ActorCybersecuritySection_0, this.getWidgetFactory(), 1, 5);
        this.rationaleGroup = new TextAreaValueGroup(this.rootParentComposite, Messages.ActorCybersecuritySection_1, this.getWidgetFactory());
        CybersecurityPropertyButtonListener.getCybersecurityPropertyListener().registerPropertySection(this);
    }

    public void loadData(EObject object) {
        super.loadData(object);
        this.checkBoxes.loadData(object);
        this.threatSourceProfileGroup.loadData(object, (EStructuralFeature)CybersecurityPackage.Literals.TRUST_BOUNDARY_STORAGE__THREAT_SOURCE_PROFILE);
        this.rationaleGroup.loadData(object, (EStructuralFeature)CybersecurityPackage.Literals.TRUST_BOUNDARY_STORAGE__RATIONALE);
        this.elementExtension = (TrustBoundaryStorage)object;
        this.threatSourceProfileGroup.setEnabled(object.eContainer() instanceof Component && (((Component)object.eContainer()).isActor() || object.eContainer() instanceof Entity) && !this.elementExtension.isTrusted());
        if (this.elementExtension.isTrusted()) {
            this.threatSourceProfileGroup.getSemanticFields().forEach(button -> button.setSelection(false));
        }
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> abstractSemanticFields = new ArrayList<AbstractSemanticField>();
        abstractSemanticFields.add((AbstractSemanticField)this.checkBoxes);
        abstractSemanticFields.add((AbstractSemanticField)this.threatSourceProfileGroup);
        abstractSemanticFields.add((AbstractSemanticField)this.rationaleGroup);
        return abstractSemanticFields;
    }

    public void refresh() {
        if (this.elementExtension != null) {
            this.loadData((EObject)this.elementExtension);
        }
    }

    public void dispose() {
        super.dispose();
        CybersecurityPropertyButtonListener.getCybersecurityPropertyListener().unregisterPropertySection(this);
    }
}

