/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.basic.requirement.tests.ju;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.polarsys.capella.basic.requirement.Requirement;
import org.polarsys.capella.basic.requirement.RequirementPackage;
import org.polarsys.capella.basic.requirement.RequirementsPkg;
import org.polarsys.capella.basic.requirement.RequirementsTrace;
import org.polarsys.capella.basic.requirement.SystemFunctionalInterfaceRequirement;
import org.polarsys.capella.basic.requirement.SystemFunctionalRequirement;
import org.polarsys.capella.basic.requirement.SystemNonFunctionalInterfaceRequirement;
import org.polarsys.capella.basic.requirement.SystemNonFunctionalRequirement;
import org.polarsys.capella.basic.requirement.SystemUserRequirement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.Trace;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.table.ju.utils.AbstractTableActionCommand;
import org.polarsys.capella.test.table.ju.utils.AbstractTableToolStep;
import org.polarsys.capella.test.table.ju.utils.AbstractTableTransactionToolStep;
import org.polarsys.capella.test.table.ju.utils.CreateCellFromIntersectionCommand;
import org.polarsys.capella.test.table.ju.utils.HideTableElementCommand;
import org.polarsys.capella.test.table.ju.utils.TableTestFramework;
import org.polarsys.capella.test.table.ju.utils.TableTestingHelper;

public abstract class RequirementsTableTestFramework
extends TableTestFramework {
    protected String modelName = "CrossTable-OA";
    protected Session session;
    protected SessionContext context;
    protected String pABDiagramName = "";
    protected String rootReqPkgId = "d2e2d479-ef25-433b-a922-34de67211ef0";
    protected RequirementsPkg _rootReqPkg;
    protected Requirement _systemUserReq;
    protected Requirement _systemFuncReq;
    protected Requirement _systemNonFuncReq;
    protected Requirement _systemFuncInterReq;
    protected Requirement _systemNonFuncInterReq;
    protected RequirementsPkg _subReqPkg;
    protected String crossTableOAName = "Operational Activities - Requirements";
    protected String requirementsName = "Requirements";
    protected String operationalAnalysisId = "03308ea5-1659-41ae-ab94-1b0b9c098dc5";
    protected String deliverMetInfoOAId = "62d5d005-54f0-44a1-bb9b-aabbdf369736";
    protected String captureMetDataOAId = "e40d356a-7f66-4ef4-b6ab-bf90529dfe04";
    protected String captureMetDataReqId = "0e75b6fb-dbc6-4d4b-a91d-57e344116276";
    protected String publishMetReportOAId = "d0fcd409-2f60-4409-9ead-907d905098fb";
    protected String buildMetReportOAId = "b5682772-0698-488c-bba3-b10a09f209d2";
    protected String elabMetForecastOAId = "c1c8004e-98d6-4adf-8fa6-e66df914d735";
    protected String elabCurrSituationOAId = "a4e551ca-1d6d-4cda-ae16-63c1d594103e";
    protected String accessMetReportOAId = "b8881ae7-95fa-4762-b607-6e5bf330d4c8";
    protected String makeMetDataEvolveOAId = "7a12df46-8c90-444f-bb18-53b719912386";
    protected String publishMetReportReqId = "871f791b-c246-44bf-8e27-787cb6acc74f";
    protected String buildMetReportReqId = "22866ea7-6aeb-46cf-8c41-2991dae9dcc2";
    protected String elabMetForecastReqId = "bde8a3ea-2879-46b1-870b-05437d6e3d07";
    protected String elabCurrSituationReqId = "b36524a8-16e7-49a6-b9ce-72feed229fe2";
    protected String accessMetReportReqId = "ae23499e-23f7-417e-96f6-b50b0674729b";
    protected String makeMetDataEvolveReqId = "d58542df-d56e-4cbc-97e8-f9900bd9c0e3";
    protected String reqNullErrMsg = "Created requirement is null";
    protected String traceNullErrMsg = "Requirements Trace is null";
    protected String traceTypeErrMsg = "Created Trace is not instanceof RequirementsTrace";
    protected String sourceEltErrMsg = "Source Element of Trace {0} is not {1}";
    protected String targetEltErrMsg = "Target Element of Trace {0} is not {1}";
    protected OperationalActivity _deliverMetInfoOA;
    protected OperationalActivity _captureMetDataOA;
    protected OperationalActivity _publishMetReportOA;
    protected OperationalActivity _buildMetReportOA;
    protected OperationalActivity _elabMetForecastOA;
    protected OperationalActivity _elabCurrSituationOA;
    protected OperationalActivity _accessMetReportOA;
    protected OperationalActivity _makeMetDataEvolveOA;
    protected Requirement _captureMetDataReq;
    protected Requirement _publishMetReportReq;
    protected Requirement _buildMetReportReq;
    protected Requirement _elabMetForecastReq;
    protected Requirement _elabCurrSituationReq;
    protected Requirement _accessMetReportReq;
    protected Requirement _makeMetDataEvolveReq;
    protected EClass createCellToolClass = DescriptionPackage.Literals.CREATE_CELL_TOOL;

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.modelName);
    }

    protected void init() {
        this.session = this.getSession(this.modelName);
        this.context = new SessionContext(this.session);
        this._rootReqPkg = (RequirementsPkg)this.context.getSemanticElement(this.rootReqPkgId);
        this._deliverMetInfoOA = (OperationalActivity)this.context.getSemanticElement(this.deliverMetInfoOAId);
        this._captureMetDataOA = (OperationalActivity)this.context.getSemanticElement(this.captureMetDataOAId);
        this._publishMetReportOA = (OperationalActivity)this.context.getSemanticElement(this.publishMetReportOAId);
        this._buildMetReportOA = (OperationalActivity)this.context.getSemanticElement(this.buildMetReportOAId);
        this._elabMetForecastOA = (OperationalActivity)this.context.getSemanticElement(this.elabMetForecastOAId);
        this._elabCurrSituationOA = (OperationalActivity)this.context.getSemanticElement(this.elabCurrSituationOAId);
        this._accessMetReportOA = (OperationalActivity)this.context.getSemanticElement(this.accessMetReportOAId);
        this._makeMetDataEvolveOA = (OperationalActivity)this.context.getSemanticElement(this.makeMetDataEvolveOAId);
        this._captureMetDataReq = (Requirement)this.context.getSemanticElement(this.captureMetDataReqId);
        this._publishMetReportReq = (Requirement)this.context.getSemanticElement(this.publishMetReportReqId);
        this._buildMetReportReq = (Requirement)this.context.getSemanticElement(this.buildMetReportReqId);
        this._elabMetForecastReq = (Requirement)this.context.getSemanticElement(this.elabMetForecastReqId);
        this._elabCurrSituationReq = (Requirement)this.context.getSemanticElement(this.elabCurrSituationReqId);
        this._accessMetReportReq = (Requirement)this.context.getSemanticElement(this.accessMetReportReqId);
        this._makeMetDataEvolveReq = (Requirement)this.context.getSemanticElement(this.makeMetDataEvolveReqId);
    }

    public void createRequirementTrace(DTable table, final EObject obj, final EObject reqObj) {
        new AbstractTableToolStep(this.context, this.createCellToolClass, table){

            protected void initToolArguments() {
                DLine line = TableTestingHelper.getLine((DTable)this.table, (EObject)obj);
                DColumn column = TableTestingHelper.getColumn((DTable)this.table, (EObject)reqObj);
                CreateCellFromIntersectionCommand cellCommand = new CreateCellFromIntersectionCommand(this.table, line, column, "X");
                cellCommand.execute();
                DCell container = TableTestingHelper.getIntersectionCell((DLine)line, (DColumn)column);
                String tableCellMask = "X";
                this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, (Object)container);
                this._toolWrapper.setArgumentValue(ArgumentType.TABLE_CELL_MASK, (Object)tableCellMask);
            }

            protected void postRunTest() {
                super.postRunTest();
                Trace reqTrace = (Trace)TableTestingHelper.getRecentlyCreatedCapellaElement((EObject)obj, (EReference)ModellingcorePackage.Literals.TRACEABLE_ELEMENT__OUTGOING_TRACES);
                RequirementsTableTestFramework.assertNotNull((String)RequirementsTableTestFramework.this.traceNullErrMsg, (Object)reqTrace);
                RequirementsTableTestFramework.assertTrue((String)RequirementsTableTestFramework.this.traceTypeErrMsg, (boolean)(reqTrace instanceof RequirementsTrace));
                RequirementsTableTestFramework.assertEquals((String)NLS.bind((String)RequirementsTableTestFramework.this.sourceEltErrMsg, (Object)reqTrace, (Object)EObjectExt.getText((EObject)obj)), (Object)obj, (Object)reqTrace.getSourceElement());
                RequirementsTableTestFramework.assertEquals((String)NLS.bind((String)RequirementsTableTestFramework.this.targetEltErrMsg, (Object)reqTrace, (Object)EObjectExt.getText((EObject)reqObj)), (Object)reqObj, (Object)reqTrace.getTargetElement());
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    public void hideLineWithChildren(final DTable table, final EObject obj) {
        new AbstractTableTransactionToolStep(this.context){

            protected void postRunTest() {
                super.postRunTest();
                DLine parent = TableTestingHelper.getLine((DTable)table, (EObject)obj);
                RequirementsTableTestFramework.assertFalse((String)NLS.bind((String)this.tableEltHiddenErrMsg, (Object)parent.getLabel()), (boolean)parent.isVisible());
                DLine child1 = TableTestingHelper.getLine((DTable)table, (EObject)RequirementsTableTestFramework.this._publishMetReportOA);
                DLine child2 = TableTestingHelper.getLine((DTable)table, (EObject)RequirementsTableTestFramework.this._buildMetReportOA);
                DLine child3 = TableTestingHelper.getLine((DTable)table, (EObject)RequirementsTableTestFramework.this._elabMetForecastOA);
                DLine child4 = TableTestingHelper.getLine((DTable)table, (EObject)RequirementsTableTestFramework.this._elabCurrSituationOA);
                RequirementsTableTestFramework.assertFalse((String)NLS.bind((String)this.tableEltHiddenErrMsg, (Object)child1.getLabel()), (boolean)child1.isVisible());
                RequirementsTableTestFramework.assertTrue((String)NLS.bind((String)this.tableEltHiddenErrMsg, (Object)child2.getLabel()), (boolean)child2.isVisible());
                RequirementsTableTestFramework.assertTrue((String)NLS.bind((String)this.tableEltHiddenErrMsg, (Object)child3.getLabel()), (boolean)child3.isVisible());
                RequirementsTableTestFramework.assertTrue((String)NLS.bind((String)this.tableEltHiddenErrMsg, (Object)child4.getLabel()), (boolean)child4.isVisible());
            }

            protected AbstractTableActionCommand getTableTransactionalCommand() {
                DLine line = TableTestingHelper.getLine((DTable)table, (EObject)obj);
                return new HideTableElementCommand(table, (DTableElement)line, TablePackage.Literals.DLINE__VISIBLE);
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    public void deleteRequirementTrace(DTable table, final EObject obj, final EObject reqObj) {
        new AbstractTableToolStep(this.context, this.createCellToolClass, table){

            protected void initToolArguments() {
                DLine line = TableTestingHelper.getLine((DTable)this.table, (EObject)obj);
                DColumn column = TableTestingHelper.getColumn((DTable)this.table, (EObject)reqObj);
                DCell container = TableTestingHelper.getIntersectionCell((DLine)line, (DColumn)column);
                String tableCellMask = "";
                this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, (Object)container);
                this._toolWrapper.setArgumentValue(ArgumentType.TABLE_CELL_MASK, (Object)tableCellMask);
            }

            protected void postRunTest() {
                super.postRunTest();
                Trace reqTrace = (Trace)TableTestingHelper.getRecentlyCreatedCapellaElement((EObject)RequirementsTableTestFramework.this._captureMetDataOA, (EReference)ModellingcorePackage.Literals.TRACEABLE_ELEMENT__OUTGOING_TRACES);
                RequirementsTableTestFramework.assertNull((String)RequirementsTableTestFramework.this.traceNullErrMsg, (Object)reqTrace);
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    public Requirement createRequirementSUR(DTable table, RequirementsPkg req) {
        return this.createRequirement(table, req, "System User Requirement", SystemUserRequirement.class);
    }

    public Requirement createRequirementSFR(DTable table, RequirementsPkg req) {
        return this.createRequirement(table, req, "System Functional Requirement", SystemFunctionalRequirement.class);
    }

    public Requirement createRequirementSFIR(DTable table, RequirementsPkg req) {
        return this.createRequirement(table, req, "System Functional Interface Requirement", SystemFunctionalInterfaceRequirement.class);
    }

    public Requirement createRequirementSNFR(DTable table, RequirementsPkg req) {
        return this.createRequirement(table, req, "System Non Functional Requirement", SystemNonFunctionalRequirement.class);
    }

    public Requirement createRequirementSNFIR(DTable table, RequirementsPkg req) {
        return this.createRequirement(table, req, "System Non Functional Interface Requirement", SystemNonFunctionalInterfaceRequirement.class);
    }

    public Requirement createRequirementREQPKG(DTable table, RequirementsPkg req) {
        return this.createRequirement(table, req, "Requirement Pkg", null);
    }

    public Requirement createRequirement(DTable table, final RequirementsPkg req, String toolName, final Class<? extends Requirement> createdReqClass) {
        return (Requirement)new AbstractTableToolStep(this.context, toolName, DescriptionPackage.Literals.CREATE_LINE_TOOL, table){
            protected Requirement requirement;

            protected void initToolArguments() {
                DLine container = TableTestingHelper.getLine((DTable)this.table, (EObject)req);
                RequirementsPkg semanticContainer = req;
                this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, (Object)container);
                this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER, (Object)semanticContainer);
            }

            protected void postRunTest() {
                super.postRunTest();
                this.requirement = (Requirement)TableTestingHelper.getRecentlyCreatedCapellaElement((EObject)req, (EReference)RequirementPackage.Literals.REQUIREMENTS_PKG__OWNED_REQUIREMENTS);
                RequirementsTableTestFramework.assertNotNull((String)RequirementsTableTestFramework.this.reqNullErrMsg, (Object)this.requirement);
                RequirementsTableTestFramework.assertTrue((this.requirement.eContainer() == req ? 1 : 0) != 0);
                if (createdReqClass != null) {
                    RequirementsTableTestFramework.assertTrue((boolean)createdReqClass.isInstance(this.requirement));
                }
            }

            public Object getResult() {
                return this.requirement;
            }
        }.run();
    }
}

