/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.mass.mass.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.polarsys.capella.common.lib.IdGenerator;
import org.polarsys.capella.vp.mass.mass.Mass;
import org.polarsys.capella.vp.mass.mass.MassFactory;
import org.polarsys.capella.vp.mass.mass.MassPackage;
import org.polarsys.capella.vp.mass.mass.PartMass;
import org.polarsys.capella.vp.mass.mass.impl.MassImpl;
import org.polarsys.capella.vp.mass.mass.impl.PartMassImpl;

public class MassFactoryImpl
extends EFactoryImpl
implements MassFactory {
    public static MassFactory init() {
        try {
            MassFactory theMassFactory = (MassFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.polarsys.org/capella/mass");
            if (theMassFactory != null) {
                return theMassFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new MassFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createMass();
            }
            case 1: {
                return this.createPartMass();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Mass createMass() {
        MassImpl mass = new MassImpl();
        mass.setId(IdGenerator.createId());
        return mass;
    }

    public PartMass createPartMass() {
        PartMassImpl partMass = new PartMassImpl();
        partMass.setId(IdGenerator.createId());
        return partMass;
    }

    public MassPackage getMassPackage() {
        return (MassPackage)this.getEPackage();
    }

    @Deprecated
    public static MassPackage getPackage() {
        return MassPackage.eINSTANCE;
    }

    public Mass createMass(String name_p) {
        Mass mass = this.createMass();
        mass.setName(name_p);
        return mass;
    }

    public PartMass createPartMass(String name_p) {
        PartMass partMass = this.createPartMass();
        partMass.setName(name_p);
        return partMass;
    }
}

