/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.junit.Test;

public class ArchiveFileSaveTest
extends TestCase {
    @Test
    public void testSave() throws IOException {
        ArchiveFile file = new ArchiveFile("test.archive", "rwt");
        ArchiveEntry entry = file.createEntry("/name");
        byte[] bytes = new byte[255];
        int i = 0;
        while (i < 255) {
            bytes[i] = (byte)i;
            ++i;
        }
        entry.write(0L, bytes, 0, 255);
        file.save();
        file.close();
        this.copyFile("test.archive", "new.archive");
        ArchiveFileSaveTest.assertTrue((boolean)new File("test.archive").exists());
        file = new ArchiveFile("new.archive", "r");
        entry = file.openEntry("/name");
        ArchiveFileSaveTest.assertTrue((entry != null ? 1 : 0) != 0);
        entry.read(0L, bytes, 0, 255);
        i = 0;
        while (i < 255) {
            ArchiveFileSaveTest.assertEquals((byte)bytes[i], (byte)((byte)i));
            ++i;
        }
        entry.close();
        file.close();
        new File("test.archive").delete();
        new File("new.archive").delete();
    }

    void copyFile(String src, String tgt) throws IOException {
        RandomAccessFile srcFile = new RandomAccessFile(src, "r");
        RandomAccessFile tgtFile = new RandomAccessFile(tgt, "rw");
        byte[] bytes = new byte[(int)srcFile.length()];
        srcFile.read(bytes);
        tgtFile.setLength(0L);
        tgtFile.write(bytes);
        srcFile.close();
        tgtFile.close();
    }
}

