/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.hyphen;

import junit.framework.TestCase;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.DefaultWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Word;

public class DefaultWordRecognizerTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testWordRecognize() {
        String str = " simple \n test ";
        DefaultWordRecognizer wr = new DefaultWordRecognizer(str);
        Word word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)" ".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"simple ".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"\n".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)" ".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"test ".equals(word.getValue()));
        str = "simple\ntest";
        wr = new DefaultWordRecognizer(str);
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"simple".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"\n".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"test".equals(word.getValue()));
        str = "simple\n\n\n";
        wr = new DefaultWordRecognizer(str);
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"simple".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"\n".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"\n".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"\n".equals(word.getValue()));
        str = "first\nsecond\r\nthird\rfourth\r";
        wr = new DefaultWordRecognizer(str);
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"first".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"\n".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"second".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"\r\n".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"third".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"\r".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"fourth".equals(word.getValue()));
        word = wr.getNextWord();
        DefaultWordRecognizerTest.assertTrue((boolean)"\r".equals(word.getValue()));
    }
}

