/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.layout.pdf.WordRecognizerWrapper;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Word;

public class WordRecognizerWrapperTest
extends TestCase {
    final String testStr = " This is a test! \u4e2d\u56fd \uffe52000 $3446 \"Apple\" ";
    final String testStr2 = "(";
    final String testStr3 = ")";

    public void test() {
        WordRecognizerWrapper wr = new WordRecognizerWrapper(" This is a test! \u4e2d\u56fd \uffe52000 $3446 \"Apple\" ", Locale.ENGLISH);
        Word word = wr.getNextWord();
        WordRecognizerWrapperTest.assertTrue((boolean)" ".equals(word.getValue()));
        word = wr.getNextWord();
        WordRecognizerWrapperTest.assertTrue((boolean)"This ".equals(word.getValue()));
        word = wr.getNextWord();
        WordRecognizerWrapperTest.assertTrue((boolean)"is ".equals(word.getValue()));
        word = wr.getNextWord();
        WordRecognizerWrapperTest.assertTrue((boolean)"a ".equals(word.getValue()));
        word = wr.getNextWord();
        WordRecognizerWrapperTest.assertTrue((boolean)"test! ".equals(word.getValue()));
        word = wr.getNextWord();
        WordRecognizerWrapperTest.assertTrue((boolean)"\u4e2d".equals(word.getValue()));
        word = wr.getNextWord();
        WordRecognizerWrapperTest.assertTrue((boolean)"\u56fd ".equals(word.getValue()));
        word = wr.getNextWord();
        WordRecognizerWrapperTest.assertTrue((boolean)"\uffe52000 ".equals(word.getValue()));
        word = wr.getNextWord();
        WordRecognizerWrapperTest.assertTrue((boolean)"$3446 ".equals(word.getValue()));
        word = wr.getNextWord();
        WordRecognizerWrapperTest.assertTrue((boolean)"\"Apple\" ".equals(word.getValue()));
        wr = new WordRecognizerWrapper("(", Locale.ENGLISH);
        word = wr.getNextWord();
        WordRecognizerWrapperTest.assertTrue((boolean)"(".equals(word.getValue()));
        wr = new WordRecognizerWrapper(")", Locale.ENGLISH);
        word = wr.getNextWord();
        WordRecognizerWrapperTest.assertTrue((boolean)")".equals(word.getValue()));
    }
}

