/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutTest;
import org.eclipse.birt.report.engine.layout.pdf.TestRunAndRenderTask;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;

public class PDFPageLMTest
extends PDFLayoutTest {
    private List getPages(boolean fitToPage, boolean pagebreakPaginationOnly) throws EngineException {
        PDFRenderOption options = this.createRenderOption();
        if (fitToPage) {
            options.setOption("pdfRenderOption.pageOverflow", (Object)new Integer(2));
        }
        options.setOption("pdfRenderOption.pagebreakPaginationOnly", (Object)new Boolean(pagebreakPaginationOnly));
        return this.getPages(options);
    }

    private List getPages(int pageOverflow) throws EngineException {
        PDFRenderOption options = this.createRenderOption();
        options.setOption("pdfRenderOption.pageOverflow", (Object)pageOverflow);
        return this.getPages(options);
    }

    private List getPages(PDFRenderOption options) throws EngineException {
        String designFile = "org/eclipse/birt/report/engine/layout/pdf/fitToPage.xml";
        IReportRunnable report = this.openReportDesign(designFile);
        ArrayList pageAreas = new ArrayList();
        PDFLayoutTest.PageMonitor monitor = new PDFLayoutTest.PageMonitor(pageAreas);
        TestRunAndRenderTask runAndRenderTask = new TestRunAndRenderTask(this.engine, report, monitor);
        runAndRenderTask.setRenderOption((IRenderOption)options);
        runAndRenderTask.run();
        runAndRenderTask.close();
        return pageAreas;
    }

    public void testPagebreakPaginationOnlyFalse() throws EngineException {
        PDFPageLMTest.assertEquals((int)8, (int)this.getPages(false, false).size());
    }

    public void testPagebreakPaginationOnlyTrue() throws EngineException {
        PDFPageLMTest.assertEquals((int)4, (int)this.getPages(false, true).size());
    }

    public void testPageBreakWithPageOverflow() throws EngineException {
        PDFPageLMTest.assertEquals((int)8, (int)this.getPages(4).size());
        PDFPageLMTest.assertEquals((int)4, (int)this.getPages(8).size());
        PDFPageLMTest.assertEquals((int)4, (int)this.getPages(2).size());
    }

    public void testFitToPageFalse() throws EngineException {
        PageArea page;
        List pages = this.getPages(false, false);
        int i = 0;
        while (i < pages.size()) {
            page = (PageArea)pages.get(i);
            PDFPageLMTest.assertEquals((Object)new Float(1.0f), (Object)new Float(page.getScale()));
            ++i;
        }
        pages = this.getPages(false, true);
        i = 0;
        while (i < pages.size()) {
            page = (PageArea)pages.get(i);
            PDFPageLMTest.assertEquals((Object)new Float(1.0f), (Object)new Float(page.getScale()));
            ++i;
        }
    }

    public void testFitToPageTrue() throws EngineException {
        List pages = this.getPages(true, true);
        float[] scales = new float[]{0.75f, 0.75f, 0.75f, 0.24f};
        PDFPageLMTest.assertTrue((pages.size() == scales.length ? 1 : 0) != 0);
        int i = 0;
        while (i < pages.size()) {
            PageArea page = (PageArea)pages.get(i);
            float delta = scales[i] - page.getScale();
            PDFPageLMTest.assertTrue(((double)delta > -0.01 && (double)delta < 0.01 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testPageBreakInterval() throws EngineException {
        String designFile = "org/eclipse/birt/report/engine/layout/pdf/PageBreakIntervalTest.xml";
        List pageAreas = this.getPageAreas(designFile);
        PDFPageLMTest.assertEquals((int)3, (int)pageAreas.size());
        int[] recordNumberInEachPage = new int[]{3, 3, 1};
        int i = 0;
        while (i < recordNumberInEachPage.length) {
            TableArea table = this.getTableArea((ContainerArea)pageAreas.get(i));
            PDFPageLMTest.assertNotNull((Object)table);
            PDFPageLMTest.assertEquals((int)recordNumberInEachPage[i], (int)table.getChildrenCount());
            ++i;
        }
    }

    public void testPageBreakInterval2() throws EngineException {
        String designFile = "org/eclipse/birt/report/engine/layout/pdf/PageBreakIntervalAndGroupPageBreak.xml";
        List pageAreas = this.getPageAreas(designFile);
        PDFPageLMTest.assertEquals((int)3, (int)pageAreas.size());
    }

    private TableArea getTableArea(ContainerArea container) {
        Iterator children = container.getChildren();
        while (children.hasNext()) {
            Object child = children.next();
            if (child instanceof TableArea) {
                return (TableArea)child;
            }
            TableArea result = this.getTableArea((ContainerArea)child);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

