/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutTest;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;

public class PDFImageLMTest
extends PDFLayoutTest {
    public void testOversizedImageInGrid() throws EngineException {
        String designFile = "org/eclipse/birt/report/engine/layout/pdf/168899.xml";
        IReportRunnable report = this.openReportDesign(designFile);
        List pageAreas = this.getPageAreas(report);
        PDFImageLMTest.assertEquals((int)1, (int)pageAreas.size());
        PageArea pageArea = (PageArea)pageAreas.get(0);
        Iterator logicContainers = pageArea.getBody().getChildren();
        PDFImageLMTest.assertTrue((boolean)logicContainers.hasNext());
        ContainerArea blockContainer = (ContainerArea)logicContainers.next();
        PDFImageLMTest.assertTrue((String)"Page body is not empty", (!this.isEmpty(blockContainer) ? 1 : 0) != 0);
    }

    private void checkChartLengend(ContainerArea map, int x, int y, int width, int height, String hyperlink, String bookmark, String targetWindow) {
        IHyperlinkAction link = map.getAction();
        PDFImageLMTest.assertEquals((int)x, (int)map.getX());
        PDFImageLMTest.assertEquals((int)y, (int)map.getY());
        PDFImageLMTest.assertEquals((int)width, (int)map.getWidth());
        PDFImageLMTest.assertEquals((int)height, (int)map.getHeight());
        PDFImageLMTest.assertEquals((String)hyperlink, (String)link.getHyperlink());
        PDFImageLMTest.assertEquals((String)bookmark, (String)link.getBookmark());
        PDFImageLMTest.assertEquals((String)targetWindow, (String)link.getTargetWindow());
    }

    private ContainerArea getChartParentIn(ContainerArea blockContainer) {
        ContainerArea parent = blockContainer;
        Iterator iterator = parent.getChildren();
        while (iterator.hasNext()) {
            IArea firstChild = (IArea)iterator.next();
            if (firstChild instanceof IImageArea) {
                return parent;
            }
            parent = (ContainerArea)firstChild;
            iterator = parent.getChildren();
        }
        return null;
    }
}

