/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.emitter;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.emitter.postscript.PostscriptWriter;
import org.eclipse.birt.report.engine.layout.emitter.CellArea;
import org.eclipse.birt.report.engine.layout.emitter.TableBorderEx;

public class TableBorderPSTest
extends TestCase {
    private CellArea[] cells = new CellArea[9];
    int tableX = 10;
    int tableY = 10;
    PostscriptWriter writer;
    PrintStream out = null;
    int pageHeight = 600;
    int pageWidth = 600;

    protected void setUp() throws Exception {
        super.setUp();
        this.cells[0] = new CellArea(10, 10, 40, 40);
        this.cells[1] = new CellArea(50, 10, 40, 40);
        this.cells[2] = new CellArea(90, 10, 40, 40);
        this.cells[2].defineBorder(1, 6);
        this.cells[2].defineBorder(1, Color.orange);
        this.cells[3] = new CellArea(10, 50, 40, 80);
        this.cells[3].defineBorder(2, 6);
        this.cells[3].defineBorder(2, Color.blue);
        this.cells[4] = new CellArea(50, 50, 40, 40);
        this.cells[5] = new CellArea(90, 50, 40, 40);
        this.cells[5].defineBorder(1, 6);
        this.cells[5].defineBorder(1, Color.orange);
        this.cells[6] = null;
        this.cells[7] = new CellArea(50, 90, 40, 40);
        this.cells[7].defineBorder(2, 4);
        this.cells[7].defineBorder(2, Color.blue);
        this.cells[8] = new CellArea(90, 90, 40, 40);
        this.cells[8].defineBorder(2, 2);
        this.cells[8].defineBorder(2, Color.blue);
        this.cells[8].defineBorder(1, 6);
        this.cells[8].defineBorder(1, Color.orange);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream("TableBorderPSTest.ps"));
        this.writer = new PostscriptWriter((OutputStream)bufferedOutputStream, "title");
        this.writer.startRenderer();
        this.writer.startPage((float)this.pageWidth, (float)this.pageHeight, "portrait");
        this.testBorderDraw();
        this.writer.endPage();
        this.writer.stopRenderer();
    }

    public void testBorderDraw() {
        TableBorderEx currentTableBorder = new TableBorderEx(this.tableX, this.tableY);
        int i = 0;
        while (i < this.cells.length) {
            CellArea cell = this.cells[i];
            if (cell != null) {
                currentTableBorder.addRow(cell.y + cell.height);
                currentTableBorder.addColumn(cell.x + cell.width);
                if (cell.borders[0].borderWidth != 0) {
                    currentTableBorder.setRowBorder(cell.y, cell.x, cell.x + cell.width, cell.borders[0].borderStyle, cell.borders[0].borderWidth, cell.borders[0].borderColor);
                }
                if (cell.borders[3].borderWidth != 0) {
                    currentTableBorder.setColumnBorder(cell.x, cell.y, cell.y + cell.height, cell.borders[3].borderStyle, cell.borders[3].borderWidth, cell.borders[3].borderColor);
                }
                if (cell.borders[2].borderWidth != 0) {
                    currentTableBorder.setRowBorder(cell.y + cell.height, cell.x, cell.x + cell.width, cell.borders[2].borderStyle, cell.borders[2].borderWidth, cell.borders[2].borderColor);
                }
                if (cell.borders[1].borderWidth != 0) {
                    currentTableBorder.setColumnBorder(cell.x + cell.width, cell.y, cell.y + cell.height, cell.borders[1].borderStyle, cell.borders[1].borderWidth, cell.borders[1].borderColor);
                }
            }
            ++i;
        }
        currentTableBorder.findBreakPoints();
        this.drawBorder(currentTableBorder);
    }

    void drawBorder(TableBorderEx tb) {
        TableBorderEx.Border border = null;
        int colCount = tb.columnBorders.size();
        for (Integer pos : tb.columnBorders.keySet()) {
            if (pos == tb.tableLRX) continue;
            border = (TableBorderEx.Border)tb.columnBorders.get(pos);
            int j = 0;
            while (j < border.segments.size()) {
                TableBorderEx.BorderSegment seg = (TableBorderEx.BorderSegment)border.segments.get(j);
                TableBorderEx.Border rs = (TableBorderEx.Border)tb.rowBorders.get(seg.start);
                TableBorderEx.Border re = (TableBorderEx.Border)tb.rowBorders.get(seg.end);
                int sy = rs.position + rs.width / 2;
                int ey = re.position + re.width / 2;
                int x = border.position + seg.width / 2;
                if (border.breakPoints.contains(new Integer(seg.start))) {
                    sy = rs.position;
                }
                if (border.breakPoints.contains(new Integer(seg.end))) {
                    ey = seg.end == tb.tableLRY ? re.position : re.position + re.width;
                }
                this.drawLine(x, sy, x, ey, seg.style, seg.width, seg.color);
                ++j;
            }
        }
        border = (TableBorderEx.Border)tb.columnBorders.get(tb.tableLRX);
        int j = 0;
        while (j < border.segments.size()) {
            TableBorderEx.BorderSegment seg = (TableBorderEx.BorderSegment)border.segments.get(j);
            TableBorderEx.Border rs = (TableBorderEx.Border)tb.rowBorders.get(seg.start);
            TableBorderEx.Border re = (TableBorderEx.Border)tb.rowBorders.get(seg.end);
            int sy = rs.position + rs.width / 2;
            int ey = re.position + re.width / 2;
            int x = border.position - seg.width / 2;
            if (border.breakPoints.contains(new Integer(seg.start))) {
                sy = rs.position;
            }
            if (border.breakPoints.contains(new Integer(seg.end))) {
                ey = seg.end == tb.tableLRY ? re.position : re.position + re.width;
            }
            this.drawLine(x, sy, x, ey, seg.style, seg.width, seg.color);
            ++j;
        }
        int rowCount = tb.rowBorders.size();
        for (Integer pos : tb.rowBorders.keySet()) {
            if (pos == tb.tableLRY) continue;
            border = (TableBorderEx.Border)tb.rowBorders.get(pos);
            int j2 = 0;
            while (j2 < border.segments.size()) {
                TableBorderEx.BorderSegment seg = (TableBorderEx.BorderSegment)border.segments.get(j2);
                TableBorderEx.Border cs = (TableBorderEx.Border)tb.columnBorders.get(seg.start);
                TableBorderEx.Border ce = (TableBorderEx.Border)tb.columnBorders.get(seg.end);
                int sx = cs.position + cs.width / 2;
                int ex = ce.position + ce.width / 2;
                int y = border.position + seg.width / 2;
                if (border.breakPoints.contains(new Integer(seg.start))) {
                    sx = seg.start == tb.tableX && border.position != tb.tableY ? cs.position + cs.width : cs.position;
                }
                if (border.breakPoints.contains(new Integer(seg.end))) {
                    ex = seg.end == tb.tableLRX ? (border.position == tb.tableY ? ce.position : ce.position - ce.width) : ce.position + ce.width;
                }
                this.drawLine(sx, y, ex, y, seg.style, seg.width, seg.color);
                ++j2;
            }
        }
        border = (TableBorderEx.Border)tb.rowBorders.get(tb.tableLRY);
        int j3 = 0;
        while (j3 < border.segments.size()) {
            TableBorderEx.BorderSegment seg = (TableBorderEx.BorderSegment)border.segments.get(j3);
            TableBorderEx.Border cs = (TableBorderEx.Border)tb.columnBorders.get(seg.start);
            TableBorderEx.Border ce = (TableBorderEx.Border)tb.columnBorders.get(seg.end);
            int sx = cs.position + cs.width / 2;
            int ex = ce.position + ce.width / 2;
            int y = border.position - seg.width / 2;
            if (border.breakPoints.contains(new Integer(seg.start))) {
                sx = cs.position;
            }
            if (border.breakPoints.contains(new Integer(seg.end))) {
                ex = seg.end == tb.tableLRX ? ce.position : ce.position + ce.width;
            }
            this.drawLine(sx, y, ex, y, seg.style, seg.width, seg.color);
            ++j3;
        }
    }

    private void drawLine(float startX, float startY, float endX, float endY, int style, float width, Color color) {
        this.writer.drawLine(startX, startY, endX, endY, width, color, 21);
    }
}

