/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.ReportEngine;

public class HTMLClientInitializeTest
extends TestCase {
    public void test() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("htmlClientInitializeTest.rptdesign");
        EngineConfig config = new EngineConfig();
        ReportEngine engine = new ReportEngine(config);
        IReportRunnable report = engine.openReportDesign(in);
        String clientInitialize = (String)report.getProperty("clientInitialize");
        IRunAndRenderTask task = engine.createRunAndRenderTask(report);
        HTMLRenderOption option = new HTMLRenderOption();
        option.setOutputFormat("html");
        String htmlFileName = "test/org/eclipse/birt/report/engine/emitter/htmlClientInitializeTest.html";
        option.setOutputFileName(htmlFileName);
        task.setRenderOption((IRenderOption)option);
        task.run();
        task.close();
        engine.shutdown();
        String[] jsArray = clientInitialize.split("\\n");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(new File(htmlFileName)));
            boolean isException = true;
            String str = br.readLine().trim();
            int i = 0;
            int length = jsArray.length;
            while (str != null) {
                boolean same = jsArray[i].trim().equals(str.trim());
                if (same) {
                    if (i == length - 1) {
                        isException = false;
                        break;
                    }
                    ++i;
                }
                str = br.readLine();
            }
            HTMLClientInitializeTest.assertFalse((boolean)isException);
        }
        finally {
            in.close();
            br.close();
            File file = new File(htmlFileName);
            if (file.exists()) {
                file.delete();
            }
        }
    }
}

