/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_153220
extends BaseTestCase {
    private static final String INPUT = "Regression_153220.xml";
    private static final String LIBRARY_A = "Regression_153220_lib1.xml";
    private static final String LIBRARY_B = "Regression_153220_lib2.xml";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/Regression_153220.xml");
        this.copyInputToFile("input/Regression_153220_lib1.xml");
        this.copyInputToFile("input/Regression_153220_lib2.xml");
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void test_Regression_153220() throws IOException, DesignFileException, SemanticException {
        String report = this.getTempFolder() + "/input/Regression_153220.xml";
        String libA = this.getTempFolder() + "/input/Regression_153220_lib1.xml";
        String libB = this.getTempFolder() + "/input/Regression_153220_lib2.xml";
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        this.designHandle = this.sessionHandle.openDesign(report);
        this.designHandle.includeLibrary(LIBRARY_B, "lib2");
        this.libraryHandle = this.designHandle.getLibrary("lib2");
        TableHandle table = (TableHandle)this.libraryHandle.findElement("table2");
        Regression_153220.assertNotNull((Object)table);
        ElementFactory factory = this.designHandle.getElementFactory();
        TableHandle rtable = (TableHandle)factory.newElementFrom((DesignElementHandle)table, "Rtable");
        this.designHandle.getBody().add((DesignElementHandle)rtable);
        this.designHandle.saveAs(this.getTempFolder() + "/input/Regression_153220.xml");
        this.libraryHandle = this.sessionHandle.openLibrary(libA);
        TableHandle table1 = (TableHandle)this.libraryHandle.findElement("table1");
        table1.drop();
        this.libraryHandle.saveAs(this.getTempFolder() + "/input/Regression_153220_lib1.xml");
        this.designHandle.reloadLibrary(this.libraryHandle);
        Regression_153220.assertFalse((boolean)rtable.isValidReferenceForCompoundElement());
    }
}

