/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_121352
extends BaseTestCase {
    private String filename = "Regression_121352.xml";
    private String outfile = "Regression_121352_out.xml";
    private String goldenfile = "Regression_121352_golden.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.copyInputToFile("input/" + this.filename);
        this.copyGoldenToFile("golden/" + this.goldenfile);
    }

    public void test_regression_121352() throws Exception {
        this.openDesign(this.filename);
        List bindingList = this.designHandle.getListProperty("propertyBindings");
        Regression_121352.assertEquals((int)2, (int)bindingList.size());
        PropertyBinding binding = (PropertyBinding)bindingList.get(0);
        Regression_121352.assertEquals((String)"text", (String)binding.getName());
        Regression_121352.assertEquals((long)23L, (long)binding.getID().longValue());
        Regression_121352.assertEquals((String)"params[p1]", (String)binding.getValue());
        binding = (PropertyBinding)bindingList.get(1);
        Regression_121352.assertEquals((String)"column", (String)binding.getName());
        Regression_121352.assertEquals((long)22L, (long)binding.getID().longValue());
        Regression_121352.assertEquals((String)"params[p2]", (String)binding.getValue());
        DesignElementHandle tempHandle = this.designHandle.getElementByID(23L);
        Regression_121352.assertNotNull((Object)tempHandle);
        Regression_121352.assertTrue((boolean)(tempHandle instanceof LabelHandle));
        Regression_121352.assertNotNull((Object)tempHandle.getPropertyDefn("text"));
        Regression_121352.assertEquals((String)"params[p1]", (String)tempHandle.getPropertyBinding("text"));
        Regression_121352.assertEquals(bindingList.get(0), (Object)this.designHandle.getModule().findPropertyBinding(tempHandle.getElement(), "text"));
        tempHandle = this.designHandle.getElementByID(22L);
        Regression_121352.assertNotNull((Object)tempHandle);
        Regression_121352.assertTrue((boolean)(tempHandle instanceof CellHandle));
        Regression_121352.assertNotNull((Object)tempHandle.getPropertyDefn("column"));
        Regression_121352.assertEquals((String)"params[p2]", (String)tempHandle.getPropertyBinding("column"));
        Regression_121352.assertEquals(bindingList.get(1), (Object)this.designHandle.getModule().findPropertyBinding(tempHandle.getElement(), "column"));
        ReportDesign copy = (ReportDesign)this.designHandle.copy();
        Regression_121352.assertNotNull((Object)copy);
        ReportDesignHandle copyHandle = copy.handle();
        Regression_121352.assertNotNull((Object)copyHandle);
        String TempFile = this.genOutputFile(this.outfile);
        System.out.println(TempFile);
        this.designHandle.saveAs(TempFile);
        Regression_121352.assertTrue((boolean)this.compareTextFile(this.goldenfile, this.outfile));
    }
}

