/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExpressionPropertyType;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_117978
extends BaseTestCase {
    private static final String OUTPUT = "regression_117978.out";

    public void test_regression_117978() throws IOException, DesignFileException, SemanticException {
        DesignEngine engine = new DesignEngine(new DesignConfig());
        SessionHandle session = engine.newSessionHandle(ULocale.ENGLISH);
        ReportDesignHandle designHandle = session.createDesign();
        ElementFactory factory = designHandle.getElementFactory();
        LabelHandle label = factory.newLabel("label");
        designHandle.getBody().add((DesignElementHandle)label);
        UserPropertyDefn expr2 = new UserPropertyDefn();
        expr2.setName("Assignee");
        expr2.setType((PropertyType)new ExpressionPropertyType());
        expr2.setDefault((Object)"Anonymous");
        label.addUserPropertyDefn(expr2);
        label.setStringProperty("Assignee", "testValue");
        String TempFile = this.genOutputFile(OUTPUT);
        designHandle.saveAs(TempFile);
        designHandle = session.openDesign(TempFile);
        LabelHandle labelHandle = (LabelHandle)designHandle.findElement("label");
        Regression_117978.assertNotNull((Object)labelHandle);
        List userProperties = labelHandle.getUserProperties();
        Regression_117978.assertEquals((int)1, (int)userProperties.size());
        UserPropertyDefn prop = (UserPropertyDefn)userProperties.get(0);
        Regression_117978.assertEquals((String)"Assignee", (String)prop.getName());
        Regression_117978.assertEquals((String)"Anonymous", (String)prop.getDefault().toString());
        Regression_117978.assertEquals((String)"testValue", (String)labelHandle.getStringProperty("Assignee"));
    }
}

