/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class OpenDesignTest
extends BaseTestCase {
    String fileName = "BlankReport.xml";
    private String nofileName = "NoExisting.xml";
    String noexistingFileName = this.getTempFolder() + "/input/" + this.nofileName;

    public OpenDesignTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(OpenDesignTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + this.fileName);
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void testOpendesign1() throws Exception {
        this.openDesign(this.fileName);
        File file = new File(this.getTempFolder() + "/input/" + this.fileName);
        FileInputStream is = new FileInputStream(file);
        OpenDesignTest.assertTrue((is != null ? 1 : 0) != 0);
        String s1 = this.getTempFolder() + "/input/" + this.fileName;
        this.sessionHandle.openDesign(s1, (InputStream)is);
    }

    public void testOpendesign2() throws Exception {
        this.openDesign(this.fileName);
        File file = new File(this.getTempFolder() + "/input/" + this.fileName);
        FileInputStream is = new FileInputStream(file);
        OpenDesignTest.assertTrue((is != null ? 1 : 0) != 0);
        String s2 = "BlankReport.xml";
        this.openDesign(s2, is);
    }

    public void testOpendesign3() throws Exception {
        this.openDesign(this.fileName);
        File file = new File(this.getTempFolder() + "/input/" + this.fileName);
        FileInputStream is = new FileInputStream(file);
        OpenDesignTest.assertTrue((is != null ? 1 : 0) != 0);
        String s3 = this.getTempFolder() + "/input/" + this.fileName;
        this.openDesign(s3, is);
    }

    public void testOpendesign4() throws Exception {
        this.openDesign(this.fileName);
        File file = new File(this.getTempFolder() + "/input/" + this.fileName);
        FileInputStream is = new FileInputStream(file);
        OpenDesignTest.assertTrue((is != null ? 1 : 0) != 0);
        String s4 = this.getTempFolder() + "/input/" + this.noexistingFileName;
        try {
            this.openDesign(s4, is);
        }
        catch (DesignFileException e) {
            OpenDesignTest.assertEquals((String)"Error.DesignFileException.INVALID_XML", (String)e.getErrorCode());
        }
    }

    public void testOpendesign5() throws Exception {
        this.openDesign(this.fileName);
        File file = new File(this.getTempFolder() + "/input/" + this.fileName);
        FileInputStream is = new FileInputStream(file);
        OpenDesignTest.assertTrue((is != null ? 1 : 0) != 0);
        String s5 = "noput";
        try {
            this.openDesign(s5, is);
        }
        catch (DesignFileException e) {
            OpenDesignTest.assertEquals((String)"Error.DesignFileException.INVALID_XML", (String)e.getErrorCode());
        }
    }

    public void testOpendesign6() throws Exception {
        this.openDesign(this.fileName);
        File file = new File(this.getTempFolder() + "/input/" + this.fileName);
        FileInputStream is = new FileInputStream(file);
        OpenDesignTest.assertTrue((is != null ? 1 : 0) != 0);
        String s6 = "file:///" + this.getTempFolder() + "/input/" + this.noexistingFileName;
        try {
            this.openDesign(s6, is);
        }
        catch (DesignFileException e) {
            OpenDesignTest.assertEquals((String)"Error.DesignFileException.INVALID_XML", (String)e.getErrorCode());
        }
    }

    public void testOpendesign7() throws Exception {
        this.openDesign(this.fileName);
        File file = new File(this.getTempFolder() + "/input/" + this.fileName);
        FileInputStream is = new FileInputStream(file);
        OpenDesignTest.assertTrue((is != null ? 1 : 0) != 0);
        String s7 = this.getTempFolder() + "/input";
        this.openDesign(s7, is);
    }

    public void testOpendesign8() throws Exception {
        this.openDesign(this.fileName);
        File file = new File(this.getTempFolder() + "/input/" + this.fileName);
        FileInputStream is = new FileInputStream(file);
        OpenDesignTest.assertTrue((is != null ? 1 : 0) != 0);
        String s8 = "file:///" + this.getTempFolder() + "/input/input";
        this.openDesign(s8, is);
    }

    public void testOpendesign9() throws Exception {
        this.openDesign(this.fileName);
        File file = new File(this.getTempFolder() + "/input/" + this.fileName);
        FileInputStream is = new FileInputStream(file);
        OpenDesignTest.assertTrue((is != null ? 1 : 0) != 0);
        String s9 = "input";
        this.openDesign(s9, is);
    }
}

