/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.validators.CellOverlappingValidator;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.validators.ValidatorTestCase;

public class CellOverlappingValidatorTest
extends ValidatorTestCase {
    ValidatorTestCase.MyListener listener = new ValidatorTestCase.MyListener(this);

    public void testCellOverlappingValidator() throws Exception {
        this.createDesign();
        MetaDataDictionary.getInstance().setUseValidationTrigger(true);
        GridHandle gridHandle = this.designHandle.getElementFactory().newGridItem("grid1");
        this.designHandle.getBody().add((DesignElementHandle)gridHandle);
        RowHandle rowHandle1 = gridHandle.getElementFactory().newTableRow(2);
        this.designHandle.addValidationListener((IValidationListener)this.listener);
        gridHandle.getRows().add((DesignElementHandle)rowHandle1);
        CellOverlappingValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)rowHandle1, CellOverlappingValidator.getInstance().getName(), "Error.SemanticError.OVERLAPPING_CELLS"));
        CellHandle cellHandle1 = (CellHandle)rowHandle1.getCells().get(0);
        CellHandle cellHandle2 = (CellHandle)rowHandle1.getCells().get(1);
        cellHandle1.setColumn(1);
        CellOverlappingValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)rowHandle1, CellOverlappingValidator.getInstance().getName(), "Error.SemanticError.OVERLAPPING_CELLS"));
        cellHandle1.setColumnSpan(2);
        CellOverlappingValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)rowHandle1, CellOverlappingValidator.getInstance().getName(), "Error.SemanticError.OVERLAPPING_CELLS"));
        cellHandle2.setColumn(2);
        CellOverlappingValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)rowHandle1, CellOverlappingValidator.getInstance().getName(), "Error.SemanticError.OVERLAPPING_CELLS"));
        cellHandle2.setColumnSpan(2);
        CellOverlappingValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)rowHandle1, CellOverlappingValidator.getInstance().getName(), "Error.SemanticError.OVERLAPPING_CELLS"));
    }
}

