/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.RectangleHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.parser.ParserTestCase;

public class RectangleItemParseTest
extends ParserTestCase {
    String fileName = "RectangleItemParseTest.xml";
    String outFileName = "RectangleItemParseTest_out.xml";
    String goldenFileName = "RectangleItemParseTest_golden.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws Exception {
        this.openDesign(this.fileName);
        GraphicMasterPageHandle masterPage = (GraphicMasterPageHandle)this.designHandle.getMasterPages().get(0);
        RectangleHandle rectangle = (RectangleHandle)masterPage.getContent().get(0);
        SharedStyleHandle style = this.designHandle.findStyle("My-Style");
        RectangleItemParseTest.assertNotNull((Object)rectangle);
        RectangleItemParseTest.assertEquals((String)"12mm", (String)rectangle.getX().getStringValue());
        RectangleItemParseTest.assertEquals((String)"39mm", (String)rectangle.getY().getStringValue());
        RectangleItemParseTest.assertEquals((String)"100mm", (String)rectangle.getWidth().getStringValue());
        RectangleItemParseTest.assertEquals((String)"20mm", (String)rectangle.getHeight().getStringValue());
        RectangleItemParseTest.assertEquals((String)style.getStringProperty("backgroundColor"), (String)rectangle.getStringProperty("backgroundColor"));
        RectangleItemParseTest.assertEquals((String)"white", (String)rectangle.getStringProperty("borderTopColor"));
        RectangleItemParseTest.assertEquals((String)"white", (String)rectangle.getStringProperty("borderLeftColor"));
        RectangleItemParseTest.assertEquals((String)"white", (String)rectangle.getStringProperty("borderRightColor"));
        RectangleItemParseTest.assertEquals((String)"white", (String)rectangle.getStringProperty("borderBottomColor"));
    }

    public void testWriter() throws Exception {
        RectangleItemParseTest.assertTrue((boolean)this.openWriteAndCompare(this.fileName, this.outFileName, this.goldenFileName));
    }
}

