/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.parser.ParserTestCase;

public class FreeFormParseTest
extends ParserTestCase {
    String fileName = "FreeFormParseTest.xml";
    String outFileName = "FreeFormParseTest_out.xml";
    String goldenFileName = "FreeFormParseTest_golden.xml";
    String semanticCheckFileName = "FreeFormParseTest_1.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws Exception {
        FreeFormHandle freeFormHandle = this.getFreeForm();
        FreeFormParseTest.assertEquals((String)"Sample Section", (String)freeFormHandle.getStringProperty("comments"));
        FreeFormParseTest.assertEquals((String)"The Section", (String)freeFormHandle.getStringProperty("displayName"));
        SlotHandle reportItem = freeFormHandle.getSlot(0);
        FreeFormParseTest.assertNotNull((Object)reportItem);
        FreeFormParseTest.assertEquals((int)3, (int)reportItem.getCount());
        Iterator it = reportItem.iterator();
        Object label = it.next();
        FreeFormParseTest.assertTrue((boolean)(label instanceof LabelHandle));
        Object freeForm1 = it.next();
        FreeFormParseTest.assertTrue((boolean)(freeForm1 instanceof FreeFormHandle));
        Object freeForm2 = it.next();
        FreeFormParseTest.assertTrue((boolean)(freeForm2 instanceof FreeFormHandle));
        FreeFormParseTest.assertEquals((String)"Inner freeform", (String)((FreeFormHandle)freeForm1).getStringProperty("comments"));
        FreeFormParseTest.assertEquals((int)2, (int)((FreeFormHandle)freeForm1).getSlot(0).getCount());
        FreeFormHandle level3FreeForm = (FreeFormHandle)((FreeFormHandle)freeForm1).getSlot(0).get(1);
        FreeFormParseTest.assertNotNull((Object)level3FreeForm);
        FreeFormParseTest.assertEquals((String)"level3FreeForm", (String)level3FreeForm.getName());
    }

    public void testWritter() throws Exception {
        FreeFormHandle freeFormHandle = this.getFreeForm();
        freeFormHandle.setStringProperty("comments", "new comment");
        FreeFormParseTest.assertEquals((String)"new comment", (String)freeFormHandle.getStringProperty("comments"));
        freeFormHandle.setProperty("style", null);
        SlotHandle reportItem = freeFormHandle.getSlot(0);
        FreeFormHandle freeForm1 = (FreeFormHandle)reportItem.get(1);
        SlotHandle innerReportItem = freeForm1.getSlot(0);
        freeForm1.setExtendsElement(null);
        innerReportItem.dropAndClear(0);
        FreeFormHandle freeForm2 = (FreeFormHandle)reportItem.get(2);
        reportItem.dropAndClear(2);
        innerReportItem.add((DesignElementHandle)freeForm2);
        this.save();
        FreeFormParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testSemanticCheck() {
        try {
            this.openDesign(this.semanticCheckFileName);
        }
        catch (DesignFileException e) {
            FreeFormParseTest.assertEquals((int)2, (int)e.getErrorList().size());
            int i = 0;
            FreeFormParseTest.assertEquals((String)"Error.NameException.DUPLICATE", (String)((ErrorDetail)e.getErrorList().get(i++)).getErrorCode());
            FreeFormParseTest.assertEquals((String)"Error.XMLParserException.UNKNOWN_TAG", (String)((ErrorDetail)e.getErrorList().get(i++)).getErrorCode());
        }
    }

    private FreeFormHandle getFreeForm() throws Exception {
        this.openDesign(this.fileName);
        FreeFormParseTest.assertEquals((int)0, (int)this.design.getErrorList().size());
        SlotHandle body = this.designHandle.getBody();
        Iterator it = body.iterator();
        Object freeFormHandle = it.next();
        FreeFormParseTest.assertTrue((boolean)(freeFormHandle instanceof FreeFormHandle));
        return (FreeFormHandle)freeFormHandle;
    }
}

