/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.List;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.SingleElementSlot;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class SingleElementSlotTest
extends BaseTestCase {
    SingleElementSlot slot = null;
    Label label = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.slot = new SingleElementSlot();
        this.label = new Label();
    }

    public void testFindPosn() {
        this.slot.insert((DesignElement)this.label, 0);
        SingleElementSlotTest.assertEquals((int)0, (int)this.slot.findPosn((DesignElement)this.label));
        Label label1 = new Label();
        SingleElementSlotTest.assertEquals((int)-1, (int)this.slot.findPosn((DesignElement)label1));
    }

    public void testInsertRemove() {
        SingleElementSlotTest.assertEquals((int)0, (int)this.slot.getCount());
        SingleElementSlotTest.assertFalse((boolean)this.slot.contains((DesignElement)this.label));
        this.slot.insert((DesignElement)this.label, 0);
        SingleElementSlotTest.assertEquals((int)1, (int)this.slot.getCount());
        SingleElementSlotTest.assertTrue((boolean)this.slot.contains((DesignElement)this.label));
        this.slot.remove((DesignElement)this.label);
        SingleElementSlotTest.assertFalse((boolean)this.slot.contains((DesignElement)this.label));
        SingleElementSlotTest.assertEquals((int)0, (int)this.slot.getCount());
    }

    public void testCanDrop() {
        this.slot.insert((DesignElement)this.label, 0);
        SingleElementSlotTest.assertTrue((boolean)this.slot.canDrop((DesignElement)this.label));
    }

    public void testGetContents() {
        List list = this.slot.getContents();
        SingleElementSlotTest.assertTrue((boolean)list.isEmpty());
        this.slot.insert((DesignElement)this.label, 0);
        list = this.slot.getContents();
        SingleElementSlotTest.assertTrue((boolean)list.contains(this.label));
        DesignElement o = this.slot.getContent(0);
        SingleElementSlotTest.assertEquals((Object)this.label, (Object)o);
    }
}

