/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.IncludedLibraryHandle;
import org.eclipse.birt.report.model.api.ModelException;
import org.eclipse.birt.report.model.api.PropertyHandleImpl;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StructureIteratorTest
extends BaseTestCase {
    private SimpleValueHandle createSimpleValueHandle(int numOfItem) throws ModelException {
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        ReportDesignHandle rdh = this.sessionHandle.createDesign();
        PropertyHandleImpl svh = new PropertyHandleImpl((DesignElementHandle)rdh, "libraries");
        int i = 0;
        while (i < numOfItem) {
            IncludedLibrary inc = new IncludedLibrary();
            inc.setFileName("filename" + i);
            inc.setNamespace("lib" + i);
            svh.addItem((IStructure)inc);
            ++i;
        }
        return svh;
    }

    public void testZeroItem() throws ModelException {
        SimpleValueHandle svh = this.createSimpleValueHandle(0);
        Iterator si = svh.iterator();
        StructureIteratorTest.assertFalse((boolean)si.hasNext());
    }

    public void testOneItem() throws ModelException {
        SimpleValueHandle svh = this.createSimpleValueHandle(1);
        Iterator si = svh.iterator();
        StructureIteratorTest.assertTrue((boolean)si.hasNext());
        si.next();
        si.remove();
        si = svh.iterator();
        StructureIteratorTest.assertFalse((boolean)si.hasNext());
    }

    public void testRemoveFirstFromMultipleItem() throws ModelException {
        int itemNum = 5;
        SimpleValueHandle svh = this.createSimpleValueHandle(itemNum);
        Iterator si = svh.iterator();
        si.next();
        si.remove();
        --itemNum;
        IncludedLibrary inc = (IncludedLibrary)((IncludedLibraryHandle)si.next()).getStructure();
        StructureIteratorTest.assertTrue((boolean)inc.getFileName().equals("filename1"));
        int count = 0;
        si = svh.iterator();
        while (si.hasNext()) {
            ++count;
            inc = (IncludedLibrary)((IncludedLibraryHandle)si.next()).getStructure();
            StructureIteratorTest.assertFalse((boolean)inc.getFileName().equals("filename0"));
        }
        StructureIteratorTest.assertEquals((int)count, (int)itemNum);
    }

    public void testRemoveLastFromMultipleItem() throws ModelException {
        int itemNum = 5;
        SimpleValueHandle svh = this.createSimpleValueHandle(itemNum);
        Iterator si = svh.iterator();
        while (si.hasNext()) {
            si.next();
        }
        si.remove();
        --itemNum;
        int count = 0;
        si = svh.iterator();
        while (si.hasNext()) {
            ++count;
            IncludedLibrary inc = (IncludedLibrary)((IncludedLibraryHandle)si.next()).getStructure();
            StructureIteratorTest.assertFalse((boolean)inc.getFileName().equals("filename4"));
        }
        StructureIteratorTest.assertEquals((int)count, (int)itemNum);
    }

    public void testRemoveMidFromMultipleItem() throws ModelException {
        int itemNum = 5;
        SimpleValueHandle svh = this.createSimpleValueHandle(itemNum);
        Iterator si = svh.iterator();
        si.next();
        si.next();
        si.next();
        si.remove();
        --itemNum;
        IncludedLibrary inc = (IncludedLibrary)((IncludedLibraryHandle)si.next()).getStructure();
        StructureIteratorTest.assertTrue((boolean)inc.getFileName().equals("filename3"));
        int count = 0;
        si = svh.iterator();
        while (si.hasNext()) {
            ++count;
            inc = (IncludedLibrary)((IncludedLibraryHandle)si.next()).getStructure();
            StructureIteratorTest.assertFalse((boolean)inc.getFileName().equals("filename2"));
        }
        StructureIteratorTest.assertEquals((int)count, (int)itemNum);
    }
}

