/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class HighlightRuleHandleTest
extends BaseTestCase {
    private static final String inputFile = "HighlightRuleHandleTest.xml";

    public void testStyle() throws Exception {
        this.openDesign(inputFile);
        SharedStyleHandle style2 = this.designHandle.findStyle("My-Style2");
        SharedStyleHandle style3 = this.designHandle.findStyle("My-Style3");
        SharedStyleHandle style4 = this.designHandle.findStyle("My-Style4");
        Iterator highlightRules = style2.highlightRulesIterator();
        assert (highlightRules.hasNext());
        HighlightRuleHandle style2Highlight = (HighlightRuleHandle)highlightRules.next();
        HighlightRuleHandleTest.assertEquals((String)"right", (String)style2Highlight.getTextAlign());
        HighlightRuleHandleTest.assertEquals((String)"red", (String)style2Highlight.getColor().getStringValue());
        HighlightRuleHandleTest.assertNull((Object)style2Highlight.getProperty("highlightRules"));
        HighlightRuleHandleTest.assertNull((Object)style2Highlight.getProperty("value2"));
        SharedStyleHandle style1 = this.designHandle.findStyle("My-Style1");
        List refs = ((ReferenceableElement)style1.getElement()).getClientList();
        HighlightRuleHandleTest.assertEquals((int)1, (int)refs.size());
        BackRef ref1 = (BackRef)refs.get(0);
        HighlightRuleHandleTest.assertEquals((String)"My-Style2", (String)ref1.getElement().getName());
        HighlightRuleHandleTest.assertEquals((String)"style", (String)ref1.getPropertyName());
        style2Highlight.drop();
        refs = ((ReferenceableElement)style1.getElement()).getClientList();
        HighlightRuleHandleTest.assertEquals((int)0, (int)refs.size());
        this.designHandle.getCommandStack().undo();
        refs = ((ReferenceableElement)style1.getElement()).getClientList();
        HighlightRuleHandleTest.assertEquals((int)1, (int)refs.size());
        this.designHandle.getCommandStack().redo();
        refs = ((ReferenceableElement)style1.getElement()).getClientList();
        HighlightRuleHandleTest.assertEquals((int)0, (int)refs.size());
        this.designHandle.getCommandStack().undo();
        style2Highlight.setStyle((StyleHandle)style3);
        HighlightRuleHandleTest.assertEquals((Object)style3, (Object)style2Highlight.getStyle());
        refs = ((ReferenceableElement)style1.getElement()).getClientList();
        HighlightRuleHandleTest.assertEquals((int)0, (int)refs.size());
        refs = ((ReferenceableElement)style3.getElement()).getClientList();
        HighlightRuleHandleTest.assertEquals((int)1, (int)refs.size());
        HighlightRuleHandleTest.assertEquals((String)"My-Style2", (String)ref1.getElement().getName());
        HighlightRuleHandleTest.assertEquals((String)"style", (String)ref1.getPropertyName());
        style2Highlight.setStyle(null);
        HighlightRuleHandleTest.assertNull((Object)style2Highlight.getStyle());
        HighlightRuleHandleTest.assertNull((Object)style2Highlight.getProperty("style"));
        try {
            style2Highlight.setStyle((StyleHandle)style2);
            HighlightRuleHandleTest.fail();
        }
        catch (SemanticException e) {
            HighlightRuleHandleTest.assertEquals((String)"Error.SemanticError.CIRCULAR_ELEMENT_REFERNECE", (String)e.getErrorCode());
        }
        style2Highlight.setStyle((StyleHandle)style3);
        Iterator style3HighlightRules = style3.highlightRulesIterator();
        HighlightRuleHandleTest.assertTrue((boolean)style3HighlightRules.hasNext());
        HighlightRuleHandle style3Highlight = (HighlightRuleHandle)style3HighlightRules.next();
        Iterator style4HighlightRules = style4.highlightRulesIterator();
        HighlightRuleHandleTest.assertTrue((boolean)style4HighlightRules.hasNext());
        HighlightRuleHandle style4Highlight = (HighlightRuleHandle)style4HighlightRules.next();
        DimensionValue dv = (DimensionValue)style4Highlight.getLineHeight().getValue();
        HighlightRuleHandleTest.assertEquals((Object)10.0, (Object)dv.getMeasure());
        HighlightRuleHandleTest.assertEquals((String)"in", (String)dv.getUnits());
        try {
            style3Highlight.setStyleName("My-Style2");
            HighlightRuleHandleTest.fail();
        }
        catch (SemanticException e) {
            HighlightRuleHandleTest.assertEquals((String)"Error.SemanticError.CIRCULAR_ELEMENT_REFERNECE", (String)e.getErrorCode());
        }
        HighlightRule newRule1 = StructureFactory.createHighlightRule();
        newRule1.setProperty("style", (Object)"My-Style2");
        try {
            style3.getPropertyHandle("highlightRules").addItem((IStructure)newRule1);
            HighlightRuleHandleTest.fail();
        }
        catch (SemanticException e) {
            HighlightRuleHandleTest.assertEquals((String)"Error.SemanticError.CIRCULAR_ELEMENT_REFERNECE", (String)e.getErrorCode());
        }
    }

    public void testStyleOnHighlightRuleStruct() throws Exception {
        this.openDesign(inputFile);
        SharedStyleHandle style2 = this.designHandle.findStyle("My-Style2");
        TableHandle table = (TableHandle)this.designHandle.findElement("myTable");
        HighlightRule rule = StructureFactory.createHighlightRule();
        rule.setStyle((StyleHandle)style2);
        HighlightRuleHandleTest.assertEquals((Object)"bolder", (Object)rule.getProperty((Module)this.design, "fontWeight"));
        PropertyHandle propHandle = table.getPropertyHandle("highlightRules");
        propHandle.addItem((IStructure)rule);
        HighlightRuleHandleTest.assertEquals((Object)"bolder", (Object)rule.getProperty((Module)this.design, "fontWeight"));
        this.designHandle.getCommandStack().undo();
        propHandle = style2.getPropertyHandle("highlightRules");
        try {
            propHandle.addItem((IStructure)rule);
            HighlightRuleHandleTest.fail();
        }
        catch (SemanticException e) {
            HighlightRuleHandleTest.assertEquals((String)"Error.SemanticError.CIRCULAR_ELEMENT_REFERNECE", (String)e.getErrorCode());
        }
        SharedStyleHandle newStyle = this.designHandle.getElementFactory().newStyle("newStyle");
        newStyle.getColor().setValue((Object)"red");
        HighlightRule rule1 = StructureFactory.createHighlightRule();
        rule1.setStyle((StyleHandle)newStyle);
        HighlightRuleHandleTest.assertEquals((Object)"red", (Object)rule1.getProperty((Module)this.design, "color"));
        HighlightRuleHandleTest.assertNotNull((Object)rule1.getStyle());
        propHandle = table.getPropertyHandle("highlightRules");
        propHandle.addItem((IStructure)rule1);
        HighlightRuleHandleTest.assertNull((Object)rule1.getProperty((Module)this.design, "color"));
        HighlightRuleHandleTest.assertNull((Object)rule1.getStyle());
    }

    public void testOperatorIn() throws Exception {
        this.createDesign();
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("style");
        this.designHandle.getStyles().add((DesignElementHandle)style);
        PropertyHandle propHandle = style.getPropertyHandle("highlightRules");
        HighlightRule rule = StructureFactory.createHighlightRule();
        propHandle.addItem((IStructure)rule);
        HighlightRuleHandle ruleHandle = (HighlightRuleHandle)propHandle.get(0);
        ruleHandle.setOperator("in");
        ArrayList<String> values = new ArrayList<String>();
        values.add("a");
        values.add("b");
        ruleHandle.setValue1(values);
        ruleHandle.setTestExpression("expr");
        HighlightRule rule2 = StructureFactory.createHighlightRule();
        rule2.setProperty("value1", (Object)"C");
        ArrayList<String> values2 = new ArrayList<String>();
        values2.add("a");
        values2.add("b");
        rule2.setValue1(values);
        rule2.setTestExpression("expr2");
        rule2.setOperator("in");
        propHandle.addItem((IStructure)rule2);
    }

    public void testCopyTo() throws Exception {
        this.openDesign(inputFile);
        SharedStyleHandle style2 = this.designHandle.findStyle("My-Style2");
        SharedStyleHandle newStyle = this.designHandle.getElementFactory().newStyle(null);
        this.designHandle.getStyles().add((DesignElementHandle)newStyle);
        style2.copyPropertyTo("highlightRules", (DesignElementHandle)newStyle);
        HighlightRuleHandleTest.assertNotNull((Object)newStyle.getProperty("highlightRules"));
    }
}

