/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.FontHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.PrivateStyleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.PropertyIterator;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DesignElementHandleTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("DesignElementHandleTest.xml");
    }

    public void testFindContentSlot() throws Exception {
        GraphicMasterPageHandle mHandle = (GraphicMasterPageHandle)this.designHandle.findMasterPage("My Page");
        DesignElementHandle dHandle = this.designHandle.findElement("label1");
        DesignElementHandleTest.assertTrue((-1 == this.designHandle.findContentSlot(dHandle) ? 1 : 0) != 0);
        DesignElementHandleTest.assertTrue((mHandle.findContentSlot(dHandle) == 0 ? 1 : 0) != 0);
        SlotHandle sHandle = mHandle.getContent();
        DesignElementHandle textHandle = this.designHandle.findElement("text1");
        DesignElementHandleTest.assertTrue((textHandle.getElement().getContainer() == mHandle.getElement() ? 1 : 0) != 0);
        sHandle.move(textHandle, (DesignElementHandle)this.designHandle, 6);
        DesignElementHandleTest.assertTrue((textHandle.getElement().getContainer() == this.design ? 1 : 0) != 0);
        textHandle = this.designHandle.findElement("text2");
        DesignElementHandle tableHandle = this.designHandle.findElement("table1");
        SlotHandle detailSlotOfTable = tableHandle.getSlot(2);
        RowHandle rowHandle = (RowHandle)detailSlotOfTable.get(0);
        SlotHandle cellsHandle = rowHandle.getCells();
        CellHandle cellHandle = (CellHandle)cellsHandle.get(0);
        DesignElementHandleTest.assertTrue((textHandle.getElement().getContainer() == cellHandle.getElement() ? 1 : 0) != 0);
        cellHandle.getContent().move(textHandle, (DesignElementHandle)this.designHandle, 6);
        DesignElementHandleTest.assertTrue((textHandle.getElement().getContainer() == this.design ? 1 : 0) != 0);
    }

    public void testGetContainerSlot() throws Exception {
        DesignElementHandle eHandle = this.designHandle.findElement("label1");
        SlotHandle slotHandle = eHandle.getContainerSlotHandle();
        DesignElementHandleTest.assertNotNull((Object)slotHandle);
        DesignElementHandleTest.assertEquals((Object)slotHandle.getElement(), (Object)this.designHandle.findMasterPage("My Page"));
        DesignElementHandleTest.assertEquals((int)0, (int)slotHandle.getSlotID());
        eHandle = this.designHandle.findElement("text2");
        slotHandle = eHandle.getContainerSlotHandle();
        DesignElementHandleTest.assertTrue((boolean)(slotHandle.getElement() instanceof Cell));
        slotHandle = this.designHandle.getContainerSlotHandle();
        DesignElementHandleTest.assertNull((Object)slotHandle);
    }

    public void testStyle() throws Exception {
        DesignElementHandle handle = this.designHandle.findElement("bodyLabel1");
        SharedStyleHandle styleHandle = handle.getStyle();
        DesignElementHandleTest.assertNotNull((Object)styleHandle);
        PrivateStyleHandle privateStyleHandle = (PrivateStyleHandle)handle.getPrivateStyle();
        DesignElementHandleTest.assertNotNull((Object)privateStyleHandle);
        DesignElementHandleTest.assertEquals((String)"bodyLabel1", (String)privateStyleHandle.getName());
        DesignElementHandleTest.assertEquals((String)"Style1", (String)styleHandle.getName());
        handle = this.designHandle.findElement("bodyLabel2");
        styleHandle = handle.getStyle();
        DesignElementHandleTest.assertNull((Object)styleHandle);
        privateStyleHandle = (PrivateStyleHandle)handle.getPrivateStyle();
        DesignElementHandleTest.assertNotNull((Object)privateStyleHandle);
        DesignElementHandleTest.assertEquals((String)"bodyLabel2", (String)privateStyleHandle.getName());
        handle = this.designHandle.findElement("bodyLabel3");
        styleHandle = handle.getStyle();
        DesignElementHandleTest.assertNull((Object)styleHandle);
        privateStyleHandle = (PrivateStyleHandle)handle.getPrivateStyle();
        DesignElementHandleTest.assertNotNull((Object)privateStyleHandle);
        DesignElementHandleTest.assertEquals((String)"bodyLabel3", (String)privateStyleHandle.getName());
        styleHandle = this.designHandle.findStyle("Style1");
        handle.setStyleName(styleHandle.getName());
        DesignElementHandleTest.assertNotNull((Object)handle.getStyle());
        handle.setStyle(null);
        DesignElementHandleTest.assertNull((Object)handle.getStyle());
        styleHandle = this.designHandle.findStyle("My-Style");
        handle.setStyle(styleHandle);
        DesignElementHandleTest.assertNotNull((Object)handle.getStyle());
        DesignElementHandleTest.assertEquals((String)"My-Style", (String)handle.getStyle().getName());
        handle.setStyleElement(null);
        DesignElementHandleTest.assertNull((Object)handle.getStyle());
        styleHandle = this.designHandle.findStyle("Style1");
        handle.setStyle(styleHandle);
        DesignElementHandleTest.assertNotNull((Object)handle.getStyle());
        DesignElementHandleTest.assertEquals((String)"Style1", (String)handle.getStyle().getName());
        handle.setStyleElement(null);
        DesignElementHandleTest.assertNull((Object)handle.getStyle());
        try {
            handle.setStyleElement((StyleElement)new Style("unknownStyle"));
            DesignElementHandleTest.fail();
        }
        catch (StyleException e) {
            DesignElementHandleTest.assertEquals((String)"Error.StyleException.NOT_FOUND", (String)e.getErrorCode());
        }
        handle.setName("newLabel");
        DesignElementHandleTest.assertEquals((String)"newLabel", (String)handle.getName());
        IChoice[] choices = styleHandle.getChoices("fontFamily");
        DesignElementHandleTest.assertNotNull((Object)choices);
        DesignElementHandleTest.assertEquals((int)5, (int)choices.length);
        choices = styleHandle.getChoices("masterPage");
        DesignElementHandleTest.assertNull((Object)choices);
        Iterator iterator = styleHandle.clientsIterator();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        DesignElementHandleTest.assertEquals((int)2, (int)count);
        Iterator iteratorDerived = styleHandle.derivedIterator();
        count = 0;
        while (iteratorDerived.hasNext()) {
            ++count;
            iteratorDerived.next();
        }
        DesignElementHandleTest.assertEquals((int)0, (int)count);
    }

    public void testExtends() throws Exception {
        DesignElementHandle label4Handle = this.designHandle.findElement("bodyLabel4");
        DesignElementHandle parentHandle = label4Handle.getExtends();
        DesignElementHandleTest.assertEquals((String)"base", (String)parentHandle.getName());
        label4Handle = this.designHandle.findElement("label3");
        parentHandle = label4Handle.getExtends();
        DesignElementHandleTest.assertEquals((String)"child1", (String)parentHandle.getName());
        parentHandle = parentHandle.getExtends();
        DesignElementHandleTest.assertEquals((String)"base", (String)parentHandle.getName());
        label4Handle = this.designHandle.findElement("label2");
        label4Handle.setExtendsName("base");
        DesignElementHandleTest.assertEquals((String)"base", (String)label4Handle.getExtends().getName());
        label4Handle.setExtendsName(null);
        DesignElementHandleTest.assertNull((Object)label4Handle.getExtends());
        label4Handle.setExtends(parentHandle);
        DesignElementHandleTest.assertEquals((String)"base", (String)label4Handle.getExtends().getName());
        label4Handle.setExtends(null);
        DesignElementHandleTest.assertNull((Object)label4Handle.getExtends());
        label4Handle = this.designHandle.findElement("label3");
        parentHandle = label4Handle.getExtends();
        label4Handle.setExtendsElement(parentHandle.getElement());
        label4Handle.setExtendsElement(null);
        DesignElementHandleTest.assertNull((Object)label4Handle.getExtends());
    }

    public void testChoice() {
        DesignElementHandle handle = this.designHandle.findElement("bodyLabel1");
        IChoice[] choices = handle.getChoices("text");
        DesignElementHandleTest.assertNull((Object)choices);
        choices = handle.getChoices("fontFamily");
        DesignElementHandleTest.assertNotNull((Object)choices);
        DesignElementHandleTest.assertEquals((int)5, (int)choices.length);
        choices = handle.getChoices("contentType");
        DesignElementHandleTest.assertNull((Object)choices);
    }

    public void testOtherMethods() throws Exception {
        DesignElementHandle handle = this.designHandle.findElement("bodyLabel1");
        SlotHandle slotHandle = this.designHandle.getComponents();
        handle.moveTo(slotHandle.getElementHandle(), 5);
        DesignElementHandleTest.assertEquals((Object)handle.getModuleHandle(), (Object)handle.getContainer());
        DesignElementHandleTest.assertEquals((int)5, (int)handle.getContainerSlotHandle().getSlotID());
        PropertyIterator iterator = handle.getPropertyIterator();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        handle.dropAndClear();
        DesignElementHandleTest.assertNull((Object)handle.getContainer());
        handle = this.designHandle.findElement("bodyLabel1");
        DesignElementHandleTest.assertNull((Object)handle);
        handle = (LabelHandle)this.designHandle.findElement("bodyLabel5");
        DesignElementHandleTest.assertEquals((String)"bodyLabel5", (String)handle.getDisplayLabel());
        DesignElementHandleTest.assertEquals((String)"bodyLabel5", (String)handle.getDisplayLabel(0));
        DesignElementHandleTest.assertEquals((String)"bodyLabel5", (String)handle.getDisplayLabel(1));
        DesignElementHandleTest.assertEquals((String)"bodyLabel5(\"Fifth Label in body.\")", (String)handle.getDisplayLabel(2));
    }

    public void testUndoMoveToMethod() throws Exception {
        this.openDesign("DesignElementHandleMoveTo.xml", ULocale.ENGLISH);
        DesignElementHandle handle = this.designHandle.getElementByID(39L);
        DesignElementHandle oldContianer = handle.getContainer();
        handle.moveTo((DesignElementHandle)this.designHandle, 5);
        this.designHandle.getCommandStack().undo();
        handle = this.designHandle.getElementByID(39L);
        DesignElementHandle newContainer = handle.getContainer();
        DesignElementHandleTest.assertEquals((Object)oldContianer, (Object)newContainer);
    }

    public void testContainment() throws SemanticException {
        this.createDesign();
        CommandStack stack = this.designHandle.getCommandStack();
        ElementFactory factory = this.designHandle.getElementFactory();
        FreeFormHandle section1 = factory.newFreeForm(null);
        SlotHandle slot = this.designHandle.getBody();
        DesignElementHandleTest.assertEquals((int)slot.getCount(), (int)0);
        this.designHandle.getBody().add((DesignElementHandle)section1);
        DesignElementHandleTest.assertEquals((Object)section1, (Object)slot.get(0));
        NameSpace ns = this.design.getNameHelper().getNameSpace("element");
        DesignElementHandleTest.assertEquals((int)0, (int)ns.getCount());
        DesignElementHandleTest.assertEquals((Object)this.design, (Object)section1.getContainer());
        stack.undo();
        DesignElementHandleTest.assertEquals((int)0, (int)slot.getCount());
        DesignElementHandleTest.assertNull((Object)section1.getContainer());
        stack.redo();
        DesignElementHandleTest.assertEquals((int)1, (int)slot.getCount());
        DesignElementHandleTest.assertEquals((Object)section1, (Object)slot.get(0));
        DesignElementHandleTest.assertEquals((Object)this.design, (Object)section1.getContainer());
        FreeFormHandle section2 = factory.newFreeForm("Section2");
        this.designHandle.getBody().add((DesignElementHandle)section2);
        DesignElementHandleTest.assertEquals((int)2, (int)slot.getCount());
        DesignElementHandleTest.assertEquals((int)1, (int)ns.getCount());
        DesignElementHandleTest.assertEquals((Object)section2, (Object)this.designHandle.findElement("Section2"));
        DesignElementHandleTest.assertEquals((Object)this.design, (Object)section2.getContainer());
        FreeFormHandle container1 = factory.newFreeForm(null);
        slot = section1.getReportItems();
        DesignElementHandleTest.assertNotNull((Object)slot);
        DesignElementHandleTest.assertEquals((int)slot.getCount(), (int)0);
        section1.getReportItems().add((DesignElementHandle)container1);
        DesignElementHandleTest.assertEquals((int)slot.getCount(), (int)1);
        DesignElementHandleTest.assertEquals((Object)slot.get(0), (Object)container1);
        DesignElementHandleTest.assertEquals((Object)container1.getContainer(), (Object)section1);
        stack.undo();
        DesignElementHandleTest.assertEquals((int)slot.getCount(), (int)0);
        DesignElementHandleTest.assertNull((Object)container1.getContainer());
        stack.redo();
        DesignElementHandleTest.assertEquals((int)slot.getCount(), (int)1);
        DesignElementHandleTest.assertEquals((Object)slot.get(0), (Object)container1);
        DesignElementHandleTest.assertEquals((Object)container1.getContainer(), (Object)section1);
        FreeFormHandle container2 = factory.newFreeForm("Sample");
        slot = section2.getReportItems();
        section2.getReportItems().add((DesignElementHandle)container2);
        DesignElementHandleTest.assertEquals((int)slot.getCount(), (int)1);
        DesignElementHandleTest.assertEquals((Object)slot.get(0), (Object)container2);
        DesignElementHandleTest.assertEquals((Object)this.design.findElement("Sample"), (Object)container2);
        DesignElementHandleTest.assertEquals((Object)container2.getContainer(), (Object)section2);
        SimpleMasterPageHandle masterPageHandle = factory.newSimpleMasterPage("masterPage");
        this.designHandle.getMasterPages().add((DesignElementHandle)masterPageHandle);
        try {
            FreeFormHandle freeForm1 = factory.newFreeForm("form1");
            FreeFormHandle freeForm2 = factory.newFreeForm("form2");
            masterPageHandle.getSlot(0).add((DesignElementHandle)freeForm1);
            masterPageHandle.getSlot(0).add((DesignElementHandle)freeForm2);
            DesignElementHandleTest.fail();
        }
        catch (ContentException e) {
            DesignElementHandleTest.assertEquals((Object)masterPageHandle.getElement(), (Object)e.getElement());
            DesignElementHandleTest.assertEquals((int)e.getSlot(), (int)0);
            DesignElementHandleTest.assertEquals((String)e.getErrorCode(), (String)"Error.ContentException.SLOT_IS_FULL");
        }
        LabelHandle label1 = factory.newLabel(null);
        try {
            this.designHandle.getStyles().add((DesignElementHandle)label1);
            DesignElementHandleTest.fail();
        }
        catch (ContentException e) {
            DesignElementHandleTest.assertEquals((Object)e.getElement(), (Object)this.design);
            DesignElementHandleTest.assertEquals((int)e.getSlot(), (int)0);
            DesignElementHandleTest.assertEquals((String)e.getErrorCode(), (String)"Error.ContentException.WRONG_TYPE");
        }
        try {
            SlotHandle sh = new SlotHandle((DesignElementHandle)this.designHandle, 50);
            sh.add((DesignElementHandle)label1);
            DesignElementHandleTest.fail();
        }
        catch (ContentException e) {
            DesignElementHandleTest.assertEquals((Object)e.getElement(), (Object)this.design);
            DesignElementHandleTest.assertEquals((int)e.getSlot(), (int)50);
            DesignElementHandleTest.assertEquals((String)e.getErrorCode(), (String)"Error.ContentException.SLOT_NOT_FOUND");
        }
        label1 = factory.newLabel("Label1");
        container1.getReportItems().add((DesignElementHandle)label1);
        slot = container1.getReportItems();
        DesignElementHandleTest.assertNotNull((Object)slot);
        DesignElementHandleTest.assertEquals((int)slot.getCount(), (int)1);
        DesignElementHandleTest.assertEquals((Object)slot.get(0), (Object)label1);
        DesignElementHandleTest.assertTrue((boolean)ns.contains("Label1"));
        DesignElementHandleTest.assertEquals((Object)container1, (Object)label1.getContainer());
        LabelHandle label2 = factory.newLabel(null);
        try {
            SlotHandle sh = new SlotHandle((DesignElementHandle)label1, 0);
            sh.add(label2.getElement().getHandle((Module)this.design));
            DesignElementHandleTest.fail();
        }
        catch (ContentException e) {
            DesignElementHandleTest.assertEquals((Object)label1.getElement(), (Object)e.getElement());
            DesignElementHandleTest.assertEquals((int)e.getSlot(), (int)0);
            DesignElementHandleTest.assertEquals((String)e.getErrorCode(), (String)"Error.ContentException.NOT_CONTAINER");
        }
        SharedStyleHandle style = factory.newStyle("Foo");
        style.getElement().setName(null);
        this.designHandle.getStyles().add((DesignElementHandle)style);
        DesignElementHandleTest.assertTrue((style.getName() != null ? 1 : 0) != 0);
        style = factory.newStyle("My_Style");
        this.designHandle.getStyles().add((DesignElementHandle)style);
    }

    public void testPropertyMethods() throws Exception {
        LabelHandle handle = (LabelHandle)this.designHandle.findElement("bodyLabel1");
        ULocale locale = handle.getModule().getLocale();
        NumberFormatter numberFormatter = new NumberFormatter(locale);
        SharedStyleHandle styleHandle = handle.getStyle();
        DesignElementHandleTest.assertFalse((boolean)styleHandle.getBooleanProperty("canShrink"));
        DimensionHandle dimensionHandle = handle.getDimensionProperty("x");
        DesignElementHandleTest.assertNotNull((Object)dimensionHandle);
        DesignElementHandleTest.assertEquals((String)"1mm", (String)dimensionHandle.getStringValue());
        handle.setStringProperty("x", "11mm");
        DesignElementHandleTest.assertEquals((String)"11mm", (String)dimensionHandle.getStringValue());
        handle.setStringProperty("x", numberFormatter.format(12.3) + "pc");
        DesignElementHandleTest.assertEquals((String)"12.3pc", (String)dimensionHandle.getStringValue());
        ColorHandle colorHandle = styleHandle.getColorProperty("color");
        DesignElementHandleTest.assertNotNull((Object)colorHandle);
        DesignElementHandleTest.assertEquals((String)"red", (String)colorHandle.getCssValue());
        DataSetHandle dataSethandle = this.designHandle.findDataSet("firstDataSet");
        DesignElementHandle elementHandle = dataSethandle.getElementProperty("dataSource");
        DesignElementHandleTest.assertEquals((String)"myDataSource", (String)elementHandle.getName());
        FactoryPropertyHandle factoryHandle = styleHandle.getFactoryPropertyHandle("canShrink");
        DesignElementHandleTest.assertNull((Object)factoryHandle);
        factoryHandle = styleHandle.getFactoryPropertyHandle("masterPage");
        DesignElementHandleTest.assertNull((Object)factoryHandle);
        factoryHandle = styleHandle.getFactoryPropertyHandle("bookmark");
        DesignElementHandleTest.assertNull((Object)factoryHandle);
        double floatValue = ((DimensionValue)handle.getProperty("width")).getMeasure();
        DesignElementHandleTest.assertTrue((2.0 == floatValue ? 1 : 0) != 0);
        floatValue = ((DimensionValue)handle.getProperty("height")).getMeasure();
        DesignElementHandleTest.assertTrue((0.25 == floatValue ? 1 : 0) != 0);
        FontHandle fontHandle = handle.getPrivateStyle().getFontFamilyHandle();
        DesignElementHandleTest.assertNotNull((Object)fontHandle);
        DesignElementHandleTest.assertEquals((Object)"\"Time New Roman\", \"Arial\"", (Object)fontHandle.getValue());
        fontHandle = styleHandle.getFontFamilyHandle();
        DesignElementHandleTest.assertNotNull((Object)fontHandle);
        DesignElementHandleTest.assertEquals((Object)"\"Time New Roman\", \"Arial\"", (Object)fontHandle.getValue());
        int intValue = styleHandle.getIntProperty("widows");
        DesignElementHandleTest.assertTrue((2 == intValue ? 1 : 0) != 0);
        intValue = handle.getIntProperty("noPropName");
        DesignElementHandleTest.assertTrue((intValue == 0 ? 1 : 0) != 0);
        BigDecimal bigDecimalValue = styleHandle.getNumberProperty("widows");
        DesignElementHandleTest.assertTrue((2 == bigDecimalValue.intValue() ? 1 : 0) != 0);
        bigDecimalValue = handle.getNumberProperty("dataSource");
        DesignElementHandleTest.assertNull((Object)bigDecimalValue);
        String fontNames = (String)handle.getProperty("fontFamily");
        DesignElementHandleTest.assertEquals((String)"\"Time New Roman\", \"Arial\"", (String)fontNames);
        fontNames = handle.getStringProperty("fontFamily");
        DesignElementHandleTest.assertEquals((String)"\"Time New Roman\", \"Arial\"", (String)fontNames);
        PropertyHandle propertyHandle = handle.getPropertyHandle("fontFamily");
        DesignElementHandleTest.assertEquals((String)"\"Time New Roman\", \"Arial\"", (String)propertyHandle.getStringValue());
        String height = handle.getProperty("height").toString();
        DesignElementHandleTest.assertEquals((String)"0.25mm", (String)height);
        height = handle.getStringProperty("height").toString();
        DesignElementHandleTest.assertEquals((String)"0.25mm", (String)height);
        double heightNumber = 1.715;
        handle.setProperty("height", (Object)(numberFormatter.format(heightNumber) + "in"));
        DesignElementHandleTest.assertTrue((heightNumber == handle.getPropertyHandle("height").getFloatValue() ? 1 : 0) != 0);
        styleHandle.setIntProperty("widows", 5);
        DesignElementHandleTest.assertTrue((5 == styleHandle.getIntProperty("widows") ? 1 : 0) != 0);
        try {
            styleHandle.setIntProperty("customXml", 15);
            DesignElementHandleTest.fail();
        }
        catch (PropertyValueException e) {
            DesignElementHandleTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        bigDecimalValue = new BigDecimal(55);
        styleHandle.setNumberProperty("widows", bigDecimalValue);
        DesignElementHandleTest.assertTrue((55 == styleHandle.getNumberProperty("widows").intValue() ? 1 : 0) != 0);
        handle.setProperty("fontFamily", (Object)"Song");
        DesignElementHandleTest.assertEquals((String)"\"Song\"", (String)handle.getStringProperty("fontFamily"));
        handle.setProperty("height", (Object)(numberFormatter.format(2.34) + "cm"));
        DesignElementHandleTest.assertEquals((String)"2.34cm", (String)handle.getStringProperty("height"));
        handle.setStringProperty("height", numberFormatter.format(0.25).substring(1) + "mm");
        DesignElementHandleTest.assertEquals((String)"0.25mm", (String)handle.getStringProperty("height"));
        handle.setProperty("height", (Object)new DimensionValue(2.34, "cm"));
        dimensionHandle = handle.getHeight();
        DesignElementHandleTest.assertEquals((String)"2.34cm", (String)dimensionHandle.getStringValue());
        handle.clearProperty("height");
        DesignElementHandleTest.assertNull((Object)handle.getProperty("height"));
        styleHandle.clearProperty("fontFamily");
        DesignElementHandleTest.assertEquals((Object)"serif", (Object)styleHandle.getProperty("fontFamily"));
        TableHandle table = (TableHandle)this.designHandle.findElement("My table");
        table.setProperty("dataSet", (Object)"NoExistedDataSet");
        DesignElementHandleTest.assertEquals((Object)"NoExistedDataSet", (Object)table.getProperty("dataSet"));
        table.setProperty("dataSet", (Object)"NoExistedDataSet");
        DesignElementHandleTest.assertEquals((Object)"NoExistedDataSet", (Object)table.getProperty("dataSet"));
    }

    public void testSetProperties() throws SemanticException {
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("bodyLabel1");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("height", "12cm");
        properties.put("text", "new Label1");
        properties.put("backgroundColor", "red");
        properties.put("borderLeftStyle", "solid");
        labelHandle.setProperties(properties);
        DesignElementHandleTest.assertEquals((String)"12cm", (String)labelHandle.getHeight().getStringValue());
        DesignElementHandleTest.assertEquals((String)"new Label1", (String)labelHandle.getText());
        DesignElementHandleTest.assertEquals((String)"red", (String)labelHandle.getStringProperty("backgroundColor"));
        DesignElementHandleTest.assertEquals((String)"solid", (String)labelHandle.getStringProperty("borderLeftStyle"));
    }

    public void testClearElements() throws SemanticException {
        GraphicMasterPageHandle pageHandle = (GraphicMasterPageHandle)this.designHandle.findMasterPage("My Page");
        DesignElementHandleTest.assertEquals((int)4, (int)pageHandle.getSlot(0).getCount());
        pageHandle.clearContents(0);
        DesignElementHandleTest.assertEquals((int)0, (int)pageHandle.getSlot(0).getCount());
    }

    public void testClearProperties() throws SemanticException {
        GraphicMasterPageHandle pageHandle = (GraphicMasterPageHandle)this.designHandle.findMasterPage("My Page");
        pageHandle.clearAllProperties();
    }

    public void testAddElement() throws ContentException, NameException {
        GraphicMasterPageHandle pageHandle = (GraphicMasterPageHandle)this.designHandle.findMasterPage("My Page");
        DesignElementHandleTest.assertEquals((int)4, (int)pageHandle.getSlot(0).getCount());
        LabelHandle newLabel = new ElementFactory((Module)this.design).newLabel("American Navy 1921");
        pageHandle.addElement((DesignElementHandle)newLabel, 0);
        DesignElementHandleTest.assertEquals((int)5, (int)pageHandle.getSlot(0).getCount());
        DesignElementHandleTest.assertEquals((int)4, (int)pageHandle.getSlot(0).findPosn((DesignElementHandle)newLabel));
        ImageHandle newImage = new ElementFactory((Module)this.design).newImage("Rock in deep blue sea");
        pageHandle.addElement((DesignElementHandle)newImage, 0, 3);
        DesignElementHandleTest.assertEquals((int)6, (int)pageHandle.getSlot(0).getCount());
        DesignElementHandleTest.assertEquals((int)3, (int)pageHandle.getSlot(0).findPosn((DesignElementHandle)newImage));
    }

    public void testBroadCast() throws Exception {
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("My table");
        BroadCast1Listener containerListener = new BroadCast1Listener();
        RowHandle rowHandle = (RowHandle)tableHandle.getDetail().get(0);
        rowHandle.addListener((Listener)containerListener);
        rowHandle.dropAndClear();
        DesignElementHandleTest.assertNotNull((Object)rowHandle);
        rowHandle = (RowHandle)tableHandle.getDetail().get(0);
        BroadCast2Listener listener2 = new BroadCast2Listener();
        rowHandle.addListener((Listener)listener2);
        rowHandle.dropAndClear();
        DesignElementHandleTest.assertNotNull((Object)rowHandle);
    }

    public void testSemanticCheck() throws DesignFileException {
        this.openDesign("DesignElementHandleTest_1.xml");
        DesignElementHandleTest.assertEquals((int)1, (int)this.designHandle.getErrorList().size());
        OdaDataSourceHandle dataSourceHandle = (OdaDataSourceHandle)this.designHandle.findDataSource("myDataSource");
        DesignElementHandleTest.assertNotNull((Object)dataSourceHandle);
        List list = dataSourceHandle.semanticCheck();
        DesignElementHandleTest.assertEquals((int)0, (int)list.size());
        DesignElementHandle myTable = this.designHandle.findElement("myTable");
        MyListener myListener = new MyListener();
        this.designHandle.addValidationListener((IValidationListener)myListener);
        this.designHandle.checkReport();
        list = this.design.getAllErrors();
        DesignElementHandleTest.assertEquals((int)4, (int)list.size());
        DesignElementHandleTest.assertEquals((String)"Error.SemanticError.UNSUPPORTED_ELEMENT", (String)((ErrorDetail)list.get(0)).getErrorCode());
        DesignElementHandleTest.assertEquals((String)"Error.SemanticError.UNSUPPORTED_ELEMENT", (String)((ErrorDetail)list.get(1)).getErrorCode());
        DesignElementHandleTest.assertEquals((String)"Error.SemanticError.UNSUPPORTED_ELEMENT", (String)((ErrorDetail)list.get(2)).getErrorCode());
        DesignElementHandleTest.assertEquals((String)"Error.SemanticError.MISSING_DATA_SET", (String)((ErrorDetail)list.get(3)).getErrorCode());
        DesignElementHandleTest.assertEquals((int)1, (int)this.designHandle.getErrorList().size());
        DesignElementHandleTest.assertEquals((int)3, (int)this.designHandle.getWarningList().size());
        list = myTable.getSemanticErrors();
        DesignElementHandleTest.assertEquals((int)1, (int)list.size());
        DesignElementHandleTest.assertEquals((String)"Error.SemanticError.MISSING_DATA_SET", (String)((ErrorDetail)list.get(0)).getErrorCode());
        list = myListener.errorList;
        DesignElementHandleTest.assertEquals((int)1, (int)list.size());
        DesignElementHandleTest.assertEquals((String)"Error.SemanticError.MISSING_DATA_SET", (String)((ErrorDetail)list.get(0)).getErrorCode());
        this.designHandle.removeValidationListener((IValidationListener)myListener);
    }

    public void testValidAndHasValidationError() throws DesignFileException {
        this.openDesign("DesignElementHandleTest_1.xml");
        DesignElementHandleTest.assertEquals((int)1, (int)this.designHandle.getErrorList().size());
        OdaDataSourceHandle dataSourceHandle = (OdaDataSourceHandle)this.designHandle.findDataSource("myDataSource");
        DesignElementHandleTest.assertNotNull((Object)dataSourceHandle);
        List list = dataSourceHandle.semanticCheck();
        DesignElementHandleTest.assertEquals((int)0, (int)list.size());
        DesignElementHandleTest.assertTrue((boolean)dataSourceHandle.isValid());
        DesignElementHandleTest.assertFalse((boolean)dataSourceHandle.hasSemanticError());
        dataSourceHandle.setValid(false);
        DesignElementHandleTest.assertFalse((boolean)dataSourceHandle.isValid());
        DesignElementHandleTest.assertFalse((boolean)dataSourceHandle.hasSemanticError());
        DesignElementHandle myTable = this.designHandle.findElement("myTable");
        this.designHandle.checkReport();
        DesignElementHandleTest.assertTrue((boolean)myTable.isValid());
        DesignElementHandleTest.assertTrue((boolean)myTable.hasSemanticError());
    }

    public void testCanContainTableHeader() throws SemanticException {
        this.createDesign();
        ElementFactory factory = new ElementFactory((Module)this.design);
        DesignElementHandleTest.assertTrue((boolean)this.designHandle.canContain(3, (DesignElementHandle)factory.newOdaDataSet(null, null)));
        DesignElementHandleTest.assertFalse((boolean)this.designHandle.canContain(6, (DesignElementHandle)factory.newOdaDataSet(null, null)));
        DesignElementHandleTest.assertFalse((boolean)this.designHandle.canContain(3, (DesignElementHandle)factory.newOdaDataSource(null, null)));
        FreeFormHandle form = factory.newFreeForm(null);
        this.designHandle.getBody().add((DesignElementHandle)form);
        DesignElementHandleTest.assertFalse((boolean)form.canContain(0, (DesignElementHandle)factory.newOdaDataSet(null, null)));
        DesignElementHandleTest.assertFalse((boolean)form.canContain(0, (DesignElementHandle)factory.newCell()));
        DesignElementHandleTest.assertTrue((boolean)form.canContain(0, (DesignElementHandle)factory.newList(null)));
        DesignElementHandleTest.assertFalse((boolean)form.canContain(0, null));
        DesignElementHandleTest.assertFalse((boolean)form.canContain(0, null));
        DesignElementHandleTest.assertFalse((boolean)form.canContain(-1, null));
        TableHandle table = factory.newTableItem(null, 1);
        RowHandle row = (RowHandle)table.getHeader().get(0);
        DesignElementHandleTest.assertTrue((boolean)row.canContain(0, "Cell"));
        DesignElementHandleTest.assertFalse((boolean)row.canContain(-1, (DesignElementHandle)factory.newCell()));
        row = factory.newTableRow();
        CellHandle cell = factory.newCell();
        cell.addElement((DesignElementHandle)factory.newTableItem(null), 0);
        row.addElement((DesignElementHandle)cell, 0);
        DesignElementHandleTest.assertFalse((boolean)table.canContain(0, (DesignElementHandle)row));
        row = (RowHandle)table.getHeader().get(0);
        cell = (CellHandle)row.getSlot(0).get(0);
        DesignElementHandleTest.assertFalse((boolean)cell.canContain(0, "Table"));
        DesignElementHandleTest.assertFalse((boolean)cell.canContain(0, (DesignElementHandle)factory.newTableItem(null)));
        DesignElementHandleTest.assertTrue((boolean)cell.canContain(0, (DesignElementHandle)factory.newFreeForm(null)));
        DesignElementHandleTest.assertFalse((boolean)cell.canContain(0, (DesignElementHandle)factory.newList(null)));
        DesignElementHandleTest.assertFalse((boolean)cell.canContain(0, "List"));
        form.addElement((DesignElementHandle)factory.newTableItem(null), 0);
        DesignElementHandleTest.assertFalse((boolean)cell.canContain(0, (DesignElementHandle)form));
        DesignElementHandleTest.assertTrue((boolean)cell.canContain(0, "FreeForm"));
        form = factory.newFreeForm(null);
        cell.addElement((DesignElementHandle)form, 0);
        DesignElementHandleTest.assertFalse((boolean)form.canContain(0, (DesignElementHandle)factory.newTableItem(null)));
        DesignElementHandleTest.assertFalse((boolean)form.canContain(0, "Table"));
        row = (RowHandle)table.getFooter().get(0);
        cell = (CellHandle)row.getSlot(0).get(0);
        DesignElementHandleTest.assertTrue((boolean)cell.canContain(0, "Table"));
        form = factory.newFreeForm(null);
        form.addElement((DesignElementHandle)factory.newTableItem(null), 0);
        DesignElementHandleTest.assertTrue((boolean)cell.canContain(0, (DesignElementHandle)form));
        DesignElementHandleTest.assertTrue((boolean)cell.canContain(0, "FreeForm"));
        form = factory.newFreeForm(null);
        cell.addElement((DesignElementHandle)form, 0);
        DesignElementHandleTest.assertTrue((boolean)form.canContain(0, (DesignElementHandle)factory.newTableItem(null)));
        DesignElementHandleTest.assertTrue((boolean)form.canContain(0, "Table"));
    }

    public void testCanContainGroupName() throws SemanticException {
        this.createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle table = factory.newTableItem("table", 1);
        TableGroupHandle tableGroup = factory.newTableGroup();
        tableGroup.setName("Group1");
        DesignElementHandleTest.assertTrue((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        table.getGroups().add((DesignElementHandle)tableGroup);
        DesignElementHandleTest.assertFalse((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        tableGroup = factory.newTableGroup();
        tableGroup.setName("Group2");
        DesignElementHandleTest.assertTrue((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        OdaDataSourceHandle dataSource = factory.newOdaDataSource(null, null);
        OdaDataSetHandle dataSet = factory.newOdaDataSet(null, null);
        dataSet.setDataSource(dataSource.getName());
        table.setDataSet((DataSetHandle)dataSet);
        this.designHandle.getDataSources().add((DesignElementHandle)dataSource);
        this.designHandle.getDataSets().add((DesignElementHandle)dataSet);
        DesignElementHandleTest.assertTrue((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        table.getGroups().add((DesignElementHandle)tableGroup);
        DesignElementHandleTest.assertFalse((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
        tableGroup = factory.newTableGroup();
        tableGroup.setName("Group1");
        DesignElementHandleTest.assertFalse((boolean)table.canContain(1, (DesignElementHandle)tableGroup));
    }

    public void testCanContain() throws SemanticException {
        this.createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        LabelHandle label = this.designHandle.getElementFactory().newLabel(null);
        label.setName("newLabel");
        DesignElementHandleTest.assertFalse((boolean)this.designHandle.canContain(4, (DesignElementHandle)label));
        DesignElementHandleTest.assertFalse((boolean)this.designHandle.getMasterPages().canContain((DesignElementHandle)label));
        GraphicMasterPageHandle page = this.designHandle.getElementFactory().newGraphicMasterPage(null);
        DesignElementHandleTest.assertTrue((boolean)this.designHandle.canContain(4, (DesignElementHandle)page));
        DesignElementHandleTest.assertTrue((boolean)this.designHandle.getMasterPages().canContain((DesignElementHandle)page));
        this.designHandle.getMasterPages().add((DesignElementHandle)page);
        DesignElementHandleTest.assertTrue((boolean)this.designHandle.canContain(4, (DesignElementHandle)page));
        DesignElementHandleTest.assertTrue((boolean)this.designHandle.getMasterPages().canContain((DesignElementHandle)page));
        DesignElementHandleTest.assertTrue((boolean)this.designHandle.getComponents().canContain((DesignElementHandle)label));
        DesignElementHandleTest.assertTrue((boolean)this.designHandle.getComponents().canContain("Grid"));
        DesignElementHandleTest.assertTrue((boolean)this.designHandle.canContain(5, "Grid"));
        this.designHandle.getComponents().add((DesignElementHandle)label);
        DesignElementHandleTest.assertTrue((boolean)this.designHandle.canContain(5, (DesignElementHandle)label));
        this.designHandle.getComponents().canContain("Grid");
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table1", 3, 1, 1, 1);
        RowHandle row = (RowHandle)table.getDetail().get(0);
        CellHandle cell = (CellHandle)row.getCells().get(0);
        DesignElementHandleTest.assertFalse((boolean)cell.canContain(0, (DesignElementHandle)table));
    }

    public void testGetPath() throws SemanticException {
        DesignElementHandle element = this.designHandle.findElement("bodyLabel3");
        DesignElementHandleTest.assertEquals((String)"/report/body/label[@id=\"15\"]", (String)element.getXPath());
        TableHandle table = (TableHandle)this.designHandle.findElement("My table");
        RowHandle row = (RowHandle)table.getDetail().get(1);
        DesignElementHandleTest.assertEquals((String)"/report/body/table[@id=\"22\"]/detail/row[@id=\"28\"]", (String)row.getXPath());
        DesignElementHandleTest.assertEquals((String)"/report/body/table[@id=\"22\"]/detail/row[@id=\"28\"]/cell[@id=\"29\"]", (String)row.getCells().get(0).getXPath());
        element = this.designHandle.findElement("text2");
        DesignElementHandleTest.assertEquals((String)"/report/body/table[@id=\"18\"]/detail/row[@id=\"19\"]/cell[@id=\"20\"]/text[@id=\"21\"]", (String)element.getXPath());
        SharedStyleHandle style = this.designHandle.findStyle("My-Style");
        DesignElementHandleTest.assertEquals((String)"/report/styles/style[@id=\"4\"]", (String)style.getXPath());
        style = this.designHandle.findStyle("Style1");
        DesignElementHandleTest.assertEquals((String)"/report/styles/style[@id=\"5\"]", (String)style.getXPath());
        MasterPageHandle page = this.designHandle.findMasterPage("My Page");
        DesignElementHandleTest.assertEquals((String)"/report/page-setup/graphic-master-page[@id=\"8\"]", (String)page.getXPath());
    }

    public void testIsDirectionRTL() throws Exception {
        LabelHandle bodyLabel1 = (LabelHandle)this.designHandle.findElement("bodyLabel1");
        DesignElementHandleTest.assertTrue((boolean)bodyLabel1.isDirectionRTL());
        LabelHandle bodyLabel2 = (LabelHandle)this.designHandle.findElement("bodyLabel2");
        DesignElementHandleTest.assertFalse((boolean)bodyLabel2.isDirectionRTL());
        TableHandle tabl1 = (TableHandle)this.designHandle.findElement("My table");
        DesignElementHandleTest.assertTrue((boolean)tabl1.isDirectionRTL());
    }

    public void testInTemplateParameterDefinition() throws Exception {
        this.openDesign("DesignElementHandleTest_2.xml");
        DesignElementHandle table = this.designHandle.getElementByID(41L);
        DesignElementHandleTest.assertTrue((boolean)table.isInTemplateParameter());
    }

    public void testCanContainElementSharesBinding() throws Exception {
        this.openDesign("DesignElementHandleTest_3.xml");
        TableHandle table1 = (TableHandle)this.designHandle.findElement("Table1");
        DesignElementHandleTest.assertNotNull((Object)table1);
        TableHandle table2 = (TableHandle)this.designHandle.findElement("Table2");
        DesignElementHandleTest.assertNotNull((Object)table2);
        TableHandle table3 = (TableHandle)this.designHandle.findElement("Table3");
        DesignElementHandleTest.assertNotNull((Object)table3);
        DesignElementHandleTest.assertFalse((boolean)this.getCell(table1).canContain(0, (DesignElementHandle)table2));
        DesignElementHandleTest.assertFalse((boolean)this.getCell(table2).canContain(0, (DesignElementHandle)table1));
        DesignElementHandleTest.assertFalse((boolean)this.getCell(table3).canContain(0, (DesignElementHandle)table1));
        DesignElementHandleTest.assertTrue((boolean)this.getCell(table1).canContain(0, (DesignElementHandle)table3));
    }

    private CellHandle getCell(TableHandle table) {
        RowHandle row = (RowHandle)table.getDetail().get(0);
        return (CellHandle)row.getCells().get(0);
    }

    class BroadCast1Listener
    implements Listener {
        BroadCast1Listener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            if (ev.getEventType() == 0) {
                focus.removeListener((Listener)this);
            }
        }
    }

    class BroadCast2Listener
    implements Listener {
        protected int flag = 0;

        BroadCast2Listener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            if (ev.getEventType() == 0) {
                ++this.flag;
            }
        }
    }

    class MyListener
    implements IValidationListener {
        protected List errorList = null;

        MyListener() {
        }

        public void elementValidated(DesignElementHandle targetElement, ValidationEvent ev) {
            this.errorList = ev.getErrors();
        }
    }
}

