/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.computation;

import junit.framework.TestCase;
import org.eclipse.birt.chart.computation.Vector;
import org.eclipse.birt.chart.model.attribute.impl.Angle3DImpl;

public class VectorTest
extends TestCase {
    Vector v1;
    Vector v2;
    Vector v3;

    protected void setUp() throws Exception {
        this.v1 = new Vector();
        this.v2 = new Vector(1.0, 2.0, 3.0, false);
        this.v3 = new Vector(0.0, 3.0, 4.0);
    }

    protected void tearDown() throws Exception {
        this.v1 = null;
        this.v2 = null;
    }

    public void testSetAndGet() {
        this.v1.set(5.0, 5.0, 5.0);
        int i = 0;
        while (i < 3) {
            VectorTest.assertTrue((this.v1.get(i) == 5.0 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testAdd() {
        this.v1.add(this.v2);
        int i = 0;
        while (i < 3) {
            VectorTest.assertTrue((this.v1.get(i) == (double)(i + 1) ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testSub() {
        this.v1.sub(this.v2);
        int i = 0;
        while (i < 3) {
            VectorTest.assertTrue((this.v1.get(i) == (double)(-(i + 1)) ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testScale() {
        this.v2.scale(2.0);
        int i = 0;
        while (i < 3) {
            VectorTest.assertTrue((this.v2.get(i) == (double)(2 * (i + 1)) ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testPerspective() {
        this.v2.perspective(3.0);
        VectorTest.assertTrue((this.v2.get(0) == 1.0 ? 1 : 0) != 0);
        VectorTest.assertTrue((this.v2.get(1) == 2.0 ? 1 : 0) != 0);
        VectorTest.assertTrue((this.v2.get(2) == -0.3333333333333333 ? 1 : 0) != 0);
    }

    public void testIsPoint() {
        VectorTest.assertTrue((boolean)this.v1.isPoint());
        VectorTest.assertFalse((boolean)this.v2.isPoint());
    }

    public void testCrossProduct() {
        this.v1 = this.v2.crossProduct(this.v3);
        VectorTest.assertTrue((this.v1.get(0) == -1.0 ? 1 : 0) != 0);
        VectorTest.assertTrue((this.v1.get(1) == -4.0 ? 1 : 0) != 0);
        VectorTest.assertTrue((this.v1.get(2) == 3.0 ? 1 : 0) != 0);
    }

    public void testScaleProduct() {
        VectorTest.assertTrue((this.v2.scalarProduct(this.v2) == 14.0 ? 1 : 0) != 0);
    }

    public void testCosineValue() {
        VectorTest.assertTrue((this.v3.cosineValue(this.v3) == 1.0 ? 1 : 0) != 0);
    }

    public void testRotate() {
        this.v2.rotate(Angle3DImpl.create((double)-20.0, (double)45.0, (double)0.0));
        VectorTest.assertTrue((this.v2.get(0) == 2.3020938426523667 ? 1 : 0) != 0);
        VectorTest.assertTrue((this.v2.get(1) == 2.2214053848974857 ? 1 : 0) != 0);
        VectorTest.assertTrue((this.v2.get(2) == 1.9405468444669185 ? 1 : 0) != 0);
    }

    public void testProject() {
        this.v3.project(4);
        VectorTest.assertTrue((this.v3.get(0) == 0.0 ? 1 : 0) != 0);
        VectorTest.assertTrue((this.v3.get(1) == 0.0 ? 1 : 0) != 0);
        VectorTest.assertTrue((this.v3.get(2) == -0.25 ? 1 : 0) != 0);
    }

    public void testInverse() {
        this.v2.inverse();
        int i = 0;
        while (i < 3) {
            VectorTest.assertTrue((this.v2.get(i) == (double)(-(i + 1)) ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testToString() {
        VectorTest.assertEquals((String)"X:0.0,Y:3.0,Z:4.0,PV:1.0", (String)this.v3.toString());
    }
}

