/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

public class ClientAnchorConversions {
    private static final double PIXELS_PER_MILLIMETRES = 3.78;
    private static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
    private static final int UNIT_OFFSET_LENGTH = 7;
    private static final int[] UNIT_OFFSET_MAP;
    private static final double MILLIMETRE_INDENT_FACTOR = 2.38;
    private static final double UNITS_PER_MILLIMETRES = 2.83;

    static {
        int[] nArray = new int[7];
        nArray[1] = 36;
        nArray[2] = 73;
        nArray[3] = 109;
        nArray[4] = 146;
        nArray[5] = 182;
        nArray[6] = 219;
        UNIT_OFFSET_MAP = nArray;
    }

    public static double widthUnits2Millimetres(int widthUnits) {
        int pixels = widthUnits / 256 * 7;
        int offsetWidthUnits = widthUnits % 256;
        return (double)(pixels += Math.round((float)offsetWidthUnits / 36.57143f)) / 3.78;
    }

    public static int millimetres2WidthUnits(double millimetres) {
        int pixels = (int)(millimetres * 3.78);
        int widthUnits = 256 * (pixels / 7);
        return widthUnits += UNIT_OFFSET_MAP[pixels % 7];
    }

    public static int millimetres2HeightPoints(double millimetres) {
        int widthUnits = (int)(millimetres * 2.83);
        return widthUnits;
    }

    public static int millimetres2IndentUnits(double millimetres) {
        int indentUnits = (int)Math.round(millimetres / 2.38);
        return indentUnits;
    }

    public static double pixels2Millimetres(double pixels) {
        return pixels / 3.78;
    }

    public static int millimetres2Pixels(double millimetres) {
        return (int)(millimetres * 3.78);
    }
}

