/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import java.io.IOException;
import org.eclipse.birt.core.preference.IPreferenceChangeListener;
import org.eclipse.birt.core.preference.IPreferences;
import org.eclipse.birt.core.preference.PreferenceChangeEvent;
import org.eclipse.birt.report.designer.ui.preferences.IReportPreferenceFactory;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;

public class PreferenceWrapper
extends EventManager
implements IPreferences {
    private static final int GLOBAL_TYPE = 0;
    private static final int SPECIAL_TYPE = 1;
    private int preferenceType = 0;
    private IReportPreferenceFactory prefs = null;
    private IPreferenceStore prefsStore = null;
    private IProject project = null;

    public PreferenceWrapper(IReportPreferenceFactory prefs, IProject project, IPreferenceStore prefsStore) {
        this.preferenceType = 1;
        this.prefs = prefs;
        this.prefsStore = prefsStore;
        this.project = project;
    }

    public PreferenceWrapper(IPreferenceStore prefsStore) {
        this.preferenceType = 0;
        this.prefsStore = prefsStore;
    }

    public boolean getDefaultBoolean(String name) {
        return this.prefsStore.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.prefsStore.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.prefsStore.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.prefsStore.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.prefsStore.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.prefsStore.getDefaultString(name);
    }

    public boolean getBoolean(String name) {
        Preferences preference;
        if (this.preferenceType == 1 && this.project != null && (preference = this.prefs.getReportPreference(this.project)) != null && preference.contains(name)) {
            return preference.getBoolean(name);
        }
        return this.prefsStore.getBoolean(name);
    }

    public double getDouble(String name) {
        Preferences preference;
        if (this.preferenceType == 1 && this.project != null && (preference = this.prefs.getReportPreference(this.project)) != null && preference.contains(name)) {
            return preference.getDouble(name);
        }
        return this.prefsStore.getDouble(name);
    }

    public float getFloat(String name) {
        Preferences preference;
        if (this.preferenceType == 1 && this.project != null && (preference = this.prefs.getReportPreference(this.project)) != null && preference.contains(name)) {
            return preference.getFloat(name);
        }
        return this.prefsStore.getFloat(name);
    }

    public int getInt(String name) {
        Preferences preference;
        if (this.preferenceType == 1 && this.project != null && (preference = this.prefs.getReportPreference(this.project)) != null && preference.contains(name)) {
            return preference.getInt(name);
        }
        return this.prefsStore.getInt(name);
    }

    public long getLong(String name) {
        Preferences preference;
        if (this.preferenceType == 1 && this.project != null && (preference = this.prefs.getReportPreference(this.project)) != null && preference.contains(name)) {
            return preference.getLong(name);
        }
        return this.prefsStore.getLong(name);
    }

    public String getString(String name) {
        Preferences preference;
        if (this.preferenceType == 1 && this.project != null && (preference = this.prefs.getReportPreference(this.project)) != null && preference.contains(name)) {
            return preference.getString(name);
        }
        return this.prefsStore.getString(name);
    }

    public boolean contains(String name) {
        return this.prefsStore.contains(name);
    }

    public boolean isDefault(String name) {
        if (this.preferenceType == 1 && this.project != null) {
            return this.prefs.hasSpecialSettings(this.project, name);
        }
        return this.prefsStore.isDefault(name);
    }

    public void putValue(String name, String value) {
        this.prefsStore.putValue(name, value);
    }

    public void setDefault(String name, double value) {
        this.prefsStore.setDefault(name, value);
    }

    public void setDefault(String name, float value) {
        this.prefsStore.setDefault(name, value);
    }

    public void setDefault(String name, int value) {
        this.prefsStore.setDefault(name, value);
    }

    public void setDefault(String name, long value) {
        this.prefsStore.setDefault(name, value);
    }

    public void setDefault(String name, String defaultObject) {
        this.prefsStore.setDefault(name, defaultObject);
    }

    public void setDefault(String name, boolean value) {
        this.prefsStore.setDefault(name, value);
    }

    public void setToDefault(String name) {
        if (this.preferenceType == 1 && this.project != null) {
            Preferences preference = this.prefs.getReportPreference(this.project);
            preference.setToDefault(name);
            this.firePreferenceChangeEvent("special to default", null, null);
        } else {
            String oldValue = this.prefsStore.getString(name);
            this.prefsStore.setToDefault(name);
            this.firePreferenceChangeEvent(name, oldValue, this.prefsStore.getDefaultString(name));
        }
    }

    public void setValue(String name, double value) {
        Preferences preference;
        double oldValue = this.getDouble(name);
        if (this.preferenceType == 1 && this.project != null && (preference = this.prefs.getReportPreference(this.project)) != null) {
            if (preference.isDefault(name) || oldValue != value) {
                preference.setValue(name, value);
                this.firePreferenceChangeEvent(name, new Double(oldValue), new Double(value));
            }
            return;
        }
        if (oldValue != value) {
            this.prefsStore.setValue(name, value);
            this.firePreferenceChangeEvent(name, new Double(oldValue), new Double(value));
        }
    }

    public void setValue(String name, float value) {
        Preferences preference;
        float oldValue = this.getFloat(name);
        if (this.preferenceType == 1 && this.project != null && (preference = this.prefs.getReportPreference(this.project)) != null) {
            if (preference.isDefault(name) || oldValue != value) {
                preference.setValue(name, value);
                this.firePreferenceChangeEvent(name, new Float(oldValue), new Float(value));
            }
            return;
        }
        if (oldValue != value) {
            this.prefsStore.setValue(name, value);
            this.firePreferenceChangeEvent(name, new Float(oldValue), new Float(value));
        }
    }

    public void setValue(String name, int value) {
        Preferences preference;
        int oldValue = this.getInt(name);
        if (this.preferenceType == 1 && this.project != null && (preference = this.prefs.getReportPreference(this.project)) != null) {
            if (preference.isDefault(name) || oldValue != value) {
                preference.setValue(name, value);
                this.firePreferenceChangeEvent(name, oldValue, value);
            }
            return;
        }
        if (oldValue != value) {
            this.prefsStore.setValue(name, value);
            this.firePreferenceChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, long value) {
        Preferences preference;
        long oldValue = this.getLong(name);
        if (this.preferenceType == 1 && this.project != null && (preference = this.prefs.getReportPreference(this.project)) != null) {
            if (preference.isDefault(name) || oldValue != value) {
                preference.setValue(name, value);
                this.firePreferenceChangeEvent(name, oldValue, value);
            }
            return;
        }
        if (oldValue != value) {
            this.prefsStore.setValue(name, value);
            this.firePreferenceChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, String value) {
        Preferences preference;
        String oldValue = this.getString(name);
        if (this.preferenceType == 1 && this.project != null && (preference = this.prefs.getReportPreference(this.project)) != null) {
            if (preference.isDefault(name) || !oldValue.equals(value)) {
                preference.setValue(name, value);
                this.firePreferenceChangeEvent(name, oldValue, value);
            }
            return;
        }
        if (!oldValue.equals(value)) {
            this.prefsStore.setValue(name, value);
            this.firePreferenceChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, boolean value) {
        Preferences preference;
        boolean oldValue = this.getBoolean(name);
        if (this.preferenceType == 1 && this.project != null && (preference = this.prefs.getReportPreference(this.project)) != null) {
            if (preference.isDefault(name) || oldValue != value) {
                preference.setValue(name, value);
                this.firePreferenceChangeEvent(name, oldValue, value);
            }
            return;
        }
        if (oldValue != value) {
            this.prefsStore.setValue(name, value);
            this.firePreferenceChangeEvent(name, oldValue, value);
        }
    }

    public void save() throws IOException {
        if (this.preferenceType == 1 && this.project != null) {
            this.prefs.saveReportPreference(this.project);
        } else if (this.prefsStore instanceof IPersistentPreferenceStore) {
            ((IPersistentPreferenceStore)this.prefsStore).save();
        }
    }

    public void addPreferenceChangeListener(IPreferenceChangeListener pcl) {
        this.addListenerObject(pcl);
    }

    public void removePreferenceChangeListener(IPreferenceChangeListener pcl) {
        this.removeListenerObject(pcl);
    }

    public void firePreferenceChangeEvent(String name, Object oldValue, Object newValue) {
        Object[] finalListeners = this.getListeners();
        if (!(finalListeners.length <= 0 || oldValue != null && oldValue.equals(newValue))) {
            final PreferenceChangeEvent pe = new PreferenceChangeEvent((IPreferences)this, name, oldValue, newValue);
            int i = 0;
            while (i < finalListeners.length) {
                final IPreferenceChangeListener l = (IPreferenceChangeListener)finalListeners[i];
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(JFaceResources.getString((String)"PreferenceStore.changeError")){

                    public void run() {
                        l.preferenceChange(pe);
                    }
                });
                ++i;
            }
        }
    }

    public IPreferenceStore getPrefsStore() {
        return this.prefsStore;
    }
}

