/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.PlaceHolderEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.LabelFigure;
import org.eclipse.birt.report.designer.internal.ui.views.LabelCellEditor;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

public class LabelEditManager
extends DirectEditManager {
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;
    Font scaledFont;
    private Object model;
    private boolean changed = false;

    public LabelEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
        this.setModel(source.getModel());
    }

    public void setModel(Object model) {
        this.model = model;
    }

    Object getModel() {
        return this.model;
    }

    protected void bringDown() {
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
        if (this.getEditPart() instanceof PlaceHolderEditPart) {
            ((PlaceHolderEditPart)this.getEditPart()).perfrormLabelEdit(this.getChanged());
        }
    }

    private void restoreSavedActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        LabelFigure labelFigure = (LabelFigure)this.getEditPart().getFigure();
        String initialLabelText = ((LabelHandle)this.getModel()).getText();
        if (initialLabelText == null) {
            initialLabelText = "";
        }
        this.getCellEditor().setValue((Object)initialLabelText);
        IFigure figure = this.getEditPart().getFigure();
        this.scaledFont = figure.getFont();
        FontData data = this.scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        labelFigure.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        this.scaledFont = new Font(null, data);
        text.setFont(this.scaledFont);
        text.selectAll();
        this.actionBars = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars();
        this.saveCurrentActions(this.actionBars);
        this.actionHandler = new CellEditorActionHandler(this.actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        this.actionBars.updateActionBars();
    }

    private void saveCurrentActions(IActionBars actionBars) {
        this.copy = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        int style = this.applyBidiStyle(66);
        LabelCellEditor editor = new LabelCellEditor(composite, style);
        final Control c = editor.getControl();
        c.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                c.setCursor(SharedCursors.IBEAM);
            }
        });
        return editor;
    }

    protected void commit() {
        this.setChanged(true);
        super.commit();
    }

    private void setChanged(boolean b) {
        this.changed = b;
    }

    public boolean getChanged() {
        return this.changed;
    }

    private int applyBidiStyle(int style) {
        LabelFigure figure = (LabelFigure)this.getEditPart().getFigure();
        boolean rtl = "rtl".equals(figure.getDirection());
        style |= rtl ? 0x4000000 : 0x2000000;
        String align = figure.getTextAlign();
        style = "center".equals(align) ? (style |= 0x1000000) : ("right".equals(align) ? (style |= rtl ? 16384 : 131072) : ("left".equals(align) ? (style |= rtl ? 131072 : 16384) : (style |= 0x4000)));
        return style;
    }
}

